/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.model.preferences;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.jboss.tools.vpe.browsersim.BrowserSimLogger;
import org.jboss.tools.vpe.browsersim.model.preferences.PreferencesStorage;
import org.jboss.tools.vpe.browsersim.model.preferences.SpecificPreferences;
import org.jboss.tools.vpe.browsersim.util.PreferencesUtil;

public abstract class SpecificPreferencesStorage
implements PreferencesStorage {
    protected static final String PREFERENCES_ORIENTATION_ANGLE = "orientationAngle";
    protected static final String PREFERENCES_LOCATION_Y = "y";
    protected static final String PREFERENCES_LOCATION_X = "x";
    protected static final String PREFERENCES_LOCATION = "location";
    protected static final String PREFERENCES_USE_SKINS = "useSkins";
    protected static final String PREFERENCES_LIVE_RELOAD = "enableLiveReload";
    protected static final String PREFERENCES_LIVE_RELOAD_PORT = "liveReloadPort";
    protected static final String PREFERENCES_TOUCH_EVENTS = "enableTouchEvents";
    protected static final String PREFERENCES_SELECTED_DEVICE = "selectedDeviceId";
    protected static final String PREFERENCES_IS_JAVAFX = "javafx";
    protected static final String PREFERENCES_VERSION = "version";
    public static final int DEFAULT_LIVE_RELOAD_PORT = 35729;

    @Override
    public void save(Object o) {
        File configFolder = new File(PreferencesUtil.getConfigFolderPath());
        configFolder.mkdir();
        File configFile = new File(configFolder, this.getFileName());
        this.save((SpecificPreferences)o, configFile);
    }

    @Override
    public Object load(String configFolder) {
        File customConfigFile = new File(String.valueOf(configFolder) + PreferencesUtil.SEPARATOR + this.getFileName());
        SpecificPreferences specificPreferences = null;
        if (customConfigFile.exists()) {
            try {
                specificPreferences = this.load(new FileInputStream(customConfigFile));
            }
            catch (FileNotFoundException e) {
                BrowserSimLogger.logError(e.getMessage(), e);
            }
        }
        return specificPreferences;
    }

    @Override
    public SpecificPreferences loadDefault() {
        SpecificPreferences specificPreferences = null;
        specificPreferences = this.load(this.getDefaultPreferencesFileAsStream());
        if (specificPreferences == null) {
            specificPreferences = this.createBlankPreferences();
        }
        return specificPreferences;
    }

    protected abstract SpecificPreferencesStorage getInstance();

    protected abstract SpecificPreferences load(InputStream var1);

    protected abstract SpecificPreferences createBlankPreferences();

    protected abstract void save(SpecificPreferences var1, File var2);

    protected abstract String getFileName();

    protected abstract InputStream getDefaultPreferencesFileAsStream();
}

