/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim.model;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class Device {
    public static final int DEFAULT_SIZE = -1;
    public static final DecimalFormat PIXEL_RAIO_FORMAT = new DecimalFormat("0.###");
    private String id;
    private String name;
    private int width;
    private int height;
    private double pixelRatio;
    private String userAgent;
    private String skinId;

    static {
        DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols();
        formatSymbols.setDecimalSeparator('.');
        PIXEL_RAIO_FORMAT.setDecimalFormatSymbols(formatSymbols);
    }

    public Device(String name, int width, int height, double pixelRatio, String userAgent, String skinId) {
        this.name = name;
        this.width = width;
        this.height = height;
        this.pixelRatio = pixelRatio;
        this.userAgent = userAgent;
        this.skinId = skinId;
    }

    public Device(String id, String name, int width, int height, double pixelRatio, String userAgent, String skinId) {
        this(name, width, height, pixelRatio, userAgent, skinId);
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getName() {
        return this.name;
    }

    public String getSkinId() {
        return this.skinId;
    }

    public double getPixelRatio() {
        return this.pixelRatio;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        long temp = Double.doubleToLongBits(this.pixelRatio);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.skinId == null ? 0 : this.skinId.hashCode());
        result = 31 * result + (this.userAgent == null ? 0 : this.userAgent.hashCode());
        result = 31 * result + this.width;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Device other = (Device)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (this.height != other.height) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (Double.doubleToLongBits(this.pixelRatio) != Double.doubleToLongBits(other.pixelRatio)) {
            return false;
        }
        if (this.skinId == null ? other.skinId != null : !this.skinId.equals(other.skinId)) {
            return false;
        }
        if (this.userAgent == null ? other.userAgent != null : !this.userAgent.equals(other.userAgent)) {
            return false;
        }
        return this.width == other.width;
    }
}

