/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.vpe.browsersim.BrowserSimArgs;
import org.jboss.tools.vpe.browsersim.BrowserSimLogger;
import org.jboss.tools.vpe.browsersim.browser.PlatformUtil;
import org.jboss.tools.vpe.browsersim.browser.javafx.JavaFXBrowser;
import org.jboss.tools.vpe.browsersim.devtools.DevToolsDebuggerServer;
import org.jboss.tools.vpe.browsersim.ui.BrowserSim;
import org.jboss.tools.vpe.browsersim.ui.CocoaUIEnhancer;
import org.jboss.tools.vpe.browsersim.ui.ExceptionNotifier;
import org.jboss.tools.vpe.browsersim.ui.Messages;
import org.jboss.tools.vpe.browsersim.util.BrowserSimUtil;

public class BrowserSimRunner {
    public static final String PLUGIN_ID = "org.jboss.tools.vpe.browsersim";
    public static final String NOT_STANDALONE = "-not-standalone";
    public static final String ABOUT_BLANK = "about:blank";
    private static boolean isJavaFxAvailable;
    private static boolean isWebKitAvailable;

    static {
        if ("macosx".equals(PlatformUtil.getOs())) {
            CocoaUIEnhancer.initializeMacOSMenuBar(Messages.BrowserSim_BROWSER_SIM);
        }
        String platform = PlatformUtil.getOs();
        isJavaFxAvailable = false;
        boolean isLinux = "linux".equals(platform);
        if (!isLinux || BrowserSimUtil.isRunningAgainstGTK2()) {
            isJavaFxAvailable = BrowserSimUtil.loadJavaFX();
        }
        isWebKitAvailable = BrowserSimUtil.isWebkitAvailable();
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        display = null;
        try {
            try {
                if (!BrowserSimRunner.isJavaFxAvailable && !BrowserSimRunner.isWebKitAvailable) {
                    errorMessage = "";
                    os = PlatformUtil.getOs();
                    if ("linux".equals(os)) {
                        errorMessage = MessageFormat.format(Messages.BrowserSim_NO_WEB_ENGINES_LINUX, new Object[]{Messages.BrowserSim_BROWSER_SIM});
                        throw new SWTError(errorMessage);
                    } else {
                        if (!"win32".equals(os)) throw new SWTError(errorMessage);
                        errorMessage = MessageFormat.format(Messages.BrowserSim_NO_WEB_ENGINES_WINDOWS, new Object[]{Messages.BrowserSim_BROWSER_SIM});
                    }
                    throw new SWTError(errorMessage);
                }
                browserSimArgs = BrowserSimArgs.parseArgs(args);
                path = browserSimArgs.getPath();
                if (path != null) {
                    try {
                        new URI(path);
                        url = path;
                    }
                    catch (URISyntaxException v0) {
                        url = "about:blank";
                    }
                } else {
                    url = "about:blank";
                }
                parent = null;
                if (!"macosx".equals(PlatformUtil.getOs())) {
                    parent = new Shell(Display.getDefault(), 8);
                    parent.setSize(0, 0);
                    BrowserSimUtil.setShellAttributes(parent);
                    parent.open();
                }
                browserSim = new BrowserSim(url, parent);
                browserSim.open(BrowserSimRunner.isJavaFxAvailable, BrowserSimRunner.isWebKitAvailable);
                if (browserSim.getBrowser() instanceof JavaFXBrowser && !"STARTED".equals(DevToolsDebuggerServer.getServerState())) {
                    DevToolsDebuggerServer.startDebugServer(((JavaFXBrowser)browserSim.getBrowser()).getDebugger());
                }
                display = Display.getDefault();
                if (true) ** GOTO lbl40
                do {
                    if (!display.readAndDispatch()) {
                        display.sleep();
                    }
lbl40:
                    // 4 sources

                    if (display.isDisposed()) return;
                } while (BrowserSim.getInstances().size() > 0);
                return;
            }
            catch (SWTError e) {
                ExceptionNotifier.showBrowserSimLoadError(new Shell(Display.getDefault()), e, Messages.BrowserSim_BROWSER_SIM);
                if (display == null) return;
                display.dispose();
                return;
            }
            catch (Throwable t) {
                BrowserSimLogger.logError(t.getMessage(), t);
                if (display == null) return;
                display.dispose();
                return;
            }
        }
        finally {
            if (display != null) {
                display.dispose();
            }
        }
    }
}

