/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.browsersim;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.tools.vpe.browsersim.BrowserSimLogger;

public class BrowserSimArgs {
    public static final String NOT_STANDALONE = "-not-standalone";
    public static String cofigurationFolder;
    public static boolean standalone;
    public static int debuggerPort;
    private String path;

    private BrowserSimArgs(String path, boolean isStandalone) {
        this.path = path;
        standalone = isStandalone;
    }

    public static BrowserSimArgs parseArgs(String[] args) {
        int configurationParameterIndex;
        ArrayList<String> params = new ArrayList<String>(Arrays.asList(args));
        boolean notStandalone = params.contains(NOT_STANDALONE);
        if (notStandalone) {
            params.remove(NOT_STANDALONE);
        }
        if ((configurationParameterIndex = params.indexOf("-configuration")) >= 0) {
            params.remove(configurationParameterIndex);
            cofigurationFolder = (String)params.remove(configurationParameterIndex);
        }
        String path = null;
        if (params.size() > 0) {
            path = (String)params.get(params.size() - 1);
        }
        try {
            ServerSocket socket = new ServerSocket(0);
            debuggerPort = socket.getLocalPort();
            socket.close();
        }
        catch (IOException e) {
            BrowserSimLogger.logError(e.getMessage(), e);
        }
        return new BrowserSimArgs(path, !notStandalone);
    }

    public String getPath() {
        return this.path;
    }
}

