/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jpt.common.core.internal.utility.jdt.DefaultAnnotationEditFormatter;
import org.eclipse.jpt.common.core.internal.utility.jdt.JDTMember;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.common.core.utility.jdt.FieldAttribute;
import org.eclipse.jpt.common.core.utility.jdt.Type;
import org.eclipse.jpt.common.utility.command.CommandContext;
import org.eclipse.jpt.common.utility.internal.command.DefaultCommandContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTFieldAttribute
extends JDTMember
implements FieldAttribute {
    protected static final FieldDeclaration[] EMPTY_FIELD_DECLARATION_ARRAY = new FieldDeclaration[0];
    protected static final Selector<FieldDeclaration> FIELD_DECLARATION_SELECTOR = new Selector<FieldDeclaration>(){

        @Override
        public FieldDeclaration select(FieldDeclaration fieldDeclaration, VariableDeclarationFragment variableDeclarationFragment) {
            return fieldDeclaration;
        }

        @Override
        public String getDescription() {
            return "field declaration";
        }

        public String toString() {
            return "FIELD_DECLARATION_SELECTOR";
        }
    };
    protected static final Selector<VariableDeclarationFragment> VARIABLE_DECLARATION_FRAGMENT_SELECTOR = new Selector<VariableDeclarationFragment>(){

        @Override
        public VariableDeclarationFragment select(FieldDeclaration fieldDeclaration, VariableDeclarationFragment variableDeclarationFragment) {
            return variableDeclarationFragment;
        }

        @Override
        public String getDescription() {
            return "variable declaration fragment";
        }

        public String toString() {
            return "VARIABLE_DECLARATION_FRAGMENT_SELECTOR";
        }
    };

    public JDTFieldAttribute(Type declaringType, String name, int occurrence, ICompilationUnit compilationUnit, CommandContext modifySharedDocumentCommandContext) {
        this(declaringType, name, occurrence, compilationUnit, modifySharedDocumentCommandContext, (AnnotationEditFormatter)DefaultAnnotationEditFormatter.instance());
    }

    public JDTFieldAttribute(Type declaringType, String name, int occurrence, ICompilationUnit compilationUnit, CommandContext modifySharedDocumentCommandContext, AnnotationEditFormatter annotationEditFormatter) {
        super(declaringType, name, occurrence, compilationUnit, modifySharedDocumentCommandContext, annotationEditFormatter);
    }

    public JDTFieldAttribute(Type declaringType, String name, int occurrence, ICompilationUnit compilationUnit) {
        this(declaringType, name, occurrence, compilationUnit, DefaultCommandContext.instance(), (AnnotationEditFormatter)DefaultAnnotationEditFormatter.instance());
    }

    @Override
    protected Type getDeclaringType() {
        return (Type)super.getDeclaringType();
    }

    @Override
    public FieldDeclaration getBodyDeclaration(CompilationUnit astRoot) {
        return this.getSelectedDeclaration(astRoot, FIELD_DECLARATION_SELECTOR);
    }

    @Override
    public String getAttributeName() {
        return this.getName();
    }

    @Override
    public boolean isField() {
        return true;
    }

    protected TypeDeclaration getDeclaringTypeDeclaration(CompilationUnit astRoot) {
        return this.getDeclaringType().getBodyDeclaration(astRoot);
    }

    protected VariableDeclarationFragment getFragment(CompilationUnit astRoot) {
        return this.getSelectedDeclaration(astRoot, VARIABLE_DECLARATION_FRAGMENT_SELECTOR);
    }

    protected <T extends ASTNode> T getSelectedDeclaration(CompilationUnit astRoot, Selector<T> selector) {
        String name = this.getName();
        int occurrence = this.getOccurrence();
        int count = 0;
        FieldDeclaration[] fieldDeclarationArray = this.getDeclaringTypeFieldDeclarations(astRoot);
        int n = fieldDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            for (VariableDeclarationFragment fragment : JDTFieldAttribute.fragments(fieldDeclaration)) {
                if (!fragment.getName().getFullyQualifiedName().equals(name) || ++count != occurrence) continue;
                return selector.select(fieldDeclaration, fragment);
            }
            ++n2;
        }
        return null;
    }

    protected FieldDeclaration[] getDeclaringTypeFieldDeclarations(CompilationUnit astRoot) {
        TypeDeclaration typeDeclaration = this.getDeclaringTypeDeclaration(astRoot);
        return typeDeclaration == null ? EMPTY_FIELD_DECLARATION_ARRAY : typeDeclaration.getFields();
    }

    protected static List<VariableDeclarationFragment> fragments(FieldDeclaration fd) {
        return fd.fragments();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface Selector<T extends ASTNode> {
        public T select(FieldDeclaration var1, VariableDeclarationFragment var2);

        public String getDescription();
    }
}

