/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeclarationAnnotationAdapter
implements DeclarationAnnotationAdapter {
    private final String annotationName;

    protected AbstractDeclarationAnnotationAdapter(String annotationName) {
        this.annotationName = annotationName;
    }

    @Override
    public MarkerAnnotation newMarkerAnnotation(ModifiedDeclaration declaration) {
        MarkerAnnotation annotation = this.newMarkerAnnotation(declaration.getAst());
        this.addAnnotationAndImport(declaration, (Annotation)annotation);
        return annotation;
    }

    @Override
    public SingleMemberAnnotation newSingleMemberAnnotation(ModifiedDeclaration declaration) {
        SingleMemberAnnotation annotation = this.newSingleMemberAnnotation(declaration.getAst());
        this.addAnnotationAndImport(declaration, (Annotation)annotation);
        return annotation;
    }

    @Override
    public NormalAnnotation newNormalAnnotation(ModifiedDeclaration declaration) {
        NormalAnnotation annotation = this.newNormalAnnotation(declaration.getAst());
        this.addAnnotationAndImport(declaration, (Annotation)annotation);
        return annotation;
    }

    protected void addAnnotationAndImport(ModifiedDeclaration declaration, Annotation annotation) {
        annotation.setTypeName(declaration.getAst().newName(this.getSourceCodeAnnotationName(declaration)));
        this.addAnnotation(declaration, annotation);
    }

    protected String getSourceCodeAnnotationName(ModifiedDeclaration declaration) {
        return declaration.addImport(this.annotationName) ? this.getShortAnnotationName() : this.annotationName;
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (CharSequence)this.annotationName);
    }

    protected abstract void addAnnotation(ModifiedDeclaration var1, Annotation var2);

    public String getAnnotationName() {
        return this.annotationName;
    }

    protected boolean nameMatches(ModifiedDeclaration declaration, Annotation annotation) {
        return this.nameMatches(declaration, annotation, this.annotationName);
    }

    protected boolean nameMatches(ModifiedDeclaration declaration, Annotation annotation, String name) {
        return declaration.annotationIsNamed(annotation, name);
    }

    protected MarkerAnnotation newMarkerAnnotation(AST ast) {
        return this.newMarkerAnnotation(ast, this.annotationName);
    }

    protected MarkerAnnotation newMarkerAnnotation(AST ast, String name) {
        MarkerAnnotation annotation = ast.newMarkerAnnotation();
        annotation.setTypeName(ast.newName(name));
        return annotation;
    }

    protected SingleMemberAnnotation newSingleMemberAnnotation(AST ast) {
        return this.newSingleMemberAnnotation(ast, this.annotationName);
    }

    protected SingleMemberAnnotation newSingleMemberAnnotation(AST ast, String name) {
        SingleMemberAnnotation annotation = ast.newSingleMemberAnnotation();
        annotation.setTypeName(ast.newName(name));
        return annotation;
    }

    protected NormalAnnotation newNormalAnnotation(AST ast) {
        return this.newNormalAnnotation(ast, this.annotationName);
    }

    protected NormalAnnotation newNormalAnnotation(AST ast, String name) {
        NormalAnnotation annotation = ast.newNormalAnnotation();
        annotation.setTypeName(ast.newName(name));
        return annotation;
    }

    protected String getShortAnnotationName() {
        return AbstractDeclarationAnnotationAdapter.convertToShortName(this.annotationName);
    }

    protected static String convertToShortName(String name) {
        return name.substring(name.lastIndexOf(46) + 1);
    }

    protected List<MemberValuePair> values(NormalAnnotation na) {
        return na.values();
    }
}

