/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAttribute;
import org.eclipse.jpt.common.core.internal.utility.jdt.JDTMethodAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.jdt.MethodAttribute;
import org.eclipse.jpt.common.core.utility.jdt.Type;
import org.eclipse.jpt.common.utility.MethodSignature;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SourceMethod
extends SourceAttribute<MethodAttribute>
implements JavaResourceMethod {
    boolean constructor;
    private final Vector<String> parameterTypeNames = new Vector();

    static JavaResourceMethod newInstance(JavaResourceType parent, Type declaringType, MethodSignature signature, int occurrence, JavaResourceCompilationUnit javaResourceCompilationUnit, MethodDeclaration methodDeclaration) {
        JDTMethodAttribute method = JDTMethodAttribute.newInstance(declaringType, signature, occurrence, javaResourceCompilationUnit.getCompilationUnit(), javaResourceCompilationUnit.getModifySharedDocumentCommandContext(), javaResourceCompilationUnit.getAnnotationEditFormatter());
        SourceMethod sm = new SourceMethod(parent, method);
        sm.initialize(methodDeclaration);
        return sm;
    }

    private SourceMethod(JavaResourceType parent, MethodAttribute method) {
        super(parent, method);
    }

    protected void initialize(MethodDeclaration methodDeclaration) {
        super.initialize((ASTNode)methodDeclaration, (Name)methodDeclaration.getName());
        this.initialize(methodDeclaration.resolveBinding());
    }

    protected void initialize(IMethodBinding binding) {
        super.initialize((IBinding)binding);
        this.constructor = this.buildConstructor(binding);
        this.parameterTypeNames.addAll(this.buildParameterTypeNames(binding));
    }

    @Override
    protected ITypeBinding getJdtTypeBinding(IBinding binding) {
        return binding == null ? null : ((IMethodBinding)binding).getReturnType();
    }

    @Override
    public JavaResourceAnnotatedElement.AstNodeType getAstNodeType() {
        return JavaResourceAnnotatedElement.AstNodeType.METHOD;
    }

    public void resolveTypes(MethodDeclaration methodDeclaration) {
        super.resolveTypes((IBinding)methodDeclaration.resolveBinding());
    }

    @Override
    public void synchronizeWith(MethodDeclaration methodDeclaration) {
        super.synchronizeWith((ASTNode)methodDeclaration, (Name)methodDeclaration.getName());
        this.synchronizeWith(methodDeclaration.resolveBinding());
    }

    protected void synchronizeWith(IMethodBinding binding) {
        super.synchronizeWith((IBinding)binding);
        this.syncConstructor(this.buildConstructor(binding));
        this.syncParameterTypeNames(this.buildParameterTypeNames(binding));
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.getMethodName());
    }

    @Override
    public String getMethodName() {
        return ((MethodAttribute)this.annotatedElement).getName();
    }

    @Override
    public ListIterable<String> getParameterTypeNames() {
        return IterableTools.cloneLive(this.parameterTypeNames);
    }

    @Override
    public String getParameterTypeName(int index) {
        return this.parameterTypeNames.get(index);
    }

    @Override
    public int getParametersSize() {
        return this.parameterTypeNames.size();
    }

    private void syncParameterTypeNames(List<String> astParameterTypeNames) {
        this.synchronizeList(astParameterTypeNames, this.parameterTypeNames, "parameterTypeNames");
    }

    private List<String> buildParameterTypeNames(IMethodBinding methodBinding) {
        if (methodBinding == null) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        ITypeBinding[] iTypeBindingArray = methodBinding.getParameterTypes();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding parameterType = iTypeBindingArray[n2];
            if (parameterType.isTypeVariable()) {
                parameterType = parameterType.getErasure();
            }
            String ptName = parameterType.getTypeDeclaration().getQualifiedName();
            names.add(ptName);
            ++n2;
        }
        return names;
    }

    @Override
    public boolean isConstructor() {
        return this.constructor;
    }

    private void syncConstructor(boolean astConstructor) {
        boolean old = this.constructor;
        this.constructor = astConstructor;
        this.firePropertyChanged("constructor", old, astConstructor);
    }

    private boolean buildConstructor(IMethodBinding methodBinding) {
        return methodBinding == null ? false : methodBinding.isConstructor();
    }

    @Override
    public boolean isFor(MethodSignature signature, int occurrence) {
        return ((MethodAttribute)this.annotatedElement).matches(signature, occurrence);
    }
}

