/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate3_6.console;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.util.NLS;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.cfg.Configuration;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.model.impl.ExporterProperty;
import org.hibernate.eclipse.launch.ExporterAttributes;
import org.hibernate.eclipse.launch.PathHelper;
import org.hibernate.tool.hbm2x.ArtifactCollector;
import org.hibernate.tool.hbm2x.Exporter;
import org.hibernate.tool.hbm2x.GenericExporter;
import org.hibernate.tool.hbm2x.Hbm2DDLExporter;
import org.hibernate.tool.hbm2x.QueryExporter;
import org.jboss.tools.hibernate3_6.console.ExporterDefinition;

public class ExporterFactory {
    private ExporterDefinition definition;
    final Map<String, String> inputProperties;
    private boolean enabled = true;
    private final String exporterId;

    public ExporterFactory(ExporterDefinition definition, String exporterId) {
        this.definition = definition;
        this.exporterId = exporterId;
        this.inputProperties = new HashMap<String, String>();
    }

    public Map<String, ExporterProperty> getDefaultExporterProperties() {
        return this.definition.getExporterProperties();
    }

    public String setProperty(String key, String value) {
        return this.inputProperties.put(key, value);
    }

    public void removeProperty(String propertyName) {
        this.inputProperties.remove(propertyName);
    }

    public String getPropertyValue(String key) {
        if (this.inputProperties.containsKey(key)) {
            return this.inputProperties.get(key);
        }
        ExporterProperty ep = this.definition.getExporterProperties().get(key);
        if (ep != null) {
            return ep.getDefaultValue();
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public ExporterDefinition getExporterDefinition() {
        return this.definition;
    }

    public boolean isEnabled(ILaunchConfiguration configuration) {
        boolean enabled = false;
        try {
            enabled = configuration.getAttribute("org.hibernate.tools.exporters", null) == null ? configuration.getAttribute(this.getId(), false) : configuration.getAttribute(ExporterAttributes.getLaunchAttributePrefix((String)this.getId()), false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabled(enabled);
        return this.isEnabled();
    }

    public void setEnabled(ILaunchConfigurationWorkingCopy configuration, boolean enabled, boolean oldSettings) {
        this.setEnabled(enabled);
        if (oldSettings) {
            configuration.setAttribute(this.getId(), this.isEnabled());
        } else {
            configuration.setAttribute(ExporterAttributes.getLaunchAttributePrefix((String)this.getId()), this.isEnabled());
        }
    }

    public void setEnabled(ILaunchConfigurationWorkingCopy configuration, boolean enabled) {
        boolean oldSettings = true;
        try {
            oldSettings = configuration.getAttribute("org.hibernate.tools.exporters", null) == null;
        }
        catch (CoreException coreException) {}
        this.setEnabled(configuration, enabled, oldSettings);
    }

    public Map<String, String> getProperties() {
        return this.inputProperties;
    }

    public String getId() {
        return this.exporterId;
    }

    public String getExporterTag() {
        return this.definition.getExporterTag();
    }

    public String getExporterDefinitionId() {
        return this.definition.getId();
    }

    public void setProperties(Map<String, String> props) {
        this.inputProperties.clear();
        this.inputProperties.putAll(props);
    }

    public ExporterProperty getExporterProperty(String key) {
        return this.definition.getExporterProperties().get(key);
    }

    public boolean hasLocalValueFor(String string) {
        return this.inputProperties.containsKey(string);
    }

    public static String resolve(String expression) throws CoreException {
        if (expression == null) {
            return null;
        }
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        return variableManager.performStringSubstitution(expression, false);
    }

    public boolean collectOutputDirectories(String defOutDir, Properties globalProps, Set<String> outputDirs) throws CoreException {
        Properties extract = new Properties();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)globalProps);
        props.putAll(this.getProperties());
        ExporterFactory.extractExporterProperties(this.getExporterDefinitionId(), props, extract);
        String outputPath = defOutDir;
        if (extract.containsKey("outputdir")) {
            outputPath = extract.getProperty("outputdir");
        }
        String resolvedOutputDir = ExporterFactory.resolve(outputPath);
        String loc = PathHelper.getLocationAsStringPath((String)resolvedOutputDir);
        boolean res = false;
        if (StringHelper.isNotEmpty((String)loc)) {
            res = outputDirs.add(loc);
        }
        return res;
    }

    public Exporter createConfiguredExporter(Configuration cfg, String defaultOutputDirectory, String customTemplatePath, Properties globalProperties, Set<String> outputDirectories, ArtifactCollector collector) throws CoreException {
        String locationAsStringPath;
        String out;
        StringTokenizer st;
        Exporter exporter = this.getExporterDefinition().createExporterInstance();
        Properties extract = new Properties();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)globalProperties);
        props.putAll(this.getProperties());
        exporter.setProperties(props);
        exporter.setArtifactCollector(collector);
        ExporterFactory.extractExporterProperties(this.getExporterDefinitionId(), props, extract);
        String outputPath = defaultOutputDirectory;
        if (extract.containsKey("outputdir")) {
            outputPath = extract.getProperty("outputdir");
        }
        String resolvedOutputDir = ExporterFactory.resolve(outputPath);
        String loc = PathHelper.getLocationAsStringPath((String)resolvedOutputDir);
        if (outputPath != null && loc == null) {
            String out2 = NLS.bind((String)HibernateConsoleMessages.ExporterFactory_output_dir_in_does_not_exist, (Object)resolvedOutputDir, (Object)this.getExporterDefinition().getDescription());
            throw new HibernateConsoleRuntimeException(out2);
        }
        if (StringHelper.isNotEmpty((String)loc)) {
            outputDirectories.add(loc);
            exporter.setOutputDirectory(new File(loc));
        }
        exporter.setConfiguration(cfg);
        ArrayList<String> templatePathList = new ArrayList<String>();
        if (extract.containsKey("template_path")) {
            String resolveTemplatePath = ExporterFactory.resolve(extract.getProperty("template_path"));
            st = new StringTokenizer(resolveTemplatePath, ";");
            out = "";
            while (st.hasMoreTokens()) {
                locationAsStringPath = PathHelper.getLocationAsStringPath((String)st.nextToken());
                if (locationAsStringPath == null) {
                    out = String.valueOf(out) + NLS.bind((String)HibernateConsoleMessages.ExporterFactory_template_dir_in_does_not_exist, (Object)resolveTemplatePath, (Object)this.getExporterDefinition().getDescription()) + '\n';
                    continue;
                }
                templatePathList.add(locationAsStringPath);
            }
            if (out.length() > 0) {
                out = out.substring(0, out.length() - 1);
                throw new HibernateConsoleRuntimeException(out);
            }
        }
        if (StringHelper.isNotEmpty((String)customTemplatePath)) {
            String resolvedCustomTemplatePath = ExporterFactory.resolve(customTemplatePath);
            st = new StringTokenizer(resolvedCustomTemplatePath, ";");
            out = "";
            while (st.hasMoreTokens()) {
                locationAsStringPath = PathHelper.getLocationAsStringPath((String)st.nextToken());
                if (locationAsStringPath != null) {
                    templatePathList.add(locationAsStringPath);
                    continue;
                }
                out = NLS.bind((String)HibernateConsoleMessages.ExporterFactory_template_dir_in_does_not_exist, (Object)resolvedCustomTemplatePath, (Object)this.getExporterDefinition().getDescription());
            }
            if (!"".equals(out)) {
                out = out.substring(0, out.length() - 1);
                throw new HibernateConsoleRuntimeException(out);
            }
        }
        exporter.setTemplatePath(templatePathList.toArray(new String[templatePathList.size()]));
        if (this.getExporterDefinitionId().equals("org.hibernate.tools.hbmtemplate")) {
            GenericExporter ge = (GenericExporter)exporter;
            ge.setFilePattern(extract.getProperty("file_pattern"));
            ge.setTemplateName(extract.getProperty("template_name"));
            ge.setForEach(extract.getProperty("for_each"));
        }
        if (this.getExporterDefinitionId().equals("org.hibernate.tools.hbm2ddl")) {
            Hbm2DDLExporter ddlExporter = (Hbm2DDLExporter)exporter;
            boolean exportToDatabse = Boolean.parseBoolean(extract.getProperty("exportToDatabase"));
            ddlExporter.setExport(exportToDatabse);
            if (!exportToDatabse && props.containsKey("outputFileName")) {
                ddlExporter.getProperties().put("scriptToConsole", "true");
            }
        }
        if (this.getExporterDefinitionId().equals("org.hibernate.tools.query")) {
            QueryExporter queryExporter = (QueryExporter)exporter;
            ArrayList<String> queryStrings = new ArrayList<String>();
            queryStrings.add(extract.getProperty("query_string", ""));
            queryExporter.setQueries(queryStrings);
            queryExporter.setFilename(extract.getProperty("outputFileName"));
        }
        return exporter;
    }

    public static void extractExporterProperties(String exporterId, Properties props, Properties extract) throws CoreException {
        String tmp;
        if (props.containsKey("outputdir")) {
            extract.put("outputdir", ExporterFactory.resolve(props.getProperty("outputdir")));
            props.remove("outputdir");
        }
        if (props.containsKey("template_path")) {
            extract.put("template_path", ExporterFactory.resolve(props.getProperty("template_path")));
            props.remove("template_path");
        }
        if (exporterId.equals("org.hibernate.tools.hbmtemplate")) {
            if (props.containsKey("file_pattern")) {
                tmp = props.getProperty("file_pattern", "");
                extract.put("file_pattern", tmp);
                props.remove("file_pattern");
            }
            if (props.containsKey("template_name")) {
                tmp = props.getProperty("template_name", "");
                extract.put("template_name", tmp);
                props.remove("template_name");
            }
            if (props.containsKey("for_each")) {
                tmp = props.getProperty("for_each", "");
                extract.put("for_each", tmp);
                props.remove("for_each");
            }
        }
        if (exporterId.equals("org.hibernate.tools.hbm2ddl")) {
            extract.put("exportToDatabase", props.getProperty("exportToDatabase", Boolean.toString(false)));
            props.remove("exportToDatabase");
        }
        if (exporterId.equals("org.hibernate.tools.query")) {
            if (props.containsKey("query_string")) {
                tmp = props.getProperty("query_string", "");
                extract.put("query_string", tmp);
                props.remove("query_string");
            }
            if (props.containsKey("outputFileName")) {
                tmp = props.getProperty("outputFileName", "");
                extract.put("outputFileName", tmp);
                props.remove("outputFileName");
            }
        }
    }
}

