/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate3_6.console;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.model.impl.ExporterProperty;
import org.hibernate.tool.hbm2x.Exporter;

public class ExporterDefinition {
    private String classname;
    private String description;
    private String id;
    private ImageDescriptor iconDescriptor;
    private Map<String, ExporterProperty> properties;
    private IConfigurationElement element;

    public ExporterDefinition(IConfigurationElement element) {
        this.init(element.getAttribute("classname"), element.getAttribute("description"), element.getAttribute("id"), ExporterDefinition.createProperties(element), ExporterDefinition.createIcon(element));
        this.element = element;
    }

    protected void init(String className, String description, String id, Map<String, ExporterProperty> properties, ImageDescriptor icon) {
        this.classname = className;
        this.description = description;
        this.id = id;
        this.properties = properties;
        this.iconDescriptor = icon;
    }

    private static ImageDescriptor createIcon(IConfigurationElement element) {
        if (element.getAttribute("icon") != null) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getNamespace(), (String)element.getAttribute("icon"));
        }
        return null;
    }

    private static Map<String, ExporterProperty> createProperties(IConfigurationElement element) {
        HashMap<String, ExporterProperty> properties = new HashMap<String, ExporterProperty>();
        IConfigurationElement[] propertyElements = element.getChildren("property");
        int i = 0;
        while (i < propertyElements.length) {
            ExporterProperty property = new ExporterProperty(propertyElements[i].getAttribute("name"), propertyElements[i].getAttribute("description"), propertyElements[i].getAttribute("value"), Boolean.valueOf(propertyElements[i].getAttribute("required")).booleanValue());
            String type = propertyElements[i].getAttribute("type");
            if (type != null) {
                property.setType(type);
            }
            properties.put(property.getName(), property);
            ++i;
        }
        return properties;
    }

    public Exporter createExporterInstance() {
        Exporter exporter = null;
        try {
            exporter = (Exporter)ReflectHelper.classForName((String)this.classname).newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new HibernateConsoleRuntimeException(NLS.bind((String)HibernateConsoleMessages.ExporterDefinition_problem_creating_exporter_class, (Object)this.classname));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new HibernateConsoleRuntimeException(NLS.bind((String)HibernateConsoleMessages.ExporterDefinition_problem_creating_exporter_class, (Object)this.classname));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HibernateConsoleRuntimeException(NLS.bind((String)HibernateConsoleMessages.ExporterDefinition_problem_creating_exporter_class, (Object)this.classname));
        }
        return exporter;
    }

    public String getDescription() {
        return this.description;
    }

    public ImageDescriptor getIconDescriptor() {
        return this.iconDescriptor;
    }

    public Map<String, ExporterProperty> getExporterProperties() {
        return this.properties;
    }

    public boolean isEnabled(ILaunchConfiguration configuration) {
        boolean enabled = false;
        try {
            enabled = configuration.getAttribute(this.id, false);
        }
        catch (CoreException e) {
            HibernateConsolePlugin.getDefault().log((Throwable)e);
            return false;
        }
        return enabled;
    }

    public String getId() {
        return this.id;
    }

    public String getExporterTag() {
        return this.getId().substring(this.getId().lastIndexOf(".") + 1);
    }
}

