/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate3_6.console;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.views.properties.IPropertySource;
import org.hibernate.Session;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.OverrideRepository;
import org.hibernate.cfg.reveng.ReverseEngineeringSettings;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.QueryPage;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.console.ext.HibernateException;
import org.hibernate.console.ext.HibernateExtension;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.ext.CompletionProposalsResult;
import org.hibernate.eclipse.console.ext.ConsoleExtension;
import org.hibernate.eclipse.launch.CodeGenerationUtils;
import org.hibernate.eclipse.launch.PathHelper;
import org.hibernate.proxy.HibernateProxyHelper;
import org.hibernate.tool.hbm2x.ArtifactCollector;
import org.hibernate.tool.hbm2x.Exporter;
import org.hibernate.tool.ide.completion.HQLCodeAssist;
import org.hibernate.tool.ide.completion.IHQLCompletionRequestor;
import org.jboss.tools.hibernate3_6.HibernateExtension3_6;
import org.jboss.tools.hibernate3_6.console.EclipseHQLCompletionRequestor;
import org.jboss.tools.hibernate3_6.console.EntityPropertySource;
import org.jboss.tools.hibernate3_6.console.ExporterAttributes;
import org.jboss.tools.hibernate3_6.console.ExporterFactory;

public class ConsoleExtension3_6
implements ConsoleExtension {
    private HibernateExtension3_6 hibernateExtension;

    public void setHibernateExtention(HibernateExtension hibernateExtension) {
        this.hibernateExtension = (HibernateExtension3_6)hibernateExtension;
    }

    public CompletionProposalsResult hqlCodeComplete(String query, int startPosition, int currentOffset) {
        EclipseHQLCompletionRequestor requestor = new EclipseHQLCompletionRequestor(startPosition);
        if (!this.hibernateExtension.hasConfiguration()) {
            try {
                this.hibernateExtension.build();
                this.hibernateExtension.execute(new ExecutionContext.Command(){

                    public Object execute() {
                        if (ConsoleExtension3_6.this.hibernateExtension.hasConfiguration()) {
                            ConsoleExtension3_6.this.hibernateExtension.getConfiguration().buildMappings();
                        }
                        return null;
                    }
                });
            }
            catch (HibernateException hibernateException) {}
        }
        HQLCodeAssist hqlEval = new HQLCodeAssist(this.hibernateExtension.getConfiguration());
        query = query.replace('\t', ' ');
        hqlEval.codeComplete(query, currentOffset, (IHQLCompletionRequestor)requestor);
        return new CompletionProposalsResult(requestor.getCompletionProposals(), requestor.getLastErrorMessage());
    }

    public Map<String, File[]> launchExporters(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)configuration);
        Assert.isNotNull((Object)monitor);
        ExporterAttributes attributes = new ExporterAttributes(configuration);
        List<ExporterFactory> exporterFactories = attributes.getExporterFactories();
        Iterator<ExporterFactory> iter = exporterFactories.iterator();
        while (iter.hasNext()) {
            ExporterFactory exFactory = iter.next();
            if (exFactory.isEnabled(configuration)) continue;
            iter.remove();
        }
        try {
            HashSet<String> outputDirectories = new HashSet<String>();
            ExporterFactory[] exporters = exporterFactories.toArray(new ExporterFactory[exporterFactories.size()]);
            ArtifactCollector collector = this.runExporters(attributes, exporters, outputDirectories, monitor);
            for (String path : outputDirectories) {
                CodeGenerationUtils.refreshOutputDir((String)path);
            }
            if (collector != null) {
                HashMap<String, File[]> map = new HashMap<String, File[]>();
                Set types = collector.getFileTypes();
                for (String type : types) {
                    File[] files = collector.getFiles(type.toString());
                    map.put(type, files);
                }
                HashMap<String, File[]> hashMap = map;
                return hashMap;
            }
        }
        catch (Exception e) {
            throw new CoreException(HibernateConsolePlugin.throwableToStatus((Throwable)e, (int)666));
        }
        catch (NoClassDefFoundError e) {
            throw new CoreException(HibernateConsolePlugin.throwableToStatus((Throwable)new HibernateConsoleRuntimeException(HibernateConsoleMessages.CodeGenerationLaunchDelegate_received_noclassdeffounderror, (Throwable)e), (int)666));
        }
        finally {
            monitor.done();
        }
        return null;
    }

    private ArtifactCollector runExporters(final ExporterAttributes attributes, final ExporterFactory[] exporterFactories, final Set<String> outputDirectories, final IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.valueOf(HibernateConsoleMessages.CodeGenerationLaunchDelegate_generating_code_for) + attributes.getConsoleConfigurationName(), exporterFactories.length + 1);
        if (monitor.isCanceled()) {
            return null;
        }
        ConsoleConfiguration cc = KnownConfigurations.getInstance().find(attributes.getConsoleConfigurationName());
        if (attributes.isReverseEngineer()) {
            monitor.subTask(HibernateConsoleMessages.CodeGenerationLaunchDelegate_reading_jdbc_metadata);
        }
        final Configuration cfg = this.buildConfiguration(attributes, (HibernateExtension3_6)cc.getHibernateExtension(), ResourcesPlugin.getWorkspace().getRoot());
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return null;
        }
        return (ArtifactCollector)this.hibernateExtension.execute(new ExecutionContext.Command(){

            public Object execute() {
                ArtifactCollector artifactCollector = new ArtifactCollector();
                Properties props = new Properties();
                props.put("ejb3", "" + attributes.isEJB3Enabled());
                props.put("jdk5", "" + attributes.isJDK5Enabled());
                int i = 0;
                while (i < exporterFactories.length) {
                    Exporter exporter;
                    monitor.subTask(exporterFactories[i].getExporterDefinition().getDescription());
                    Properties globalProperties = new Properties();
                    globalProperties.putAll((Map<?, ?>)props);
                    try {
                        exporter = exporterFactories[i].createConfiguredExporter(cfg, attributes.getOutputPath(), attributes.getTemplatePath(), globalProperties, outputDirectories, artifactCollector);
                    }
                    catch (CoreException e) {
                        throw new HibernateConsoleRuntimeException(String.valueOf(HibernateConsoleMessages.CodeGenerationLaunchDelegate_error_while_setting_up) + exporterFactories[i].getExporterDefinition(), (Throwable)e);
                    }
                    try {
                        exporter.start();
                    }
                    catch (HibernateException he) {
                        throw new HibernateConsoleRuntimeException(String.valueOf(HibernateConsoleMessages.CodeGenerationLaunchDelegate_error_while_running) + exporterFactories[i].getExporterDefinition().getDescription(), (Throwable)he);
                    }
                    monitor.worked(1);
                    ++i;
                }
                return artifactCollector;
            }
        });
    }

    private Configuration buildConfiguration(final ExporterAttributes attributes, HibernateExtension3_6 cc, IWorkspaceRoot root) {
        boolean reveng = attributes.isReverseEngineer();
        final String reverseEngineeringStrategy = attributes.getRevengStrategy();
        boolean preferBasicCompositeids = attributes.isPreferBasicCompositeIds();
        final IResource revengres = PathHelper.findMember((IWorkspaceRoot)root, (String)attributes.getRevengSettings());
        if (reveng) {
            Configuration configuration = null;
            configuration = cc.hasConfiguration() ? cc.getConfiguration() : cc.buildWith(null, false);
            final JDBCMetaDataConfiguration cfg = new JDBCMetaDataConfiguration();
            Properties properties = configuration.getProperties();
            cfg.setProperties(properties);
            cc.buildWith((Configuration)cfg, false);
            cfg.setPreferBasicCompositeIds(preferBasicCompositeids);
            cc.execute(new ExecutionContext.Command(){

                public Object execute() {
                    DefaultReverseEngineeringStrategy res = new DefaultReverseEngineeringStrategy();
                    OverrideRepository repository = null;
                    if (revengres != null) {
                        File file = PathHelper.getLocation((IResource)revengres).toFile();
                        repository = new OverrideRepository();
                        repository.addFile(file);
                    }
                    if (repository != null) {
                        res = repository.getReverseEngineeringStrategy((ReverseEngineeringStrategy)res);
                    }
                    if (reverseEngineeringStrategy != null && reverseEngineeringStrategy.trim().length() > 0) {
                        res = ConsoleExtension3_6.this.loadreverseEngineeringStrategy(reverseEngineeringStrategy, (ReverseEngineeringStrategy)res);
                    }
                    ReverseEngineeringSettings qqsettings = new ReverseEngineeringSettings((ReverseEngineeringStrategy)res).setDefaultPackageName(attributes.getPackageName()).setDetectManyToMany(attributes.detectManyToMany()).setDetectOptimisticLock(attributes.detectOptimisticLock());
                    res.setSettings(qqsettings);
                    cfg.setReverseEngineeringStrategy((ReverseEngineeringStrategy)res);
                    cfg.readFromJDBC();
                    cfg.buildMappings();
                    return null;
                }
            });
            return cfg;
        }
        cc.build();
        final Configuration configuration = cc.getConfiguration();
        cc.execute(new ExecutionContext.Command(){

            public Object execute() {
                configuration.buildMappings();
                return configuration;
            }
        });
        return configuration;
    }

    private ReverseEngineeringStrategy loadreverseEngineeringStrategy(String className, ReverseEngineeringStrategy delegate) {
        try {
            Class clazz = ReflectHelper.classForName((String)className);
            Constructor constructor = clazz.getConstructor(ReverseEngineeringStrategy.class);
            return (ReverseEngineeringStrategy)constructor.newInstance(delegate);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Class clazz = ReflectHelper.classForName((String)className);
                ReverseEngineeringStrategy rev = (ReverseEngineeringStrategy)clazz.newInstance();
                return rev;
            }
            catch (Exception eq) {
                String out = NLS.bind((String)HibernateConsoleMessages.CodeGenerationLaunchDelegate_could_not_create_or_find_with_default_noarg_constructor, (Object)className);
                throw new HibernateConsoleRuntimeException(out, (Throwable)eq);
            }
        }
        catch (Exception e) {
            String out = NLS.bind((String)HibernateConsoleMessages.CodeGenerationLaunchDelegate_could_not_create_or_find_with_one_argument_delegate_constructor, (Object)className);
            throw new HibernateConsoleRuntimeException(out, (Throwable)e);
        }
    }

    public IPropertySource getPropertySource(Object object, QueryPage selectedQueryPage) {
        Session currentSession = (Session)selectedQueryPage.getSession();
        if (currentSession.isOpen() && currentSession.contains(object) || this.hasMetaData(object, currentSession)) {
            return new EntityPropertySource(object, currentSession, this.hibernateExtension);
        }
        return null;
    }

    private boolean hasMetaData(Object object, Session currentSession) {
        return currentSession.getSessionFactory().getClassMetadata(HibernateProxyHelper.getClassWithoutInitializingProxy((Object)object)) != null;
    }
}

