/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate3_6.console;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.hibernate.eclipse.console.HibernateConsolePlugin;

public class CompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension {
    private String displayString;
    private String replacementString;
    private int replacementOffset;
    private int documentOffset = -1;
    private int replacementLength;
    private int cursorPosition;
    private Image image;
    private IContextInformation contextInformation;
    private int contextInformationPosition;
    private char[] triggerCharacters;
    private String additionalProposalInfo;

    public CompletionProposal(String additionalInfo, String replacementString, int replacementOffset, int documentOffset, int replacementLength, Image image, String displayString, IContextInformation contextInformation) {
        this.replacementString = replacementString;
        this.replacementOffset = replacementOffset;
        this.documentOffset = documentOffset;
        this.replacementLength = replacementLength;
        this.image = image;
        this.displayString = displayString != null ? displayString : replacementString;
        this.cursorPosition = replacementString.length();
        this.contextInformation = contextInformation;
        this.triggerCharacters = null;
        this.additionalProposalInfo = additionalInfo;
    }

    public CompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        this.replacementString = replacementString;
        this.replacementOffset = replacementOffset;
        this.documentOffset = replacementOffset;
        this.replacementLength = replacementLength;
        this.cursorPosition = cursorPosition;
        this.image = image;
        this.displayString = displayString;
        this.contextInformation = contextInformation;
        this.additionalProposalInfo = additionalProposalInfo;
    }

    public void setContextInformation(IContextInformation contextInformation) {
        this.contextInformation = contextInformation;
        this.contextInformationPosition = contextInformation != null ? this.cursorPosition : -1;
    }

    public void setTriggerCharacters(char[] triggerCharacters) {
        this.triggerCharacters = triggerCharacters;
    }

    public void setCursorPosition(int cursorPosition) {
        if (cursorPosition >= 0) {
            this.cursorPosition = cursorPosition;
            this.contextInformationPosition = this.contextInformation != null ? cursorPosition : -1;
        }
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            int delta = offset - (this.documentOffset + this.replacementLength);
            if (delta > 0) {
                this.replacementLength += delta;
            }
            if (trigger == '\u0000') {
                this.replace(document, this.documentOffset, this.replacementLength, this.replacementString);
            } else {
                StringBuffer buffer = new StringBuffer(this.replacementString);
                if (this.replacementLength < buffer.length() && buffer.charAt(this.replacementLength) != trigger) {
                    buffer.insert(this.cursorPosition, trigger);
                    ++this.cursorPosition;
                }
                this.replace(document, this.documentOffset, this.replacementLength, buffer.toString());
            }
            int oldLen = document.getLength();
            this.documentOffset += document.getLength() - oldLen;
        }
        catch (BadLocationException e) {
            HibernateConsolePlugin.getDefault().log((Throwable)e);
        }
    }

    private void replace(IDocument document, int offset, int length, String string) throws BadLocationException {
        if (document != null && string != null && offset >= 0 && length >= 0 && !document.get(offset, length).equals(string)) {
            document.replace(offset, length, string);
        }
    }

    public void apply(IDocument document) {
        this.apply(document, '\u0000', this.documentOffset + this.replacementLength);
    }

    public Point getSelection(IDocument document) {
        return new Point(this.documentOffset + this.cursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this.contextInformation;
    }

    public Image getImage() {
        return this.image;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public String getAdditionalProposalInfo() {
        return this.additionalProposalInfo;
    }

    public char[] getTriggerCharacters() {
        return this.triggerCharacters;
    }

    public int getContextInformationPosition() {
        return this.replacementOffset + this.contextInformationPosition;
    }

    public int getReplacementOffset() {
        return this.replacementOffset;
    }

    public void setReplacementOffset(int replacementOffset) {
        if (replacementOffset >= 0) {
            this.replacementOffset = replacementOffset;
        }
    }

    public int getReplacementLength() {
        return this.replacementLength;
    }

    public void setReplacementLength(int replacementLength) {
        if (replacementLength >= 0) {
            this.replacementLength = replacementLength;
        }
    }

    public String getReplacementString() {
        return this.replacementString;
    }

    public void setReplacementString(String replacementString) {
        this.replacementString = replacementString;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public boolean isValidFor(IDocument document, int offset) {
        int replacementLength;
        if (offset < this.replacementOffset) {
            return false;
        }
        int n = replacementLength = this.replacementString == null ? 0 : this.replacementString.length();
        if (offset >= this.replacementOffset + replacementLength) {
            return false;
        }
        try {
            int length = offset - this.replacementOffset;
            String start = document.get(this.replacementOffset, length);
            return this.replacementString.substring(0, length).equalsIgnoreCase(start);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }
}

