/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate3_6;

import java.util.Properties;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.jboss.tools.hibernate3_6.FakeTransaction;

class FakeTransactionManager
implements TransactionManager {
    public static FakeTransactionManager INSTANCE;
    private FakeTransaction current;
    ConnectionProvider connections = ConnectionProviderFactory.newConnectionProvider();

    public FakeTransactionManager(Properties props) {
    }

    public void begin() throws NotSupportedException, SystemException {
        this.current = new FakeTransaction(this);
        this.current.begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this.current != null) {
            this.current.commit();
        }
    }

    public int getStatus() throws SystemException {
        if (this.current != null) {
            return this.current.getStatus();
        }
        return 6;
    }

    public Transaction getTransaction() throws SystemException {
        return this.current;
    }

    public void resume(Transaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.current = (FakeTransaction)tx;
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (this.current != null) {
            this.current.rollback();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.current != null) {
            this.current.setRollbackOnly();
        }
    }

    public void setTransactionTimeout(int t) throws SystemException {
    }

    public Transaction suspend() throws SystemException {
        FakeTransaction result = this.current;
        this.current = null;
        return result;
    }

    public FakeTransaction getCurrent() {
        return this.current;
    }

    void endCurrent(FakeTransaction tx) {
        if (this.current == tx) {
            this.current = null;
        }
    }
}

