/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate3_6;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.jboss.tools.hibernate3_6.FakeTransactionManager;

class FakeTransaction
implements Transaction {
    int status = 6;
    private Connection connection;
    List<Synchronization> synchronizations = new ArrayList<Synchronization>();
    private FakeTransactionManager transactionManager;

    FakeTransaction(FakeTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void begin() throws SystemException {
        try {
            this.connection = this.transactionManager.connections.getConnection();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw new SystemException(sqle.toString());
        }
        this.status = 0;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this.status == 1) {
            this.rollback();
        } else {
            this.status = 7;
            for (Synchronization s : this.synchronizations) {
                s.beforeCompletion();
            }
            this.status = 8;
            try {
                this.connection.commit();
                this.connection.close();
            }
            catch (SQLException sQLException) {
                this.status = 5;
                throw new SystemException();
            }
            this.status = 3;
            for (Synchronization s : this.synchronizations) {
                s.afterCompletion(this.status);
            }
            this.transactionManager.endCurrent(this);
        }
    }

    public boolean delistResource(XAResource arg0, int arg1) throws IllegalStateException, SystemException {
        return false;
    }

    public boolean enlistResource(XAResource arg0) throws RollbackException, IllegalStateException, SystemException {
        return false;
    }

    public int getStatus() throws SystemException {
        return this.status;
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        this.synchronizations.add(sync);
    }

    public void rollback() throws IllegalStateException, SystemException {
        this.status = 9;
        this.status = 4;
        try {
            this.connection.rollback();
            this.connection.close();
        }
        catch (SQLException sQLException) {
            this.status = 5;
            throw new SystemException();
        }
        for (Synchronization s : this.synchronizations) {
            s.afterCompletion(this.status);
        }
        this.transactionManager.endCurrent(this);
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.status = 1;
    }

    void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }
}

