/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesToolBarTemplate;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RichFacesToolBarGroupTemplate
extends VpeAbstractTemplate {
    public static final String TAG_NAME = "toolBarGroup";
    public static final String ATTR_ITEMSEPARATOR_NAME = "itemSeparator";
    public static final String ATTR_LOCATION_NAME = "location";
    public static final String ATTR_LOCATION_RIGHT_VALUE = "right";
    private static final String TOOLBAR_PARENT_WARNING = "Parent should be toolBar";
    private static final String CSS_DR_TOOLBAR_INT = "dr-toolbar-int";
    private static final String CSS_RICH_TOOLBAR_ITEM = "rich-toolbar-item";
    private static final String SPACE = " ";
    private static final String EMPTY = "";
    private static final String GROUP_TABLE_STYLE = "border: 0px none; margin: 0px 0px 0px 0px; padding: 0px 0px 0px 0px; width: 100%; height: 100%";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        nsIDOMElement visualNode = null;
        VpeCreationData creationData = null;
        Element sourceElement = (Element)sourceNode;
        if (!sourceNode.getParentNode().getNodeName().endsWith(":toolBar")) {
            visualNode = RichFacesToolBarTemplate.createExceptionNode(visualDocument, TOOLBAR_PARENT_WARNING);
            creationData = new VpeCreationData((nsIDOMNode)visualNode);
        } else {
            String itemSeparator = sourceElement.getAttribute(ATTR_ITEMSEPARATOR_NAME);
            itemSeparator = RichFacesToolBarTemplate.checkAndUpdateItemSeparatorName(itemSeparator);
            SourceToolBarGroupItems sourceToolBarGroupItems = new SourceToolBarGroupItems(sourceNode, ATTR_LOCATION_RIGHT_VALUE.equals(sourceElement.getAttribute(ATTR_LOCATION_NAME)), itemSeparator);
            visualNode = visualDocument.createElement("TABLE");
            visualNode.setAttribute("style", GROUP_TABLE_STYLE);
            nsIDOMElement body = visualDocument.createElement("TBODY");
            nsIDOMElement row = visualDocument.createElement("TR");
            row.setAttribute("valign", "middle");
            creationData = new VpeCreationData((nsIDOMNode)visualNode);
            Iterator<SourceToolBarGroupItem> iterator = sourceToolBarGroupItems.iterator();
            while (iterator.hasNext()) {
                SourceToolBarGroupItem toolBarGroupItem = iterator.next();
                nsIDOMElement cell = visualDocument.createElement("TD");
                if (toolBarGroupItem.isItem()) {
                    String styleClass = sourceElement.hasAttribute("styleClass") ? sourceElement.getAttribute("styleClass") : EMPTY;
                    String style = sourceElement.hasAttribute("style") ? sourceElement.getAttribute("style") : EMPTY;
                    Node parentNode = sourceElement.getParentNode();
                    if (parentNode != null && parentNode instanceof Element) {
                        Element parentElement = (Element)parentNode;
                        if (parentElement.hasAttribute("contentClass")) {
                            String contentClass = parentElement.getAttribute("contentClass");
                            styleClass = String.valueOf(styleClass) + SPACE + contentClass;
                        }
                        if (parentElement.hasAttribute("contentStyle")) {
                            String contentStyle = parentElement.getAttribute("contentStyle");
                            style = String.valueOf(style) + SPACE + contentStyle;
                        }
                    }
                    styleClass = String.valueOf(styleClass) + " dr-toolbar-int rich-toolbar-item";
                    cell.setAttribute("class", styleClass);
                    cell.setAttribute("style", style);
                    VpeChildrenInfo childrenInfo = new VpeChildrenInfo(cell);
                    creationData.addChildrenInfo(childrenInfo);
                    childrenInfo.addSourceChild(toolBarGroupItem.getToolBarGroupItem());
                } else {
                    cell.setAttribute("align", "center");
                    ComponentUtil.correctAttribute(sourceElement, cell, "separatorClass", "class", null, null);
                    String separatorImageUrl = RichFacesToolBarTemplate.getSeparatorImageUrlString(toolBarGroupItem.getItemSeparator());
                    nsIDOMElement separatorImage = visualDocument.createElement("IMG");
                    ComponentUtil.setImg(separatorImage, separatorImageUrl);
                    visualNode.appendChild((nsIDOMNode)separatorImage);
                    cell.appendChild((nsIDOMNode)separatorImage);
                }
                row.appendChild((nsIDOMNode)cell);
            }
            body.appendChild((nsIDOMNode)row);
            visualNode.appendChild((nsIDOMNode)body);
        }
        return creationData;
    }

    public Node getNodeForUpdate(VpePageContext pageContext, Node sourceNode, nsIDOMNode visualNode, Object data) {
        String prefix = sourceNode.getPrefix();
        if (prefix == null) {
            return null;
        }
        String parentNodeName = String.valueOf(prefix) + ":" + "toolBar";
        Node parent = sourceNode.getParentNode();
        while (parent != null) {
            if (parentNodeName.equals(parent.getNodeName())) break;
            parent = parent.getParentNode();
        }
        return parent;
    }

    private class SourceToolBarGroupItem {
        private Node toolBarGroupItem;
        private String itemSeparator;

        public SourceToolBarGroupItem(Node toolBarGroupItem) {
            this.toolBarGroupItem = toolBarGroupItem;
            this.itemSeparator = null;
        }

        public SourceToolBarGroupItem(String itemSeparator) {
            this.toolBarGroupItem = null;
            this.itemSeparator = itemSeparator;
        }

        public Node getToolBarGroupItem() {
            return this.toolBarGroupItem;
        }

        public String getItemSeparator() {
            return this.itemSeparator;
        }

        public boolean isItem() {
            return this.toolBarGroupItem != null;
        }
    }

    private class SourceToolBarGroupItems {
        private boolean isToolBarGroupLocationRight;
        private String itemSeparator;
        boolean isItemSeparatorExists;
        private List<SourceToolBarGroupItem> toolBarGroupItems = new ArrayList<SourceToolBarGroupItem>();

        public SourceToolBarGroupItems(Node sourceNode, boolean isToolBarGroupLocationRight, String itemSeparator) {
            this.isToolBarGroupLocationRight = isToolBarGroupLocationRight;
            this.itemSeparator = itemSeparator;
            this.isItemSeparatorExists = itemSeparator != null && (itemSeparator == null || itemSeparator.length() != 0) && !"none".equals(itemSeparator);
            this.init(sourceNode);
        }

        private void init(Node sourceNode) {
            NodeList childrenList = sourceNode.getChildNodes();
            int childrenCount = childrenList.getLength();
            boolean isFirstItem = true;
            int i = 0;
            while (i < childrenCount) {
                Node child = childrenList.item(i);
                if (child.getNodeType() == 1 || this.isVisibleText(child)) {
                    if (this.isItemSeparatorExists && this.isToolBarGroupLocationRight && !isFirstItem) {
                        this.toolBarGroupItems.add(new SourceToolBarGroupItem(this.itemSeparator));
                    }
                    this.toolBarGroupItems.add(new SourceToolBarGroupItem(child));
                    if (this.isItemSeparatorExists && !this.isToolBarGroupLocationRight && !this.isLastItem(childrenList, i)) {
                        this.toolBarGroupItems.add(new SourceToolBarGroupItem(this.itemSeparator));
                    }
                    isFirstItem = false;
                }
                ++i;
            }
        }

        private boolean isVisibleText(Node textNode) {
            return textNode.getNodeType() == 3 && textNode.getNodeValue() != null && textNode.getNodeValue().trim().length() > 0;
        }

        private boolean isLastItem(NodeList list, int index) {
            int listLength = list.getLength();
            int i = index + 1;
            while (i < listLength) {
                Node item = list.item(i);
                if (item.getNodeType() == 1 || this.isVisibleText(item)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public Iterator<SourceToolBarGroupItem> iterator() {
            return this.toolBarGroupItems.iterator();
        }
    }
}

