/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.List;
import java.util.Map;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.ResourceUtil;
import org.jboss.tools.vpe.editor.util.SourceDomUtil;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RichFacesTabTemplate
extends VpeAbstractTemplate {
    public static final String TAB_HEADER_ATTR = "tabheaderattr";
    public static final String YES = "yes";
    public static final String DISABLED_ELEMENT_STYLE = "none";
    public static final String TAB_BODY_ATTR = "tabbodyattr";
    private static final String SPACER_FILE_PATH = "common/spacer.gif";
    private static final String BORDER_FILE_PATH = "tabPanel/border.gif";
    private static final String VPE_USER_TOGGLE_ID = "vpe-user-toggle-id";
    private static final String DISABLED = "disabled";
    private static final String LABEL_WIDTH = "labelWidth";
    private static final String CSS_HEADER = "rich-tab-header";
    private static final String CSS_LABEL = "rich-tab-label";
    private static final String CSS_ACTIVE = "rich-tab-active";
    private static final String CSS_INACTIVE = "rich-tab-inactive";
    private static final String CSS_DISABLED = "rich-tab-disabled";
    private static final String ZERO = "0";
    private static final String ONE = "1";
    private static final String TEN = "10";
    private static final String SPACE = " ";
    private static final String EMPTY = "";
    private static final String HUNDRED_PERCENTS = "100%";
    private static final String HEIGHT_STYLE_NAME = "height: ";
    private static final String WIDTH_STYLE_NAME = "width: ";
    private static final String STYLE_SEMICOLUMN = "; ";
    private static final String PX = "px";
    private static final String BODY_TABLE_STYLE = "position: relative; z-index: 1;";
    private static final String HEADER_TABLE_STYLE = "height : 100%; position : relative; z-index : 2;";
    private static final String HEADER_TD_STYLE = "height: 100%; vertical-align: bottom;";
    private static final String TRUE = "true";

    public static VpeCreationData encodeBody(VpePageContext pageContext, VpeCreationData creationData, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement parentTr, boolean active, String contentClass, String contentStyle) {
        nsIDOMElement td = visualDocument.createElement("td");
        if (creationData == null) {
            creationData = new VpeCreationData((nsIDOMNode)td);
        } else {
            parentTr.appendChild((nsIDOMNode)td);
        }
        if (!active) {
            return creationData;
        }
        td.setAttribute("height", HUNDRED_PERCENTS);
        nsIDOMElement table = visualDocument.createElement("table");
        td.appendChild((nsIDOMNode)table);
        table.setAttribute("border", ZERO);
        table.setAttribute("cellpadding", TEN);
        table.setAttribute("cellspacing", ZERO);
        table.setAttribute("width", HUNDRED_PERCENTS);
        table.setAttribute("class", "rich-tabpanel-content-position");
        table.setAttribute("style", BODY_TABLE_STYLE);
        nsIDOMElement tr = visualDocument.createElement("tr");
        table.appendChild((nsIDOMNode)tr);
        td = visualDocument.createElement("td");
        tr.appendChild((nsIDOMNode)td);
        td.setAttribute("class", String.valueOf(ComponentUtil.getAttribute(sourceElement, "styleClass")) + SPACE + contentClass);
        td.setAttribute("style", String.valueOf(ComponentUtil.getAttribute(sourceElement, "style")) + STYLE_SEMICOLUMN + contentStyle);
        Map labelFacetChildren = null;
        Element labelFacet = SourceDomUtil.getFacetByName((VpePageContext)pageContext, (Element)sourceElement, (String)"label");
        if (labelFacet != null) {
            labelFacetChildren = VisualDomUtil.findFacetElements((Node)labelFacet, (VpePageContext)pageContext);
        }
        boolean labelHtmlElementsPresents = labelFacetChildren != null && ((List)labelFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)).size() > 0;
        VpeChildrenInfo bodyInfo = new VpeChildrenInfo(td);
        if (labelHtmlElementsPresents) {
            for (Node node : (List)labelFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)) {
                bodyInfo.addSourceChild(node);
            }
        }
        List<Node> children = ComponentUtil.getChildren(sourceElement, true);
        for (Node child : children) {
            bodyInfo.addSourceChild(child);
        }
        creationData.addChildrenInfo(bodyInfo);
        return creationData;
    }

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        nsIDOMElement table = visualDocument.createElement("div");
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)table);
        nsIDOMElement headerTable = visualDocument.createElement("table");
        headerTable.setAttribute("border", ZERO);
        headerTable.setAttribute("cellpadding", ZERO);
        headerTable.setAttribute("cellspacing", ZERO);
        headerTable.setAttribute(TAB_HEADER_ATTR, YES);
        headerTable.setAttribute("style", "display:none; ");
        headerTable.appendChild((nsIDOMNode)RichFacesTabTemplate.encodeHeader(pageContext, creationData, (Element)sourceNode, visualDocument, table, false, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY));
        nsIDOMElement bodyTable = visualDocument.createElement("table");
        bodyTable.setAttribute("border", ZERO);
        bodyTable.setAttribute("cellpadding", ZERO);
        bodyTable.setAttribute("cellspacing", ZERO);
        bodyTable.setAttribute(TAB_BODY_ATTR, YES);
        table.appendChild((nsIDOMNode)headerTable);
        table.appendChild((nsIDOMNode)bodyTable);
        RichFacesTabTemplate.encodeBody(pageContext, creationData, (Element)sourceNode, visualDocument, bodyTable, true, EMPTY, EMPTY);
        return creationData;
    }

    public static nsIDOMElement encodeHeader(VpePageContext pageContext, VpeCreationData creationData, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement parentTr, boolean active, String headerClass, String activeTabClass, String inactiveTabClass, String disabledTabClass, String toggleId) {
        nsIDOMElement headerTd = visualDocument.createElement("td");
        parentTr.appendChild((nsIDOMNode)headerTd);
        headerTd.setAttribute("style", HEADER_TD_STYLE);
        String styleClass = "rich-tabhdr-cell-disabled rich-tab-disabled";
        if (!TRUE.equalsIgnoreCase(sourceElement.getAttribute(DISABLED))) {
            styleClass = active ? "rich-tabhdr-cell-active" : "rich-tabhdr-cell-inactive";
        }
        headerTd.setAttribute("class", styleClass);
        headerTd.setAttribute(VPE_USER_TOGGLE_ID, toggleId);
        nsIDOMElement table = visualDocument.createElement("table");
        headerTd.appendChild((nsIDOMNode)table);
        table.setAttribute("border", ZERO);
        table.setAttribute("cellpadding", ZERO);
        table.setAttribute("cellspacing", ZERO);
        table.setAttribute("style", HEADER_TABLE_STYLE);
        table.setAttribute(VPE_USER_TOGGLE_ID, toggleId);
        nsIDOMElement mainTr = visualDocument.createElement("tr");
        table.appendChild((nsIDOMNode)mainTr);
        RichFacesTabTemplate.encodeSpacer(mainTr, visualDocument);
        nsIDOMElement mainTd = visualDocument.createElement("td");
        mainTr.appendChild((nsIDOMNode)mainTd);
        mainTd.setAttribute(VPE_USER_TOGGLE_ID, toggleId);
        table = visualDocument.createElement("table");
        mainTd.appendChild((nsIDOMNode)table);
        String labelWidth = ComponentUtil.getAttribute(sourceElement, LABEL_WIDTH);
        String tableStyle = "height: 100%; ";
        if (labelWidth != null && !EMPTY.equalsIgnoreCase(labelWidth)) {
            int val = -1;
            try {
                val = Integer.parseInt(labelWidth);
            }
            catch (NumberFormatException numberFormatException) {}
            if (val > 0) {
                labelWidth = String.valueOf(val) + PX;
            }
        } else {
            labelWidth = HUNDRED_PERCENTS;
        }
        tableStyle = String.valueOf(tableStyle) + WIDTH_STYLE_NAME + labelWidth + STYLE_SEMICOLUMN;
        table.setAttribute("style", tableStyle);
        table.setAttribute("border", ZERO);
        table.setAttribute("cellpadding", ZERO);
        table.setAttribute("cellspacing", ZERO);
        table.setAttribute(VPE_USER_TOGGLE_ID, toggleId);
        nsIDOMElement tr = visualDocument.createElement("tr");
        table.appendChild((nsIDOMNode)tr);
        mainTd = visualDocument.createElement("td");
        tr.appendChild((nsIDOMNode)mainTd);
        styleClass = "rich-tab-header rich-tab-label rich-tab-disabled " + disabledTabClass;
        if (!TRUE.equalsIgnoreCase(sourceElement.getAttribute(DISABLED))) {
            styleClass = active ? "rich-tab-header rich-tab-label rich-tab-active " + activeTabClass : "rich-tab-header rich-tab-label rich-tab-inactive " + inactiveTabClass;
        }
        String tabStyleClass = ComponentUtil.getAttribute(sourceElement, "styleClass");
        styleClass = String.valueOf(styleClass) + SPACE + headerClass + SPACE + tabStyleClass;
        mainTd.setAttribute("class", styleClass);
        mainTd.setAttribute(VPE_USER_TOGGLE_ID, toggleId);
        Element labelFacet = SourceDomUtil.getFacetByName((VpePageContext)pageContext, (Element)sourceElement, (String)"label");
        if (labelFacet != null) {
            mainTd.setAttribute("VPE-FACET", "label");
            VpeChildrenInfo labelInfo = new VpeChildrenInfo(mainTd);
            labelInfo.addSourceChild((Node)labelFacet);
            creationData.addChildrenInfo(labelInfo);
        } else if (sourceElement.hasAttribute("label")) {
            Attr labelAttr = sourceElement.getAttributeNode("label");
            if (labelAttr != null) {
                String bundleValue = ResourceUtil.getBundleValue((VpePageContext)pageContext, (String)labelAttr.getValue());
                mainTd.appendChild((nsIDOMNode)visualDocument.createTextNode(bundleValue));
            }
        } else {
            char space = '\u00a0';
            mainTd.appendChild((nsIDOMNode)visualDocument.createTextNode(EMPTY + space));
        }
        RichFacesTabTemplate.encodeSpacer(mainTr, visualDocument);
        return headerTd;
    }

    private static void encodeSpacer(nsIDOMElement parentTr, nsIDOMDocument visualDocument) {
        nsIDOMElement td = visualDocument.createElement("td");
        parentTr.appendChild((nsIDOMNode)td);
        td.setAttribute("class", "rich-tabhdr-side-cell rich-tabhdr-side-border");
        String style = ComponentUtil.getBackgoundImgStyle(BORDER_FILE_PATH);
        td.setAttribute("style", style);
        nsIDOMElement img = visualDocument.createElement("img");
        td.appendChild((nsIDOMNode)img);
        ComponentUtil.setImg(img, SPACER_FILE_PATH);
        img.setAttribute("width", ONE);
        img.setAttribute("height", ONE);
        img.setAttribute("border", ZERO);
    }
}

