/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.ArrayList;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.jsf.vpe.richfaces.RichFacesTemplatesActivator;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesColumnGroupTemplate;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesColumnTemplate;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesDataTableChildrenEncoder;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesDataTableStyleClassesApplier;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesSubTableTemplate;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.jboss.tools.vpe.editor.util.VpeStyleUtil;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RichFacesScrollableDataTableTemplate
extends VpeAbstractTemplate {
    private static final String COLUMN = ":column";
    private static final String COLUMNS = ":columns";
    private static final String DEFAULT_HEIGHT = "500px";
    private static final String DEFAULT_WIDTH = "700px";
    private static final String CSS_STYLE_PATH = "scrollableDataTable/scrollableDataTable.css";
    private static final String COMPONENT_NAME = "richFacesDataTable";
    private static final String CSS_DR_TABLE = "dr-table";
    private static final String CSS_DR_TABLE_HIDDEN = "dr-table-hidden";
    private static final String CSS_RICH_SDT = "rich-sdt";
    private static final String CSS_RICH_SDT_HEADER_CELL = "rich-sdt-header-cell";
    private static final String CSS_RICH_SDT_HEADER_ROW = "rich-sdt-header-row";
    private static final String CSS_RICH_SDT_COLUMN_CELL = "rich-sdt-column-cell";
    private static final String CSS_RICH_SDT_FOOTER_CELL = "rich-sdt-footer-cell";
    private static final String CSS_RICH_SDT_FOOTER_ROW = "rich-sdt-footer-row";
    private static final String CSS_RICH_SDT_HSEP = "rich-sdt-hsep";
    private static final int NUM_ROW = 5;
    private static final String TAG_MAIN_TABLE_WRAPPER = "mainTable-wrapper";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        Element sourceElement = (Element)sourceNode;
        String width = DEFAULT_WIDTH;
        if (sourceElement.hasAttribute("width")) {
            String widthAttrVal = sourceElement.getAttribute("width");
            width = VpeStyleUtil.addPxIfNecessary((String)widthAttrVal);
        }
        String height = DEFAULT_HEIGHT;
        if (sourceElement.hasAttribute("height")) {
            String heightAttrVal = sourceElement.getAttribute("height");
            height = VpeStyleUtil.addPxIfNecessary((String)heightAttrVal);
        }
        nsIDOMElement div = visualDocument.createElement("div");
        div.setAttribute("class", CSS_DR_TABLE_HIDDEN);
        String divStyle = "width:" + width + ";" + "height" + ":" + height + ";overflow:auto;";
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)div);
        div.setAttribute("style", divStyle);
        nsIDOMElement mainTable = visualDocument.createElement("table");
        mainTable.removeAttribute("height");
        nsIDOMElement mainTableWrapper = visualDocument.createElement(TAG_MAIN_TABLE_WRAPPER);
        mainTableWrapper.appendChild((nsIDOMNode)mainTable);
        div.appendChild((nsIDOMNode)mainTableWrapper);
        ComponentUtil.setCSSLink(pageContext, CSS_STYLE_PATH, COMPONENT_NAME);
        String tableClass = "dr-table rich-sdt";
        if (sourceElement.hasAttribute("styleClass")) {
            tableClass = String.valueOf(tableClass) + " " + sourceElement.getAttribute("styleClass");
        }
        mainTable.setAttribute("class", tableClass);
        ArrayList<Element> columns = RichFacesScrollableDataTableTemplate.getColumns(sourceElement);
        int columnsLength = this.getColumnsCount(sourceElement, columns);
        nsIDOMElement colgroup = visualDocument.createElement("colgroup");
        colgroup.setAttribute("span", String.valueOf(columnsLength));
        mainTable.appendChild((nsIDOMNode)colgroup);
        this.encodeCaption(creationData, sourceElement, visualDocument, mainTable);
        Element header = ComponentUtil.getFacet(sourceElement, "header");
        ArrayList<Element> columnsHeaders = ComponentUtil.getColumnsWithFacet(columns, "header");
        if (header != null || !columnsHeaders.isEmpty()) {
            String headerClass;
            nsIDOMElement thead = visualDocument.createElement("thead");
            mainTable.appendChild((nsIDOMNode)thead);
            String string = headerClass = sourceElement.hasAttribute("headerClass") ? sourceElement.getAttribute("headerClass") : null;
            if (header != null) {
                this.encodeTableHeaderOrFooterFacet(pageContext, creationData, thead, columnsLength, visualDocument, header, "", "", "", headerClass, "td");
            }
            if (!columnsHeaders.isEmpty()) {
                nsIDOMElement tr = visualDocument.createElement("tr");
                thead.appendChild((nsIDOMNode)tr);
                String styleClass = ComponentUtil.encodeStyleClass(null, "dr-table-subheader dr-sdt-hr", null, headerClass);
                if (styleClass != null) {
                    tr.setAttribute("class", styleClass);
                }
                RichFacesScrollableDataTableTemplate.encodeHeaderOrFooterFacets(creationData, tr, visualDocument, columnsHeaders, "dr-table-subheadercell rich-table-subheadercell", headerClass, "header", "td");
            }
        }
        Element footer = ComponentUtil.getFacet(sourceElement, "footer");
        ArrayList<Element> columnsFooters = ComponentUtil.getColumnsWithFacet(columns, "footer");
        if (footer != null || !columnsFooters.isEmpty()) {
            String footerClass;
            nsIDOMElement tfoot = visualDocument.createElement("tfoot");
            mainTable.appendChild((nsIDOMNode)tfoot);
            String string = footerClass = sourceElement.hasAttribute("footerClass") ? sourceElement.getAttribute("footerClass") : null;
            if (!columnsFooters.isEmpty()) {
                nsIDOMElement tr = visualDocument.createElement("tr");
                tfoot.appendChild((nsIDOMNode)tr);
                String styleClass = ComponentUtil.encodeStyleClass(null, "dr-table-subfooter rich-table-subfooter", null, footerClass);
                if (styleClass != null) {
                    tr.setAttribute("class", styleClass);
                }
                RichFacesScrollableDataTableTemplate.encodeHeaderOrFooterFacets(creationData, tr, visualDocument, columnsFooters, "dr-table-subfootercell rich-table-subfootercell", footerClass, "footer", "td");
            }
            if (footer != null) {
                this.encodeTableHeaderOrFooterFacet(pageContext, creationData, tfoot, columnsLength, visualDocument, footer, "", "", "", footerClass, "td");
            }
        }
        nsIDOMElement tbody = visualDocument.createElement("tbody");
        mainTable.appendChild((nsIDOMNode)tbody);
        VisualDomUtil.copyAttributes((Node)sourceNode, (nsIDOMElement)tbody);
        int i = 0;
        while (i < 5) {
            new RichFacesDataTableChildrenEncoder(creationData, visualDocument, sourceElement, mainTable).encodeChildren();
            ++i;
        }
        return creationData;
    }

    protected void encodeCaption(VpeCreationData creationData, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement table) {
        Element captionFromFacet = ComponentUtil.getFacet(sourceElement, "caption");
        if (captionFromFacet != null) {
            nsIDOMElement caption = visualDocument.createElement("caption");
            table.appendChild((nsIDOMNode)caption);
            String captionClass = "dr-table-caption rich-table-caption";
            if (table.hasAttribute("captionClass")) {
                captionClass = String.valueOf(captionClass) + " " + table.getAttribute("captionClass");
            }
            caption.setAttribute("class", captionClass);
            if (table.hasAttribute("captionStyle")) {
                String captionStyle = table.getAttribute("captionStyle");
                caption.setAttribute("style", captionStyle);
            }
            VpeChildrenInfo cap = new VpeChildrenInfo(caption);
            cap.addSourceChild((Node)captionFromFacet);
            creationData.addChildrenInfo(cap);
        }
    }

    public static void encodeHeaderOrFooterFacets(VpeCreationData creationData, nsIDOMElement parentTr, nsIDOMDocument visualDocument, ArrayList<Element> headersOrFooters, String skinCellClass, String headerClass, String facetName, String element) {
        for (Element column : headersOrFooters) {
            String classAttribute;
            String columnHeaderClass = column.hasAttribute(classAttribute = String.valueOf(facetName) + "Class") ? column.getAttribute(classAttribute) : null;
            nsIDOMElement td = visualDocument.createElement(element);
            parentTr.appendChild((nsIDOMNode)td);
            String styleClass = ComponentUtil.encodeStyleClass(null, skinCellClass, headerClass, columnHeaderClass);
            if (!RichFacesColumnTemplate.isVisible(column)) {
                VisualDomUtil.setSubAttribute((nsIDOMElement)td, (String)"style", (String)"display", (String)"none");
            }
            td.setAttribute("class", styleClass);
            td.setAttribute("scop", "col");
            if (column.hasAttribute("colspan")) {
                String colspan = column.getAttribute("colspan");
                td.setAttribute("colspan", colspan);
            }
            Element facetBody = ComponentUtil.getFacet(column, facetName);
            VpeChildrenInfo child = new VpeChildrenInfo(td);
            child.addSourceChild((Node)facetBody);
            creationData.addChildrenInfo(child);
        }
    }

    protected void encodeTableHeaderOrFooterFacet(VpePageContext pageContext, VpeCreationData creationData, nsIDOMElement parentTheadOrTfood, int columns, nsIDOMDocument visualDocument, Element facetBody, String skinFirstRowClass, String skinRowClass, String skinCellClass, String facetBodyClass, String element) {
        boolean isColumnGroup = facetBody.getNodeName().endsWith(":columnGroup");
        boolean isSubTable = facetBody.getNodeName().endsWith(":subTable");
        if (isColumnGroup) {
            RichFacesColumnGroupTemplate.DEFAULT_INSTANCE.encodeSubTable(pageContext, creationData, facetBody, visualDocument, parentTheadOrTfood);
        } else if (isSubTable) {
            RichFacesSubTableTemplate.DEFAULT_INSTANCE.encodeSubTable(pageContext, creationData, facetBody, visualDocument, parentTheadOrTfood);
        } else {
            nsIDOMElement tr = visualDocument.createElement("tr");
            parentTheadOrTfood.appendChild((nsIDOMNode)tr);
            String styleClass = ComponentUtil.encodeStyleClass(null, skinFirstRowClass, facetBodyClass, null);
            if (styleClass != null) {
                tr.setAttribute("class", styleClass);
            }
            nsIDOMElement td = visualDocument.createElement(element);
            tr.appendChild((nsIDOMNode)td);
            styleClass = ComponentUtil.encodeStyleClass(null, skinCellClass, facetBodyClass, null);
            if (styleClass != null) {
                td.setAttribute("class", styleClass);
            }
            td.setAttribute("colspan", "100");
            td.setAttribute("scope", "colgroup");
            VpeChildrenInfo child = new VpeChildrenInfo(td);
            child.addSourceChild((Node)facetBody);
            creationData.addChildrenInfo(child);
        }
    }

    public static ArrayList<Element> getColumns(Element parentSourceElement) {
        ArrayList<Element> columns = new ArrayList<Element>();
        NodeList children = parentSourceElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (child instanceof Element && (nodeName.endsWith(COLUMN) || nodeName.endsWith(COLUMNS))) {
                columns.add((Element)child);
            }
            ++i;
        }
        return columns;
    }

    protected int getColumnsCount(Element sourceElement, ArrayList<Element> columns) {
        int count = 0;
        try {
            int span = Integer.parseInt(sourceElement.getAttribute("columns"));
            count = count > 0 ? span : this.calculateRowColumns(sourceElement, columns);
        }
        catch (NumberFormatException numberFormatException) {
            count = this.calculateRowColumns(sourceElement, columns);
        }
        return count;
    }

    private int calculateRowColumns(Element sourceElement, ArrayList<Element> columns) {
        int count = 0;
        int currentLength = 0;
        for (Element column : columns) {
            if (!ComponentUtil.isRendered(column)) continue;
            String nodeName = column.getNodeName();
            if (nodeName.endsWith(":columnGroup")) {
                if (currentLength > count) {
                    count = currentLength;
                }
                if ((currentLength = this.calculateRowColumns(sourceElement, RichFacesScrollableDataTableTemplate.getColumns(column))) > count) {
                    count = currentLength;
                }
                currentLength = 0;
                continue;
            }
            if (nodeName.equals(String.valueOf(sourceElement.getPrefix()) + COLUMN) || nodeName.equals(String.valueOf(sourceElement.getPrefix()) + COLUMNS)) {
                if (RichFacesColumnTemplate.isBreakBefore(column)) {
                    if (currentLength > count) {
                        count = currentLength;
                    }
                    currentLength = 0;
                }
                String colspanStr = column.getAttribute("colspan");
                try {
                    int colspan = Integer.parseInt(colspanStr);
                    currentLength += colspan > 0 ? colspan : 1;
                }
                catch (NumberFormatException numberFormatException) {
                    ++currentLength;
                }
                continue;
            }
            if (!nodeName.endsWith(COLUMN)) continue;
            ++currentLength;
        }
        if (currentLength > count) {
            count = currentLength;
        }
        return count;
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }

    public void validate(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData data) {
        RichFacesDataTableChildrenEncoder.validateChildren(pageContext, sourceNode, visualDocument, data);
        this.applyStyleClasses(pageContext, sourceNode, visualDocument, data);
    }

    private void applyStyleClasses(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData data) {
        nsIDOMNode mainTableWrapper;
        nsIDOMNodeList mainTableWrapperChildren;
        nsIDOMElement element = (nsIDOMElement)data.getNode();
        nsIDOMNodeList mainTableWrappers = element.getElementsByTagName(TAG_MAIN_TABLE_WRAPPER);
        if (mainTableWrappers == null || mainTableWrappers.getLength() != 1L) {
            RuntimeException e = new RuntimeException("This is probably a bug. There should be exatly one mainTable-wrapper");
            RichFacesTemplatesActivator.getPluginLog().logError((Throwable)e);
        }
        if ((mainTableWrapperChildren = (mainTableWrapper = mainTableWrappers.item(0L)).getChildNodes()) == null || mainTableWrapperChildren.getLength() != 1L) {
            RuntimeException e = new RuntimeException("This is probably a bug. mainTable-wrapper should have exactly one child.");
            RichFacesTemplatesActivator.getPluginLog().logError((Throwable)e);
        }
        nsIDOMElement mainTable = (nsIDOMElement)XPCOM.queryInterface((nsISupports)mainTableWrapperChildren.item(0L), nsIDOMElement.class);
        RichFacesDataTableStyleClassesApplier styleClassesApplier = new RichFacesDataTableStyleClassesApplier(visualDocument, pageContext, sourceNode);
        styleClassesApplier.applyClasses(mainTable);
        VisualDomUtil.replaceNodeByItsChildren((nsIDOMNode)mainTableWrapper);
    }
}

