/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.ArrayList;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.jsf.vpe.richfaces.Messages;
import org.jboss.tools.jsf.vpe.richfaces.RichFacesTemplatesActivator;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesColumnGroupTemplate;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesDataTableChildrenEncoder;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesSubTableTemplate;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RichFacesOrderingList
extends VpeAbstractTemplate {
    private static final String COLUMN = ":column";
    private static final String COLUMNS = ":columns";
    private static final String DEFAULT_LIST_HEIGHT = "150px";
    private static final String DEFAULT_LIST_WIDTH = "300px";
    private static final String DEFAULT_HEIGHT = "200px";
    private static final String DEFAULT_WIDTH = "300px";
    private static final String TOP_CONTROL_FACET = "topControl";
    private static final String UP_CONTROL_FACET = "upControl";
    private static final String DOWN_CONTROL_FACET = "downControl";
    private static final String BOTTOM_CONTROL_FACET = "bottomControl";
    private static final String HEADER = "header";
    private static final String HEADER_CLASS = "headerClass";
    private static final String ARROW_TOP = "\u21d1";
    private static final String ARROW_UP = "\u2191";
    private static final String ARROW_DOWN = "\u2193";
    private static final String ARROW_BOTTOM = "\u21d3";
    private static final String TOP_CONTROL_IMG = "orderingList/top.gif";
    private static final String UP_CONTROL_IMG = "orderingList/up.gif";
    private static final String DOWN_CONTROL_IMG = "orderingList/down.gif";
    private static final String BOTTOM_CONTROL_IMG = "orderingList/bottom.gif";
    private static final String BUTTON_BG = "orderingList/button_bg.gif";
    private static final String HEADER_CELL_BG = "orderingList/table_header_cell_bg.gif";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String LIST_WIDTH = "listWidth";
    private static final String LIST_HEIGHT = "listHeight";
    private static final String TOP_CONTROL_LABEL = "topControlLabel";
    private static final String UP_CONTROL_LABEL = "upControlLabel";
    private static final String DOWN_CONTROL_LABEL = "downControlLabel";
    private static final String BOTTOM_CONTROL_LABEL = "bottomControlLabel";
    private static final String TOP_CONTROL_LABEL_DEFAULT = Messages.RichFacesOrderingList_FirstLabel;
    private static final String UP_CONTROL_LABEL_DEFAULT = Messages.RichFacesOrderingList_UpLabel;
    private static final String DOWN_CONTROL_LABEL_DEFAULT = Messages.RichFacesOrderingList_DownLabel;
    private static final String BOTTOM_CONTROL_LABEL_DEFAULT = Messages.RichFacesOrderingList_LastLabel;
    private static final String CAPTION_LABEL = "captionLabel";
    private static final String CONTROLS_TYPE = "controlsType";
    private static final String CONTROLS_VERTICAL_ALIGN = "controlsVerticalAlign";
    private static final String CONTROLS_HORIZONTAL_ALIGN = "controlsHorizontalAlign";
    private static final String SHOW_BUTTON_LABELS = "showButtonLabels";
    private static final String FAST_ORDER_CONTROL_VISIBLE = "fastOrderControlsVisible";
    private static final String ORDER_CONTROL_VISIBLE = "orderControlsVisible";
    private static final String LIST_CLASS = "listClass";
    private static final String CONTROLS_CLASS = "controlsClass";
    private static final String TOP_CONTROL_CLASS = "topControlClass";
    private static final String UP_CONTROL_CLASS = "upControlClass";
    private static final String DOWN_CONTROL_CLASS = "downControlClass";
    private static final String BOTTOM_CONTROL_CLASS = "bottomControlClass";
    private static final String CSS_CAPTION_CLASS = "rich-ordering-list-caption";
    private static final String CSS_CONTROLS_CLASS = "rich-ordering-controls";
    private static final String CSS_TOP_CONTROL_CLASS = "rich-ordering-control-top";
    private static final String CSS_BUTTON_LAYOUT_CLASS = "rich-ordering-list-button-layout";
    private static final String CSS_UP_CONTROL_CLASS = "rich-ordering-control-up";
    private static final String CSS_DOWN_CONTROL_CLASS = "rich-ordering-control-down";
    private static final String CSS_BOTTOM_CONTROL_CLASS = "rich-ordering-control-bottom";
    private static final String CSS_BUTTON_CLASS = "rich-ordering-list-button";
    private static final String CSS_BUTTON_SELECTION_CLASS = "rich-ordering-list-button-selection";
    private static final String CSS_BUTTON_CONTENT_CLASS = "rich-ordering-list-button-content";
    private static final String CSS_BUTTON_VALIGN_CLASS = "rich-ordering-list-button-valign";
    private static final String CSS_HEADER_CLASS = "rich-ordering-list-header";
    private static final String CSS_TABLE_HEADER_CLASS = "rich-ordering-list-table-header";
    private static final String CSS_TABLE_HEADER_CELL_CLASS = "rich-ordering-list-table-header-cell";
    private static final String CSS_LIST_BODY_CLASS = "rich-ordering-list-body";
    private static final String CSS_LIST_OUTPUT_CLASS = "rich-ordering-list-output";
    private static final String CSS_LIST_CONTENT_CLASS = "rich-ordering-list-content";
    private static final String CSS_LIST_ITEMS_CLASS = "rich-ordering-list-items";
    private static final String CSS_LIST_ROW_CLASS = "rich-ordering-list-row";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        nsIDOMElement tableListCell;
        nsIDOMElement tableButtonsCell;
        ComponentUtil.setCSSLink(pageContext, "orderingList/orderingList.css", "richFacesOrderingList");
        Element sourceElement = (Element)sourceNode;
        String width = sourceElement.hasAttribute(WIDTH) ? sourceElement.getAttribute(WIDTH) : "300px";
        String height = sourceElement.hasAttribute(HEIGHT) ? sourceElement.getAttribute(HEIGHT) : DEFAULT_HEIGHT;
        nsIDOMElement tableCommon = visualDocument.createElement("table");
        nsIDOMElement tableBody = visualDocument.createElement("tbody");
        nsIDOMElement tableCaptionRow = visualDocument.createElement("tr");
        nsIDOMElement tableCaptionCell = visualDocument.createElement("td");
        nsIDOMElement tableCaptionDiv = visualDocument.createElement("div");
        nsIDOMElement tableListAndButtonsRow = visualDocument.createElement("tr");
        nsIDOMElement leftCell = visualDocument.createElement("td");
        nsIDOMElement rightCell = visualDocument.createElement("td");
        tableCaptionCell.appendChild((nsIDOMNode)tableCaptionDiv);
        tableCaptionRow.appendChild((nsIDOMNode)tableCaptionCell);
        tableBody.appendChild((nsIDOMNode)tableCaptionRow);
        tableListAndButtonsRow.appendChild((nsIDOMNode)leftCell);
        tableListAndButtonsRow.appendChild((nsIDOMNode)rightCell);
        tableBody.appendChild((nsIDOMNode)tableListAndButtonsRow);
        tableCommon.appendChild((nsIDOMNode)tableBody);
        String controlsHorizontalAlign = sourceElement.getAttribute(CONTROLS_HORIZONTAL_ALIGN);
        if ("left".equalsIgnoreCase(controlsHorizontalAlign)) {
            tableButtonsCell = leftCell;
            tableListCell = rightCell;
            tableButtonsCell.setAttribute("style", "width: 1%;");
        } else {
            tableButtonsCell = rightCell;
            tableListCell = leftCell;
        }
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)tableCommon);
        tableCommon.setAttribute(WIDTH, width);
        tableCommon.setAttribute(HEIGHT, height);
        tableCommon.setAttribute("class", CSS_LIST_BODY_CLASS);
        tableCaptionCell.setAttribute("class", CSS_CAPTION_CLASS);
        Element captionFacet = ComponentUtil.getFacet(sourceElement, "caption");
        if (captionFacet != null) {
            VpeChildrenInfo captionInfo = new VpeChildrenInfo(tableCaptionDiv);
            captionInfo.addSourceChild((Node)captionFacet);
            creationData.addChildrenInfo(captionInfo);
        } else {
            String captionLabel = sourceElement.getAttribute(CAPTION_LABEL);
            tableCaptionCell.appendChild((nsIDOMNode)visualDocument.createTextNode(captionLabel));
        }
        String controlsType = sourceElement.getAttribute(CONTROLS_TYPE);
        if (!"none".equalsIgnoreCase(controlsType)) {
            nsIDOMElement controlsDiv = this.createControlsDiv(pageContext, creationData, visualDocument, sourceElement);
            tableButtonsCell.setAttribute("class", CSS_BUTTON_VALIGN_CLASS);
            tableButtonsCell.setAttribute("align", "center");
            if (sourceElement.hasAttribute(CONTROLS_VERTICAL_ALIGN)) {
                String controlsVerticalAlign = sourceElement.getAttribute(CONTROLS_VERTICAL_ALIGN);
                String valign = "center".equalsIgnoreCase(controlsVerticalAlign) ? "middle" : controlsVerticalAlign;
                tableButtonsCell.setAttribute("valign", valign);
            }
            tableButtonsCell.appendChild((nsIDOMNode)controlsDiv);
        }
        tableListCell.appendChild((nsIDOMNode)this.createResultList(pageContext, creationData, visualDocument, sourceElement));
        return creationData;
    }

    private nsIDOMElement createControlsDiv(VpePageContext pageContext, VpeCreationData creationData, nsIDOMDocument visualDocument, Element sourceElement) {
        String topControlClass = sourceElement.getAttribute(TOP_CONTROL_CLASS);
        String upControlClass = sourceElement.getAttribute(UP_CONTROL_CLASS);
        String downControlClass = sourceElement.getAttribute(DOWN_CONTROL_CLASS);
        String bottomControlClass = sourceElement.getAttribute(BOTTOM_CONTROL_CLASS);
        String showButtonLabelsStr = sourceElement.getAttribute(SHOW_BUTTON_LABELS);
        String fastOrderControlsVisibleStr = sourceElement.getAttribute(FAST_ORDER_CONTROL_VISIBLE);
        String orderControlsVisibleStr = sourceElement.getAttribute(ORDER_CONTROL_VISIBLE);
        boolean showButtonLabels = ComponentUtil.string2boolean(showButtonLabelsStr);
        boolean fastOrderControlsVisible = ComponentUtil.string2boolean(fastOrderControlsVisibleStr);
        boolean orderControlsVisible = ComponentUtil.string2boolean(orderControlsVisibleStr);
        nsIDOMElement buttonsDiv = visualDocument.createElement("div");
        String controlsClass = "rich-ordering-controls ";
        if (sourceElement.hasAttribute(CONTROLS_CLASS)) {
            controlsClass = String.valueOf(controlsClass) + sourceElement.getAttribute(CONTROLS_CLASS) + " ";
        }
        buttonsDiv.setAttribute("class", String.valueOf(controlsClass) + CSS_BUTTON_LAYOUT_CLASS);
        Element top_control_facet = ComponentUtil.getFacet(sourceElement, TOP_CONTROL_FACET);
        Element up_control_facet = ComponentUtil.getFacet(sourceElement, UP_CONTROL_FACET);
        Element down_control_facet = ComponentUtil.getFacet(sourceElement, DOWN_CONTROL_FACET);
        Element bottom_control_facet = ComponentUtil.getFacet(sourceElement, BOTTOM_CONTROL_FACET);
        if (fastOrderControlsVisible) {
            String topControlLabel = sourceElement.hasAttribute(TOP_CONTROL_LABEL) ? sourceElement.getAttribute(TOP_CONTROL_LABEL) : TOP_CONTROL_LABEL_DEFAULT;
            nsIDOMElement btnTopDiv = this.createSingleButtonDiv(pageContext, creationData, visualDocument, topControlLabel, ARROW_TOP, showButtonLabels, top_control_facet, CSS_TOP_CONTROL_CLASS, topControlClass);
            buttonsDiv.appendChild((nsIDOMNode)btnTopDiv);
        }
        if (orderControlsVisible) {
            String upControlLabel = sourceElement.hasAttribute(UP_CONTROL_LABEL) ? sourceElement.getAttribute(UP_CONTROL_LABEL) : UP_CONTROL_LABEL_DEFAULT;
            String downControlLabel = sourceElement.hasAttribute(DOWN_CONTROL_LABEL) ? sourceElement.getAttribute(DOWN_CONTROL_LABEL) : DOWN_CONTROL_LABEL_DEFAULT;
            nsIDOMElement btnUpDiv = this.createSingleButtonDiv(pageContext, creationData, visualDocument, upControlLabel, ARROW_UP, showButtonLabels, up_control_facet, CSS_UP_CONTROL_CLASS, upControlClass);
            nsIDOMElement btnDownDiv = this.createSingleButtonDiv(pageContext, creationData, visualDocument, downControlLabel, ARROW_DOWN, showButtonLabels, down_control_facet, CSS_DOWN_CONTROL_CLASS, downControlClass);
            buttonsDiv.appendChild((nsIDOMNode)btnUpDiv);
            buttonsDiv.appendChild((nsIDOMNode)btnDownDiv);
        }
        if (fastOrderControlsVisible) {
            String bottomControlLabel = sourceElement.hasAttribute(BOTTOM_CONTROL_LABEL) ? sourceElement.getAttribute(BOTTOM_CONTROL_LABEL) : BOTTOM_CONTROL_LABEL_DEFAULT;
            nsIDOMElement btnBottomDiv = this.createSingleButtonDiv(pageContext, creationData, visualDocument, bottomControlLabel, ARROW_BOTTOM, showButtonLabels, bottom_control_facet, CSS_BOTTOM_CONTROL_CLASS, bottomControlClass);
            buttonsDiv.appendChild((nsIDOMNode)btnBottomDiv);
        }
        return buttonsDiv;
    }

    private nsIDOMElement createSingleButtonDiv(VpePageContext pageContext, VpeCreationData creationData, nsIDOMDocument visualDocument, String btnName, String arrowName, boolean showButtonLabels, Element buttonFacet, String cssStyleName, String customStyleClass) {
        nsIDOMElement div1 = visualDocument.createElement("div");
        nsIDOMElement div2 = visualDocument.createElement("div");
        nsIDOMElement div3 = visualDocument.createElement("div");
        div1.setAttribute("class", "dr-buttons-border " + cssStyleName + (customStyleClass != null ? " " + customStyleClass : ""));
        div2.setAttribute("class", CSS_BUTTON_CLASS);
        String resourceFolder = RichFacesTemplatesActivator.getPluginResourcePath();
        String divStyle = "width: 100%;background-image: url(file://" + resourceFolder + BUTTON_BG + ");";
        div2.setAttribute("style", divStyle);
        div1.appendChild((nsIDOMNode)div2);
        if (buttonFacet != null) {
            nsIDOMElement fecetDiv = this.encodeControlsFacets(pageContext, buttonFacet, cssStyleName, customStyleClass, creationData, visualDocument);
            div2.appendChild((nsIDOMNode)fecetDiv);
        } else {
            if (showButtonLabels) {
                div3.appendChild((nsIDOMNode)visualDocument.createTextNode(String.valueOf(arrowName) + " " + btnName));
            } else {
                div3.appendChild((nsIDOMNode)visualDocument.createTextNode(arrowName));
            }
            div3.setAttribute("class", "rich-ordering-list-button-selection rich-ordering-list-button-content");
            div2.appendChild((nsIDOMNode)div3);
        }
        return div1;
    }

    private nsIDOMElement createResultList(VpePageContext pageContext, VpeCreationData creationData, nsIDOMDocument visualDocument, Element sourceElement) {
        nsIDOMElement contentDiv = visualDocument.createElement("div");
        nsIDOMElement contentTable = visualDocument.createElement("table");
        nsIDOMElement thead = visualDocument.createElement("thead");
        ArrayList<Element> columns = RichFacesOrderingList.getColumns(sourceElement);
        ArrayList<Element> columnsHeaders = ComponentUtil.getColumnsWithFacet(columns, HEADER);
        if (!columnsHeaders.isEmpty()) {
            String headerClass = sourceElement.hasAttribute(HEADER_CLASS) ? sourceElement.getAttribute(HEADER_CLASS) : null;
            nsIDOMElement tr = visualDocument.createElement("tr");
            thead.appendChild((nsIDOMNode)tr);
            String styleClass = ComponentUtil.encodeStyleClass(null, "rich-ordering-list-header rich-ordering-list-table-header", "", headerClass);
            if (styleClass != null) {
                tr.setAttribute("class", styleClass);
            }
            for (Element column : columnsHeaders) {
                String columnHeaderClass = column.hasAttribute(HEADER_CLASS) ? column.getAttribute(HEADER_CLASS) : null;
                nsIDOMElement td = visualDocument.createElement("td");
                tr.appendChild((nsIDOMNode)td);
                td.setAttribute("background", "file:///" + ComponentUtil.getAbsoluteResourcePath(HEADER_CELL_BG).replace('\\', '/'));
                styleClass = ComponentUtil.encodeStyleClass(null, CSS_TABLE_HEADER_CELL_CLASS, headerClass, columnHeaderClass);
                td.setAttribute("class", styleClass);
                if (column.hasAttribute("colspan")) {
                    String colspan = column.getAttribute("colspan");
                    td.setAttribute("colspan", colspan);
                }
                Element facetBody = ComponentUtil.getFacet(column, HEADER);
                VpeChildrenInfo child = new VpeChildrenInfo(td);
                child.addSourceChild((Node)facetBody);
                creationData.addChildrenInfo(child);
            }
        }
        String listWidth = sourceElement.hasAttribute(LIST_WIDTH) ? sourceElement.getAttribute(LIST_WIDTH) : "300px";
        String listHeight = sourceElement.hasAttribute(LIST_HEIGHT) ? sourceElement.getAttribute(LIST_HEIGHT) : DEFAULT_LIST_HEIGHT;
        String divStyle = "width : " + listWidth + ";" + HEIGHT + " : " + listHeight + ";" + "overflow: scroll;";
        contentDiv.setAttribute("style", divStyle);
        contentDiv.setAttribute("class", "rich-ordering-list-output rich-ordering-list-content");
        String listClass = CSS_LIST_ITEMS_CLASS;
        if (sourceElement.hasAttribute(LIST_CLASS)) {
            listClass = String.valueOf(listClass) + " " + sourceElement.getAttribute(LIST_CLASS);
        }
        contentTable.setAttribute("class", listClass);
        contentTable.setAttribute("cellspacing", "1");
        VisualDomUtil.copyAttributes((Node)sourceElement, (nsIDOMElement)contentTable);
        contentTable.removeAttribute(HEIGHT);
        contentTable.setAttribute("style", "width: 100%;");
        contentTable.appendChild((nsIDOMNode)thead);
        RichFacesDataTableChildrenEncoder childrenEncoder = new RichFacesDataTableChildrenEncoder(creationData, visualDocument, sourceElement, contentTable);
        childrenEncoder.setRowClasses(CSS_LIST_ROW_CLASS, CSS_LIST_ROW_CLASS);
        childrenEncoder.encodeChildren();
        contentDiv.appendChild((nsIDOMNode)contentTable);
        return contentDiv;
    }

    private nsIDOMElement encodeControlsFacets(VpePageContext pageContext, Element facetBody, String cssStyleName, String customStyleClass, VpeCreationData creationData, nsIDOMDocument visualDocument) {
        nsIDOMElement fecetDiv = visualDocument.createElement("div");
        nsIDOMElement table = visualDocument.createElement("table");
        nsIDOMElement tbody = visualDocument.createElement("tbody");
        boolean isColumnGroup = facetBody.getNodeName().endsWith(":columnGroup");
        boolean isSubTable = facetBody.getNodeName().endsWith(":subTable");
        if (isColumnGroup) {
            RichFacesColumnGroupTemplate.DEFAULT_INSTANCE.encodeSubTable(pageContext, creationData, facetBody, visualDocument, tbody);
        } else if (isSubTable) {
            RichFacesSubTableTemplate.DEFAULT_INSTANCE.encodeSubTable(pageContext, creationData, facetBody, visualDocument, tbody);
        } else {
            nsIDOMElement tr = visualDocument.createElement("tr");
            tbody.appendChild((nsIDOMNode)tr);
            nsIDOMElement td = visualDocument.createElement("td");
            tr.appendChild((nsIDOMNode)td);
            td.setAttribute("scope", "colgroup");
            VpeChildrenInfo child = new VpeChildrenInfo(td);
            child.addSourceChild((Node)facetBody);
            creationData.addChildrenInfo(child);
            tr.setAttribute("class", CSS_BUTTON_CLASS);
            td.setAttribute("class", "rich-ordering-list-button-content " + cssStyleName + " " + customStyleClass);
            fecetDiv.setAttribute("class", "rich-ordering-list-button rich-ordering-list-button-content " + cssStyleName + " " + customStyleClass);
        }
        table.setAttribute("class", CSS_BUTTON_CONTENT_CLASS);
        table.appendChild((nsIDOMNode)tbody);
        fecetDiv.appendChild((nsIDOMNode)table);
        return fecetDiv;
    }

    private static ArrayList<Element> getColumns(Element parentSourceElement) {
        ArrayList<Element> columns = new ArrayList<Element>();
        NodeList children = parentSourceElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (child instanceof Element && (nodeName.endsWith(COLUMN) || nodeName.endsWith(COLUMNS))) {
                columns.add((Element)child);
            }
            ++i;
        }
        return columns;
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }

    public void validate(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData data) {
        RichFacesDataTableChildrenEncoder.validateChildren(pageContext, sourceNode, visualDocument, data);
    }
}

