/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.jsf.vpe.richfaces.template.AbstractEditableRichFacesTemplate;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.AttributeData;
import org.jboss.tools.vpe.editor.mapping.NodeData;
import org.jboss.tools.vpe.editor.mapping.VpeElementData;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RichFacesInputNumberSpinnerTemplate
extends AbstractEditableRichFacesTemplate {
    private static final String CSS_FILE_NAME = "inputNumberSpinner/inputNumberSpinner.css";
    private static final String IMAGE_NAME_UP = "/inputNumberSpinner/up.gif";
    private static final String IMAGE_NAME_DOWN = "/inputNumberSpinner/down.gif";
    private static final String DEFAULT_INPUT_SIZE = "10px";
    private static final String DEFAULT_ZERO_SIZE = "0px";
    private static final String DEFAULT_WIDTH = "1%";
    private static final String DEFAULT_CONTAINER_WRAPPER_WIDTH = "2%";
    private static final String DEFAULT_CONTAINER_STYLE = "dr-spnr-c";
    private static final String DEFAULT_INPUT_STYLE = "dr-spnr-i";
    private static final String DEFAULT_INPUT_CONTAINER_STYLE = "dr-spnr-e";
    private static final String DEFAULT_BUTTONS_STYLE = "dr-spnr-b";
    private static final String DEFAULT_BUTTON_STYLE = "dr-spnr-bn";
    private static final String DISABLED_INPUT_STYLE = "color:grey";
    private static final String RICH_SPINNER_C_STYLE = "rich-spinner-c";
    private static final String RICH_SPINNER_INPUT_CONTAINER_STYLE = "rich-spinner-input-container";
    private static final String RICH_SPINNER_INPUT_STYLE = "rich-spinner-input";
    private static final String RICH_SPINNER_BUTTON_STYLE = "rich-spinner-button";
    private static final String RICH_SPINNER_BUTTONS_STYLE = "rich-spinner-buttons";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        ComponentUtil.setCSSLink(pageContext, CSS_FILE_NAME, "richFacesInputNumberSpinner");
        Element sourceElement = (Element)sourceNode;
        nsIDOMElement table = visualDocument.createElement("table");
        table.setAttribute("border", DEFAULT_ZERO_SIZE);
        table.setAttribute("cellpadding", DEFAULT_ZERO_SIZE);
        table.setAttribute("cellspacing", DEFAULT_ZERO_SIZE);
        table.setAttribute("width", DEFAULT_CONTAINER_WRAPPER_WIDTH);
        VpeElementData elementData = new VpeElementData();
        nsIDOMElement row = visualDocument.createElement("tr");
        nsIDOMElement cellInput = visualDocument.createElement("td");
        cellInput.setAttribute("class", "dr-spnr-e rich-spinner-input-container");
        cellInput.setAttribute("width", DEFAULT_WIDTH);
        cellInput.appendChild((nsIDOMNode)this.createInputElement(visualDocument, sourceElement, elementData));
        row.appendChild((nsIDOMNode)cellInput);
        nsIDOMElement cellArrows = visualDocument.createElement("td");
        cellArrows.setAttribute("class", "dr-spnr-b rich-spinner-buttons");
        cellArrows.setAttribute("width", DEFAULT_WIDTH);
        cellArrows.appendChild((nsIDOMNode)this.createArrowsElement(visualDocument, sourceNode));
        row.appendChild((nsIDOMNode)cellArrows);
        table.appendChild((nsIDOMNode)row);
        String tmp = this.getAttribute(sourceElement, "style");
        if (!tmp.equals("")) {
            table.setAttribute("style", tmp);
        }
        tmp = "dr-spnr-c rich-spinner-c " + this.getAttribute(sourceElement, "styleClass");
        table.setAttribute("class", tmp);
        VpeCreationData creationData = VisualDomUtil.createTemplateWithTextContainer((Element)sourceElement, (nsIDOMElement)table, (String)"div", (nsIDOMDocument)visualDocument);
        return creationData;
    }

    private nsIDOMElement createArrowsElement(nsIDOMDocument visualDocument, Node sourceNode) {
        nsIDOMElement table = visualDocument.createElement("table");
        table.setAttribute("border", DEFAULT_ZERO_SIZE);
        table.setAttribute("cellpadding", DEFAULT_ZERO_SIZE);
        table.setAttribute("cellspacing", DEFAULT_ZERO_SIZE);
        nsIDOMElement rowUp = visualDocument.createElement("tr");
        nsIDOMElement cellUp = visualDocument.createElement("td");
        nsIDOMElement imageUpElement = visualDocument.createElement("input");
        ComponentUtil.setImg(imageUpElement, IMAGE_NAME_UP);
        imageUpElement.setAttribute("border", DEFAULT_ZERO_SIZE);
        imageUpElement.setAttribute("type", "image");
        imageUpElement.setAttribute("class", "dr-spnr-bn rich-spinner-button");
        cellUp.appendChild((nsIDOMNode)imageUpElement);
        rowUp.appendChild((nsIDOMNode)cellUp);
        table.appendChild((nsIDOMNode)rowUp);
        nsIDOMElement rowDown = visualDocument.createElement("tr");
        nsIDOMElement cellDown = visualDocument.createElement("td");
        nsIDOMElement imageDownElement = visualDocument.createElement("input");
        ComponentUtil.setImg(imageDownElement, IMAGE_NAME_DOWN);
        imageDownElement.setAttribute("border", DEFAULT_ZERO_SIZE);
        imageDownElement.setAttribute("type", "image");
        imageDownElement.setAttribute("class", "dr-spnr-bn rich-spinner-button");
        cellDown.appendChild((nsIDOMNode)imageDownElement);
        rowDown.appendChild((nsIDOMNode)cellDown);
        table.appendChild((nsIDOMNode)rowDown);
        return table;
    }

    private nsIDOMElement createInputElement(nsIDOMDocument visualDocument, Element sourceElement, VpeElementData elementData) {
        nsIDOMElement inputElement = visualDocument.createElement("input");
        inputElement.setAttribute("class", this.getInputClass(sourceElement));
        String attrStyle = this.getInputStyle(sourceElement);
        if (!attrStyle.equals("")) {
            inputElement.setAttribute("style", attrStyle);
        }
        inputElement.setAttribute("type", "text");
        inputElement.setAttribute("size", this.getInputSize(sourceElement));
        inputElement.setAttribute("value", this.getInputValue(sourceElement));
        if (sourceElement.hasAttribute("value")) {
            elementData.addNodeData(new NodeData((Node)sourceElement.getAttributeNode("value"), (nsIDOMNode)inputElement, true));
        } else {
            elementData.addNodeData((NodeData)new AttributeData("value", (nsIDOMNode)inputElement, true));
        }
        return inputElement;
    }

    private String getInputValue(Element sourceElement) {
        String returnValue = this.getAttribute(sourceElement, "value");
        return returnValue;
    }

    private String getInputStyle(Element sourceElement) {
        String disabled;
        String returnValue = this.getAttribute(sourceElement, "inputStyle");
        if (sourceElement.hasAttribute("disabled") && (disabled = this.getAttribute(sourceElement, "disabled")) != null && disabled.equals("true")) {
            returnValue = String.valueOf(returnValue) + ";color:grey";
        }
        return returnValue;
    }

    protected String getInputSize(Element sourceElement) {
        String returnValue = DEFAULT_INPUT_SIZE;
        String tmp = this.getAttribute(sourceElement, "inputSize");
        if (tmp.length() != 0) {
            returnValue = tmp;
        }
        return returnValue;
    }

    public String getInputClass(Element sourceElement) {
        String returnValue = DEFAULT_INPUT_STYLE;
        returnValue = String.valueOf(returnValue) + " rich-spinner-input";
        String tmp = this.getAttribute(sourceElement, "inputClass");
        if (tmp.length() != 0) {
            returnValue = String.valueOf(returnValue) + " " + tmp;
        }
        return returnValue;
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }
}

