/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.util.VpeStyleUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.w3c.dom.Element;

class RichFacesEditorTemplateHelper {
    private static final String STYLE_PATH = "editor/editor.css";
    private final VpePageContext pageContext;
    private final Element sourceElement;
    private final nsIDOMDocument visualDocument;

    public RichFacesEditorTemplateHelper(VpePageContext pageContext, Element sourceNode, nsIDOMDocument visualDocument) {
        this.pageContext = pageContext;
        this.sourceElement = sourceNode;
        this.visualDocument = visualDocument;
    }

    public nsIDOMElement create() {
        ComponentUtil.setCSSLink(this.pageContext, STYLE_PATH, "editor");
        nsIDOMElement mainSpan = this.visualDocument.createElement("span");
        String styleClass = "richfacesSimpleSkin";
        if (this.sourceElement.hasAttribute("styleClass")) {
            styleClass = String.valueOf(styleClass) + " " + this.sourceElement.getAttribute("styleClass");
        }
        mainSpan.setAttribute("class", styleClass);
        String style = "display: table;";
        if (this.sourceElement.hasAttribute("style")) {
            style = String.valueOf(style) + this.sourceElement.getAttribute("style");
        }
        mainSpan.setAttribute("style", style);
        nsIDOMElement mainTable = this.createMainTable();
        nsIDOMElement textContainer = this.createTextContainer();
        nsIDOMElement toolbar = this.createToolbar();
        mainSpan.appendChild((nsIDOMNode)mainTable);
        mainTable.appendChild((nsIDOMNode)textContainer);
        mainTable.appendChild((nsIDOMNode)toolbar);
        return mainSpan;
    }

    private nsIDOMElement createMainTable() {
        String style = "width: 183px; height: 100px;";
        if (this.sourceElement.hasAttribute("width")) {
            String width = this.sourceElement.getAttribute("width");
            width = VpeStyleUtil.addPxIfNecessary((String)width);
            style = VpeStyleUtil.setParameterInStyle((String)style, (String)"width", (String)width);
        }
        if (this.sourceElement.hasAttribute("height")) {
            String height = this.sourceElement.getAttribute("height");
            height = VpeStyleUtil.addPxIfNecessary((String)height);
            style = VpeStyleUtil.setParameterInStyle((String)style, (String)"height", (String)height);
        }
        nsIDOMElement mainTable = this.visualDocument.createElement("table");
        mainTable.setAttribute("cellspacing", "0");
        mainTable.setAttribute("cellpadding", "0");
        mainTable.setAttribute("class", "mceLayout");
        mainTable.setAttribute("style", style);
        return mainTable;
    }

    private nsIDOMElement createTextContainer() {
        nsIDOMElement outerTR = this.visualDocument.createElement("tr");
        outerTR.setAttribute("style", "height: 100%;");
        nsIDOMElement outerTD = this.visualDocument.createElement("td");
        nsIDOMElement div = this.visualDocument.createElement("div");
        div.setAttribute("class", "mceIframeContainer");
        div.setAttribute("style", "height: 100%;");
        nsIDOMElement table = this.visualDocument.createElement("table");
        table.setAttribute("border", "0");
        table.setAttribute("style", "width: 100%; height: 100%;");
        nsIDOMElement innerTR = this.visualDocument.createElement("tr");
        nsIDOMElement innerTD = this.visualDocument.createElement("td");
        nsIDOMText text = this.visualDocument.createTextNode(" ");
        outerTR.appendChild((nsIDOMNode)outerTD);
        outerTD.appendChild((nsIDOMNode)div);
        div.appendChild((nsIDOMNode)table);
        table.appendChild((nsIDOMNode)innerTR);
        innerTR.appendChild((nsIDOMNode)innerTD);
        innerTD.appendChild((nsIDOMNode)text);
        return outerTR;
    }

    private nsIDOMElement createToolbar() {
        nsIDOMElement outerTR = this.visualDocument.createElement("tr");
        nsIDOMElement outerTD = this.visualDocument.createElement("td");
        outerTD.setAttribute("class", "mceToolbar");
        nsIDOMElement table = this.visualDocument.createElement("table");
        table.setAttribute("cellspacing", "0");
        table.setAttribute("cellpadding", "0");
        table.setAttribute("class", "mceToolbarTable");
        nsIDOMElement innerTR = this.visualDocument.createElement("tr");
        nsIDOMElement innerTD = this.visualDocument.createElement("td");
        nsIDOMElement div = this.visualDocument.createElement("div");
        div.setAttribute("class", "mce_panel");
        outerTR.appendChild((nsIDOMNode)outerTD);
        outerTD.appendChild((nsIDOMNode)table);
        table.appendChild((nsIDOMNode)innerTR);
        innerTR.appendChild((nsIDOMNode)innerTD);
        innerTD.appendChild((nsIDOMNode)div);
        return outerTR;
    }
}

