/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesDataTableTemplate;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.SourceDomUtil;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RichFacesDataGridTemplate
extends RichFacesDataTableTemplate {
    private int defaultRows = 3;
    private int defaultColumns = 1;
    private String[] rowClasses;
    private String[] columnClasses;

    @Override
    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        Element footer;
        Map footerFacetChildren;
        Node footerBody;
        Element sourceElement = (Element)sourceNode;
        this.initStyleClasses(sourceElement);
        nsIDOMElement table = visualDocument.createElement("table");
        VisualDomUtil.copyAttributes((Node)sourceNode, (nsIDOMElement)table);
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)table);
        creationData.addChildrenInfo(new VpeChildrenInfo(null));
        ComponentUtil.setCSSLink(pageContext, "dataTable/dataTable.css", "richFacesDataGrid");
        String tableClass = "dr-table rich-table";
        if (sourceElement.hasAttribute("styleClass")) {
            tableClass = String.valueOf(tableClass) + " " + sourceElement.getAttribute("styleClass");
        }
        table.setAttribute("class", tableClass);
        int columnsLength = this.getColumnsCount(sourceElement);
        nsIDOMElement colgroup = visualDocument.createElement("colgroup");
        colgroup.setAttribute("span", String.valueOf(columnsLength));
        table.appendChild((nsIDOMNode)colgroup);
        Element caption = SourceDomUtil.getFacetByName((VpePageContext)pageContext, (Element)sourceElement, (String)"caption");
        Map captionFacetChildren = VisualDomUtil.findFacetElements((Node)caption, (VpePageContext)pageContext);
        Node captionBody = ComponentUtil.getFacetBody(captionFacetChildren);
        this.encodeCaption(pageContext, creationData, sourceElement, visualDocument, table, captionBody);
        Element header = SourceDomUtil.getFacetByName((VpePageContext)pageContext, (Element)sourceElement, (String)"header");
        Map headerFacetChildren = VisualDomUtil.findFacetElements((Node)header, (VpePageContext)pageContext);
        Node headerBody = ComponentUtil.getFacetBody(headerFacetChildren);
        if (headerBody != null) {
            nsIDOMElement thead = visualDocument.createElement("thead");
            table.appendChild((nsIDOMNode)thead);
            String headerClass = sourceElement.hasAttribute("headerClass") ? sourceElement.getAttribute("headerClass") : null;
            this.encodeTableHeaderOrFooterFacet(pageContext, creationData, thead, columnsLength, visualDocument, headerBody, "dr-table-header rich-table-header", "dr-table-header-continue rich-table-header-continue", "dr-table-headercell rich-table-headercell", headerClass, "td", false);
        }
        if ((footerBody = ComponentUtil.getFacetBody(footerFacetChildren = VisualDomUtil.findFacetElements((Node)(footer = SourceDomUtil.getFacetByName((VpePageContext)pageContext, (Element)sourceElement, (String)"footer")), (VpePageContext)pageContext))) != null) {
            nsIDOMElement tfoot = visualDocument.createElement("tfoot");
            table.appendChild((nsIDOMNode)tfoot);
            String footerClass = sourceElement.hasAttribute("footerClass") ? sourceElement.getAttribute("footerClass") : null;
            this.encodeTableHeaderOrFooterFacet(pageContext, creationData, tfoot, columnsLength, visualDocument, footerBody, "dr-table-footer rich-table-footer", "dr-table-footer-continue rich-table-footer-continue", "dr-table-footercell rich-table-footercell", footerClass, "td", false);
        }
        nsIDOMElement tbody = visualDocument.createElement("tbody");
        table.appendChild((nsIDOMNode)tbody);
        List<Node> children = ComponentUtil.getChildren(sourceElement, true);
        sourceElement.getAttribute("elements");
        int elementsCount = this.getElementsCount(sourceElement, columnsLength);
        if (columnsLength > 0) {
            int rowIndex = 0;
            int elementIndex = 0;
            while (elementIndex < elementsCount) {
                nsIDOMElement tr = visualDocument.createElement("tr");
                tbody.appendChild((nsIDOMNode)tr);
                tr.setAttribute("class", "dr-table-row rich-table-row " + this.getRowClass(rowIndex));
                int columnIndex = 0;
                while (columnIndex < columnsLength && elementIndex < elementsCount) {
                    nsIDOMElement td = visualDocument.createElement("td");
                    tr.appendChild((nsIDOMNode)td);
                    td.setAttribute("class", "dr-table-cell rich-table-cell " + this.getColumnClass(columnIndex));
                    VpeChildrenInfo childInfo = null;
                    if (((List)captionFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)).size() > 0) {
                        childInfo = new VpeChildrenInfo(td);
                        for (Node child : (List)captionFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)) {
                            childInfo.addSourceChild(child);
                        }
                        creationData.addChildrenInfo(childInfo);
                    }
                    if (((List)headerFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)).size() > 0) {
                        childInfo = new VpeChildrenInfo(td);
                        for (Node child : (List)headerFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)) {
                            childInfo.addSourceChild(child);
                        }
                        creationData.addChildrenInfo(childInfo);
                    }
                    if (((List)footerFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)).size() > 0) {
                        childInfo = new VpeChildrenInfo(td);
                        for (Node child : (List)footerFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)) {
                            childInfo.addSourceChild(child);
                        }
                        creationData.addChildrenInfo(childInfo);
                    }
                    if (!children.isEmpty()) {
                        childInfo = new VpeChildrenInfo(td);
                        for (Node child : children) {
                            childInfo.addSourceChild(child);
                        }
                        creationData.addChildrenInfo(childInfo);
                    }
                    ++elementIndex;
                    ++columnIndex;
                }
                ++rowIndex;
            }
        }
        return creationData;
    }

    private void initStyleClasses(Element sourceElement) {
        String columnClassesString = sourceElement.getAttribute("columnClasses");
        String rowClassesString = sourceElement.getAttribute("rowClasses");
        this.columnClasses = this.parceClasses(columnClassesString);
        this.rowClasses = this.parceClasses(rowClassesString);
    }

    private String[] parceClasses(String classes) {
        if (classes == null) {
            return new String[]{""};
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(classes, ",", false);
        while (st.hasMoreElements()) {
            list.add((String)st.nextElement());
        }
        if (list.isEmpty()) {
            return new String[]{""};
        }
        return list.toArray(new String[list.size()]);
    }

    private String getColumnClass(int column) {
        return this.columnClasses[column % this.columnClasses.length];
    }

    private String getRowClass(int row) {
        return this.rowClasses[row % this.rowClasses.length];
    }

    protected int getColumnsCount(Element sourceElement) {
        int count = this.defaultColumns;
        try {
            int span = Integer.parseInt(sourceElement.getAttribute("columns"));
            count = span > 0 ? span : this.defaultColumns;
        }
        catch (NumberFormatException numberFormatException) {}
        return count;
    }

    protected int getElementsCount(Element sourceElement, int columnCount) {
        int elements = columnCount * this.defaultRows;
        try {
            int span = Integer.parseInt(sourceElement.getAttribute("elements"));
            elements = span > 0 ? span : columnCount * this.defaultRows;
        }
        catch (NumberFormatException numberFormatException) {
            elements = columnCount * this.defaultRows;
        }
        return elements;
    }

    @Override
    public void removeAttribute(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMNode visualNode, Object data, String name) {
        nsIDOMElement visualElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class);
        visualElement.removeAttribute(name);
    }

    @Override
    public void setAttribute(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMNode visualNode, Object data, String name, String value) {
        nsIDOMElement visualElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class);
        visualElement.setAttribute(name, value);
    }
}

