/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.solder.core.generic;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.cdi.core.extension.AbstractDefinitionContextExtension;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.cdi.seam.solder.core.Version;
import org.jboss.tools.cdi.seam.solder.core.generic.GenericConfiguration;

public class GenericBeanDefinitionContext
extends AbstractDefinitionContextExtension {
    Map<String, GenericConfiguration> genericConfiguartions = new HashMap<String, GenericConfiguration>();
    Version version;

    public GenericBeanDefinitionContext(Version version) {
        this.version = version;
    }

    public Version getVersion() {
        return this.version;
    }

    protected AbstractDefinitionContextExtension copy(boolean clean) {
        GenericBeanDefinitionContext copy = new GenericBeanDefinitionContext(this.version);
        copy.root = this.root;
        if (!clean) {
            copy.genericConfiguartions.putAll(this.genericConfiguartions);
        }
        return copy;
    }

    protected void doApplyWorkingCopy() {
        this.genericConfiguartions = ((GenericBeanDefinitionContext)this.workingCopy).genericConfiguartions;
        for (GenericConfiguration c : this.genericConfiguartions.values()) {
            if (c.getGenericTypeDefinition() != null) continue;
            for (TypeDefinition d : c.getGenericBeans()) {
                d.unveto();
            }
        }
    }

    public void clean() {
        this.genericConfiguartions.clear();
    }

    public void clean(IPath path) {
        for (GenericConfiguration c : this.genericConfiguartions.values()) {
            c.clear(path);
        }
    }

    public void clean(String typeName) {
        this.genericConfiguartions.remove(typeName);
        for (GenericConfiguration c : this.genericConfiguartions.values()) {
            c.clear(typeName);
        }
    }

    public void computeAnnotationKind(AnnotationDefinition annotation) {
        if (annotation.isAnnotationPresent(this.version.getGenericTypeAnnotationTypeName())) {
            annotation.setExtendedKind((Object)"genericAnnotation");
            String qn = annotation.getType().getFullyQualifiedName();
            GenericConfiguration c = this.getGenericConfiguration(qn);
            c.setGenericTypeDefinition(annotation, this);
            if (!annotation.getType().isBinary()) {
                IPath newPath = annotation.getType().getResource().getFullPath();
                Set<IPath> ps = c.getInvolvedTypes();
                for (IPath p : ps) {
                    this.getRootContext().addDependency(p, newPath);
                    this.getRootContext().addDependency(newPath, p);
                }
                ps.add(newPath);
            }
        }
    }

    public boolean isGenericTypeAnnotation(IType type) {
        return this.genericConfiguartions.containsKey(type.getFullyQualifiedName());
    }

    public Map<String, GenericConfiguration> getGenericConfigurations() {
        return this.genericConfiguartions;
    }

    public GenericConfiguration getGenericConfiguration(String typeName) {
        GenericConfiguration result = this.genericConfiguartions.get(typeName);
        if (result == null) {
            result = new GenericConfiguration(typeName);
            this.genericConfiguartions.put(typeName, result);
        }
        return result;
    }

    public boolean isGenericBean(String typeName) {
        for (GenericConfiguration c : this.genericConfiguartions.values()) {
            Set<TypeDefinition> bs = c.getGenericBeans();
            for (TypeDefinition d : bs) {
                if (!typeName.equals(d.getType().getFullyQualifiedName())) continue;
                return true;
            }
        }
        return false;
    }
}

