/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.creation.core.utils;

import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.jboss.tools.common.util.EclipseJavaUtil;
import org.jboss.tools.ws.core.utils.StatusUtils;
import org.jboss.tools.ws.creation.core.messages.JBossWSCreationCoreMessages;
import org.jboss.tools.ws.creation.core.utils.JBossWSCreationUtils;

public class RestEasyLibUtils {
    private static final String REST_EASY = "RestEasy";

    public static IStatus doesRuntimeSupportRestEasy(IProject project) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                String[] classesToValidate = new String[]{"javax.ws.rs.GET", "javax.ws.rs.Path", "javax.ws.rs.core.Application"};
                int i = 0;
                while (i < classesToValidate.length) {
                    String classToTest = classesToValidate[i];
                    IType rtnType1 = EclipseJavaUtil.findType((IJavaProject)javaProject, (String)classToTest);
                    if (rtnType1 == null) {
                        return StatusUtils.warningStatus((String)JBossWSCreationCoreMessages.AddRestEasyJarsCommand_RestEasy_JARS_Not_Found);
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            return StatusUtils.warningStatus((String)JBossWSCreationCoreMessages.RestEasyLibUtils_Error_UnableToFindRuntimeForProject);
        }
        return Status.OK_STATUS;
    }

    public static IStatus doesRuntimeHaveRootLevelRestEasyDir(IProject project) {
        try {
            File parent;
            String path;
            File runtime;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null && (runtime = new File(path = JBossWSCreationUtils.getJBossWSRuntimeLocation(project.getProject()))).exists() && (parent = runtime.getParentFile()).exists() && parent.isDirectory()) {
                File[] restEasyDir = parent.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.equalsIgnoreCase(RestEasyLibUtils.REST_EASY);
                    }
                });
                if (restEasyDir != null && restEasyDir.length > 0) {
                    return Status.OK_STATUS;
                }
                return StatusUtils.warningStatus((String)"Root-level RESTeasy directory not found in runtime location");
            }
        }
        catch (Exception exception) {
            return StatusUtils.warningStatus((String)"Root-level RESTeasy directory not found in runtime location");
        }
        return Status.OK_STATUS;
    }
}

