/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.creation.core.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.jboss.tools.ws.core.utils.StatusUtils;
import org.jboss.tools.ws.creation.core.JBossWSCreationCorePlugin;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.creation.core.messages.JBossWSCreationCoreMessages;
import org.jboss.tools.ws.creation.core.utils.JBossWSCreationUtils;

public class ImplementationClassCreationCommand
extends AbstractDataModelOperation {
    private static final String PREFIX_JAXWS_ANNOTATION_CLASS = "javax.jws";
    private static final String DEFAULT_CU_SUFFIX = ".java";
    private static final String ANNOTATION_WEB_SERVICE_FULLNAME = "javax.jws.WebService";
    private static final String ANNOTATION_TYPE_NAME_WEBSERVICE = "WebService";
    private static final String ANNOTATION_PROPERTY_SERVICE_NAME = "serviceName";
    private static final String ANNOTATION_PROPERTY_ENDPOINT_INTERFACE = "endpointInterface";
    private static final String ANNOTATION_PROPERTY_TNS = "targetNamespace";
    private static final String IMPL_PACKAGE = ".impl";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private ServiceModel model;
    private IJavaProject project;
    private String packageName;
    private String serviceName;
    private String targetNamespace;

    public ImplementationClassCreationCommand(ServiceModel model) {
        this.model = model;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        if (!this.model.isGenImplementation()) {
            return status;
        }
        this.project = this.model.getJavaProject();
        this.packageName = this.model.getCustomPackage();
        List<ICompilationUnit> portTypeUnits = JBossWSCreationUtils.findJavaUnitsByAnnotation(this.project, JBossWSCreationCoreMessages.Webservice_Annotation, this.packageName);
        if (portTypeUnits.size() == 0) {
            return status;
        }
        this.packageName = String.valueOf(portTypeUnits.get(0).getParent().getElementName()) + IMPL_PACKAGE;
        IPackageFragment pack = null;
        try {
            pack = this.createImplPackage(this.packageName);
        }
        catch (JavaModelException e1) {
            status = StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_Message_Failed_to_Generate_Implementation, (Throwable)e1);
            return status;
        }
        Service service = this.model.getService();
        this.serviceName = service.getQName().getLocalPart();
        this.targetNamespace = this.model.getWsdlDefinition().getTargetNamespace();
        Iterator iter = service.getPorts().values().iterator();
        LinkedList<String> ptList = new LinkedList<String>();
        while (iter.hasNext()) {
            Port port = (Port)iter.next();
            ptList.add(port.getBinding().getPortType().getQName().getLocalPart().toLowerCase());
        }
        boolean isOverWrite = false;
        try {
            for (ICompilationUnit portType : portTypeUnits) {
                if (!portType.findPrimaryType().isInterface()) continue;
                String clsName = this.getClassName(portType.getElementName());
                String implClsName = this.getImplClassName(clsName);
                if (!ptList.contains(clsName.toLowerCase())) continue;
                if (!isOverWrite && this.findImplClass(implClsName)) {
                    if (!this.isOverwriteClass()) break;
                    isOverWrite = true;
                }
                this.generateImplClass(portType, pack, clsName, implClsName);
                this.model.addServiceClasses(new StringBuffer(this.packageName).append(".").append(implClsName).toString());
            }
        }
        catch (CoreException e) {
            status = StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_Message_Failed_to_Generate_Implementation, (Throwable)e);
            JBossWSCreationCorePlugin.getDefault().logError(e);
        }
        catch (BadLocationException e) {
            status = StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_Message_Failed_to_Generate_Implementation, (Throwable)e);
            JBossWSCreationCorePlugin.getDefault().logError(e);
        }
        return status;
    }

    protected void generateImplClass(ICompilationUnit portType, IPackageFragment pack, String ptCls, String clsName) throws CoreException, BadLocationException {
        ASTParser astp = ASTParser.newParser((int)3);
        astp.setKind(8);
        astp.setSource(portType);
        CompilationUnit cu = (CompilationUnit)astp.createAST(null);
        String implFileName = this.getJavaFileName(clsName);
        ICompilationUnit icu = pack.createCompilationUnit(implFileName, "", true, null);
        icu.becomeWorkingCopy(null);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(icu);
        parser.setResolveBindings(false);
        parser.setFocalPosition(0);
        CompilationUnit implCu = (CompilationUnit)parser.createAST(null);
        AST ast = implCu.getAST();
        String source = icu.getBuffer().getContents();
        Document document = new Document(source);
        implCu.recordModifications();
        PackageDeclaration implPackage = ast.newPackageDeclaration();
        implPackage.setName(ast.newName(pack.getElementName()));
        implCu.setPackage(implPackage);
        this.addImportsToImplementationClass(implCu, cu, ptCls);
        TypeDeclaration type = ast.newTypeDeclaration();
        type.setInterface(false);
        String endpoint = this.getPortTypeFullName(portType.getParent().getElementName(), ptCls);
        NormalAnnotation ann = null;
        ann = this.serviceName != null ? this.createAnnotation(ast, this.serviceName, endpoint, this.targetNamespace) : this.createAnnotation(ast, clsName, endpoint, this.targetNamespace);
        type.modifiers().add(ann);
        type.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        type.setName(ast.newSimpleName(clsName));
        type.superInterfaceTypes().add(ast.newSimpleType(ast.newName(ptCls)));
        TypeDeclaration inTD = (TypeDeclaration)cu.types().get(0);
        MethodDeclaration[] methods = inTD.getMethods();
        int i = 0;
        while (i < methods.length) {
            MethodDeclaration newMethod = this.createMethodForImplClass(ast, methods[i]);
            type.bodyDeclarations().add(newMethod);
            ++i;
        }
        implCu.types().add(type);
        TextEdit edits = implCu.rewrite((IDocument)document, icu.getJavaProject().getOptions(true));
        edits.apply((IDocument)document);
        String newSource = document.get();
        icu.getBuffer().setContents(newSource);
        icu.reconcile(0, false, null, null);
        icu.commitWorkingCopy(true, null);
        icu.discardWorkingCopy();
    }

    private String getImplPackageName() {
        return this.packageName;
    }

    private String getJavaFileName(String className) {
        return String.valueOf(className) + DEFAULT_CU_SUFFIX;
    }

    private String getImplClassName(String className) {
        return String.valueOf(className) + "Impl";
    }

    private String getClassName(String className) {
        String clsName = className.substring(0, className.length() - 5);
        return clsName;
    }

    private String getPortTypeFullName(String packageName, String className) {
        return String.valueOf(packageName) + "." + className;
    }

    private void addImportsToImplementationClass(CompilationUnit implCU, CompilationUnit serviceCU, String serviceName) {
        List<ImportDeclaration> imports = this.getImportsWithoutJaxwsAnnotation(serviceCU);
        AST implAST = implCU.getAST();
        for (ImportDeclaration id : imports) {
            ImportDeclaration newId = implAST.newImportDeclaration();
            newId.setName(implAST.newName(id.getName().getFullyQualifiedName()));
            implCU.imports().add(newId);
        }
        ImportDeclaration importDec = implAST.newImportDeclaration();
        importDec.setName(implAST.newName(serviceCU.getPackage().getName().toString()));
        importDec.setOnDemand(true);
        implCU.imports().add(importDec);
        importDec = implAST.newImportDeclaration();
        importDec.setName(implAST.newName(ANNOTATION_WEB_SERVICE_FULLNAME));
        implCU.imports().add(importDec);
    }

    protected NormalAnnotation createAnnotation(AST ast, String serviceName, String endpoint, String targetNamespace) {
        NormalAnnotation ann = ast.newNormalAnnotation();
        ann.setTypeName((Name)ast.newSimpleName(ANNOTATION_TYPE_NAME_WEBSERVICE));
        MemberValuePair member = this.createMemberValuePair(ast, ANNOTATION_PROPERTY_SERVICE_NAME, serviceName);
        ann.values().add(member);
        member = this.createMemberValuePair(ast, ANNOTATION_PROPERTY_ENDPOINT_INTERFACE, endpoint);
        ann.values().add(member);
        if (targetNamespace != null) {
            member = this.createMemberValuePair(ast, ANNOTATION_PROPERTY_TNS, targetNamespace);
            ann.values().add(member);
        }
        return ann;
    }

    private MemberValuePair createMemberValuePair(AST ast, String propertyName, String Value) {
        MemberValuePair member = ast.newMemberValuePair();
        member.setName(ast.newSimpleName(propertyName));
        StringLiteral value = ast.newStringLiteral();
        value.setLiteralValue(Value);
        member.setValue((Expression)value);
        return member;
    }

    protected MethodDeclaration createMethodForImplClass(AST ast, MethodDeclaration inMethod) {
        MethodDeclaration md = ast.newMethodDeclaration();
        md.setConstructor(false);
        List modifiers = md.modifiers();
        modifiers.add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        md.setName(ast.newSimpleName(inMethod.getName().getFullyQualifiedName()));
        Type sType = this.copyTypeFromOtherASTNode(ast, inMethod.getReturnType2());
        md.setReturnType2(sType);
        List thrownExceptions = inMethod.thrownExceptions();
        for (Object obj : thrownExceptions) {
            if (!(obj instanceof SimpleName)) continue;
            SimpleName sname = (SimpleName)obj;
            Name newName = ast.newName(sname.getFullyQualifiedName());
            md.thrownExceptions().add(newName);
        }
        List parameters = inMethod.parameters();
        for (Object obj : parameters) {
            SingleVariableDeclaration implSvd = ast.newSingleVariableDeclaration();
            SingleVariableDeclaration svd = (SingleVariableDeclaration)obj;
            implSvd.setName(ast.newSimpleName(svd.getName().getFullyQualifiedName()));
            implSvd.setType(this.copyTypeFromOtherASTNode(ast, svd.getType()));
            md.parameters().add(implSvd);
        }
        Block block = ast.newBlock();
        Type returnType = inMethod.getReturnType2();
        ReturnStatement rs = ast.newReturnStatement();
        if (returnType.isPrimitiveType()) {
            if (((PrimitiveType)returnType).getPrimitiveTypeCode().equals(PrimitiveType.BOOLEAN)) {
                BooleanLiteral bl = ast.newBooleanLiteral(false);
                rs.setExpression((Expression)bl);
            } else if (!((PrimitiveType)returnType).getPrimitiveTypeCode().equals(PrimitiveType.VOID)) {
                NumberLiteral nl = ast.newNumberLiteral();
                nl.setToken("0");
                rs.setExpression((Expression)nl);
            }
        } else if (returnType.isSimpleType()) {
            String typeName = ((SimpleType)returnType).getName().getFullyQualifiedName();
            if ("String".equals(typeName)) {
                StringLiteral sl = ast.newStringLiteral();
                sl.setLiteralValue("");
                rs.setExpression((Expression)sl);
            } else {
                rs.setExpression((Expression)ast.newNullLiteral());
            }
        } else {
            rs.setExpression((Expression)ast.newNullLiteral());
        }
        block.statements().add(rs);
        md.setBody(block);
        return md;
    }

    private Type copyTypeFromOtherASTNode(AST ast, Type type) {
        if (type instanceof PrimitiveType) {
            return ast.newPrimitiveType(((PrimitiveType)type).getPrimitiveTypeCode());
        }
        if (type instanceof SimpleType) {
            SimpleType simpleType = (SimpleType)type;
            return ast.newSimpleType(ast.newName(simpleType.getName().getFullyQualifiedName()));
        }
        if (type instanceof ArrayType) {
            ArrayType atype = (ArrayType)type;
            return ast.newArrayType(this.copyTypeFromOtherASTNode(ast, atype.getComponentType()));
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            ParameterizedType newParaType = ast.newParameterizedType(this.copyTypeFromOtherASTNode(ast, ptype.getType()));
            for (Object arg : ptype.typeArguments()) {
                if (!(arg instanceof Type)) continue;
                Type newArg = this.copyTypeFromOtherASTNode(ast, (Type)arg);
                newParaType.typeArguments().add(newArg);
            }
            return newParaType;
        }
        if (type instanceof WildcardType) {
            WildcardType sourcetype = (WildcardType)type;
            WildcardType wtype = ast.newWildcardType();
            wtype.setBound(sourcetype.getBound());
            return wtype;
        }
        return null;
    }

    private IPackageFragment createImplPackage(String implPackage) throws JavaModelException {
        IPackageFragmentRoot root = JBossWSCreationUtils.getPackageFragmentRoot(this.project, this.model.getJavaSourceFolder());
        return root.createPackageFragment(implPackage, false, null);
    }

    private boolean isOverwriteClass() throws JavaModelException {
        boolean b = MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)JBossWSCreationCoreMessages.Confirm_Override_ImplClass, (String)JBossWSCreationCoreMessages.Error_JBossWS_GenerateWizard_WSImpl_Overwrite);
        return b;
    }

    private boolean findImplClass(String claName) throws JavaModelException {
        String implPackageName;
        boolean b = false;
        IPackageFragmentRoot root = JBossWSCreationUtils.getPackageFragmentRoot(this.project, this.model.getJavaSourceFolder());
        IPackageFragment pack = root.getPackageFragment(implPackageName = this.getImplPackageName());
        if (pack.getCompilationUnit(String.valueOf(claName) + DEFAULT_CU_SUFFIX).exists()) {
            b = true;
        }
        return b;
    }

    protected List<ImportDeclaration> getImportsWithoutJaxwsAnnotation(CompilationUnit cu) {
        ArrayList<ImportDeclaration> importList = new ArrayList<ImportDeclaration>();
        List imports = cu.imports();
        for (Object obj : imports) {
            ImportDeclaration id = (ImportDeclaration)obj;
            String imClsName = id.getName().getFullyQualifiedName();
            if (imClsName.startsWith(PREFIX_JAXWS_ANNOTATION_CLASS)) continue;
            importList.add(id);
        }
        return importList;
    }
}

