/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate4_3.console;

import java.util.Collection;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.console.ext.HibernateExtension;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.proxy.HibernateProxyHelper;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.jboss.tools.hibernate4_3.console.CollectionPropertySource;

public class EntityPropertySource
implements IPropertySource2 {
    private Object reflectedObject;
    private IPropertyDescriptor[] propertyDescriptors;
    private final HibernateExtension extension;
    private final Session currentSession;
    private ClassMetadata classMetadata;

    public EntityPropertySource(Object object, Session currentSession, HibernateExtension extension) {
        this.currentSession = currentSession;
        this.extension = extension;
        this.reflectedObject = object;
        this.classMetadata = currentSession.isOpen() ? currentSession.getSessionFactory().getClassMetadata(currentSession.getEntityName(this.reflectedObject)) : currentSession.getSessionFactory().getClassMetadata(HibernateProxyHelper.getClassWithoutInitializingProxy((Object)this.reflectedObject));
    }

    public Object getEditableValue() {
        return "";
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null && this.extension != null) {
            if (!this.extension.hasExecutionContext()) {
                this.extension.build();
            }
            this.extension.execute(new ExecutionContext.Command(){

                public Object execute() {
                    EntityPropertySource.this.propertyDescriptors = EntityPropertySource.initializePropertyDescriptors(EntityPropertySource.this.classMetadata);
                    return null;
                }
            });
        }
        return this.propertyDescriptors;
    }

    protected static IPropertyDescriptor[] initializePropertyDescriptors(ClassMetadata classMetadata) {
        String[] propertyNames = classMetadata.getPropertyNames();
        int length = propertyNames.length;
        PropertyDescriptor identifier = null;
        if (classMetadata.hasIdentifierProperty()) {
            identifier = new PropertyDescriptor((Object)classMetadata.getIdentifierPropertyName(), classMetadata.getIdentifierPropertyName());
            identifier.setCategory(HibernateConsoleMessages.EntityPropertySource_identifier);
            ++length;
        }
        PropertyDescriptor[] properties = new PropertyDescriptor[length];
        int idx = 0;
        if (identifier != null) {
            properties[idx++] = identifier;
        }
        int i = 0;
        while (i < propertyNames.length) {
            PropertyDescriptor prop = new PropertyDescriptor((Object)propertyNames[i], propertyNames[i]);
            prop.setCategory(HibernateConsoleMessages.EntityPropertySource_properties);
            properties[i + idx] = prop;
            ++i;
        }
        return properties;
    }

    public Object getPropertyValue(Object id) {
        CollectionMetadata collectionMetadata;
        Object propertyValue;
        block5: {
            if (id.equals(this.classMetadata.getIdentifierPropertyName())) {
                propertyValue = this.classMetadata.getIdentifier(this.reflectedObject, (SessionImplementor)this.currentSession);
            } else {
                try {
                    propertyValue = this.classMetadata.getPropertyValue(this.reflectedObject, (String)id);
                }
                catch (HibernateException hibernateException) {
                    Integer idx;
                    AbstractEntityPersister aep;
                    EntityMetamodel emm;
                    propertyValue = HibernateConsoleMessages.EntityPropertySource_unable_to_resolve_property;
                    if (!(this.classMetadata instanceof AbstractEntityPersister) || (emm = (aep = (AbstractEntityPersister)this.classMetadata).getEntityMetamodel()) == null || (idx = emm.getPropertyIndexOrNull((String)id)) == null) break block5;
                    propertyValue = emm.getTuplizer().getPropertyValue(this.reflectedObject, idx.intValue());
                }
            }
        }
        if (propertyValue instanceof Collection && (collectionMetadata = this.currentSession.getSessionFactory().getCollectionMetadata(String.valueOf(this.classMetadata.getEntityName()) + "." + id)) != null) {
            propertyValue = new CollectionPropertySource((Collection)propertyValue);
        }
        return propertyValue;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }
}

