/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate4_3;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Settings;
import org.hibernate.console.ConsoleConfigClassLoader;
import org.hibernate.console.ConsoleMessages;
import org.hibernate.console.QueryInputModel;
import org.hibernate.console.QueryPage;
import org.hibernate.console.execution.DefaultExecutionContext;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.console.ext.HibernateException;
import org.hibernate.console.ext.HibernateExtension;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.console.preferences.PreferencesClassPathUtils;
import org.hibernate.service.ServiceRegistry;
import org.jboss.tools.hibernate4_3.ConfigurationFactory;
import org.jboss.tools.hibernate4_3.FakeDelegatingDriver;
import org.jboss.tools.hibernate4_3.HQLQueryPage;
import org.jboss.tools.hibernate4_3.JavaPage;
import org.jboss.tools.hibernate4_3.QueryHelper;

public class HibernateExtension4_3
implements HibernateExtension {
    private ConsoleConfigClassLoader classLoader = null;
    private ExecutionContext executionContext;
    private ConsoleConfigurationPreferences prefs;
    private Configuration configuration;
    private SessionFactory sessionFactory;
    private ServiceRegistry serviceRegistry;
    private Map<String, FakeDelegatingDriver> fakeDrivers = new HashMap<String, FakeDelegatingDriver>();

    public String getHibernateVersion() {
        return "4.3";
    }

    public QueryPage executeHQLQuery(final String hql, final QueryInputModel queryParameters) {
        return (QueryPage)this.execute(new ExecutionContext.Command(){

            public Object execute() {
                Session session = HibernateExtension4_3.this.sessionFactory.openSession();
                HQLQueryPage qp = new HQLQueryPage(HibernateExtension4_3.this, hql, queryParameters);
                qp.setSession(session);
                return qp;
            }
        });
    }

    public QueryPage executeCriteriaQuery(final String criteriaCode, final QueryInputModel model) {
        return (QueryPage)this.execute(new ExecutionContext.Command(){

            public Object execute() {
                Session session = HibernateExtension4_3.this.sessionFactory.openSession();
                JavaPage qp = new JavaPage(HibernateExtension4_3.this, criteriaCode, model);
                qp.setSession(session);
                return qp;
            }
        });
    }

    public void setConsoleConfigurationPreferences(ConsoleConfigurationPreferences prefs) {
        this.prefs = prefs;
    }

    public void build() {
        this.configuration = this.buildWith(null, true);
    }

    public void buildSessionFactory() {
        this.execute(new ExecutionContext.Command(){

            public Object execute() {
                if (HibernateExtension4_3.this.sessionFactory != null) {
                    throw new HibernateException("Factory was not closed before attempt to build a new Factory");
                }
                HibernateExtension4_3.this.serviceRegistry = (ServiceRegistry)new StandardServiceRegistryBuilder().applySettings((Map)HibernateExtension4_3.this.configuration.getProperties()).build();
                HibernateExtension4_3.this.sessionFactory = HibernateExtension4_3.this.configuration.buildSessionFactory(HibernateExtension4_3.this.serviceRegistry);
                return null;
            }
        });
    }

    public boolean closeSessionFactory() {
        boolean res = false;
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
            this.sessionFactory = null;
            ((StandardServiceRegistryImpl)this.serviceRegistry).destroy();
            this.serviceRegistry = null;
            res = true;
        }
        return res;
    }

    public Configuration buildWith(final Configuration cfg, final boolean includeMappings) {
        this.reinitClassLoader();
        this.executionContext = new DefaultExecutionContext(this.prefs.getName(), (ClassLoader)this.classLoader);
        Configuration result = (Configuration)this.execute(new ExecutionContext.Command(){

            public Object execute() {
                ConfigurationFactory cf = new ConfigurationFactory(HibernateExtension4_3.this.prefs, HibernateExtension4_3.this.fakeDrivers);
                return cf.createConfiguration(cfg, includeMappings);
            }
        });
        return result;
    }

    protected void reinitClassLoader() {
        URL[] customClassPathURLs = PreferencesClassPathUtils.getCustomClassPathURLs((ConsoleConfigurationPreferences)this.prefs);
        this.cleanUpClassLoader();
        this.classLoader = this.createClassLoader(customClassPathURLs);
    }

    protected ConsoleConfigClassLoader createClassLoader(final URL[] customClassPathURLs) {
        ConsoleConfigClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ConsoleConfigClassLoader>(){

            @Override
            public ConsoleConfigClassLoader run() {
                return new ConsoleConfigClassLoader(customClassPathURLs, Thread.currentThread().getContextClassLoader()){

                    protected Class<?> findClass(String name) throws ClassNotFoundException {
                        try {
                            return super.findClass(name);
                        }
                        catch (ClassNotFoundException cnfe) {
                            throw cnfe;
                        }
                        catch (IllegalStateException e) {
                            e.printStackTrace();
                            throw e;
                        }
                    }

                    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                        return super.loadClass(name, resolve);
                    }

                    public Class<?> loadClass(String name) throws ClassNotFoundException {
                        return super.loadClass(name);
                    }

                    public URL getResource(String name) {
                        return super.getResource(name);
                    }
                };
            }
        });
        return classLoader;
    }

    public String getName() {
        return this.prefs.getName();
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public Object execute(ExecutionContext.Command c) {
        if (this.executionContext != null) {
            return this.executionContext.execute(c);
        }
        String msg = NLS.bind((String)ConsoleMessages.ConsoleConfiguration_null_execution_context, (Object)this.getName());
        throw new HibernateException(msg);
    }

    public boolean reset() {
        boolean resetted = false;
        if (this.configuration != null) {
            this.configuration = null;
            resetted = true;
        }
        resetted = resetted | this.closeSessionFactory() | this.cleanUpClassLoader();
        this.executionContext = null;
        return resetted;
    }

    protected boolean cleanUpClassLoader() {
        boolean resetted = false;
        if (this.executionContext != null) {
            this.executionContext.execute(new ExecutionContext.Command(){

                public Object execute() {
                    Iterator it = HibernateExtension4_3.this.fakeDrivers.values().iterator();
                    while (it.hasNext()) {
                        try {
                            DriverManager.deregisterDriver((Driver)it.next());
                        }
                        catch (SQLException sQLException) {}
                    }
                    return null;
                }
            });
        }
        if (this.fakeDrivers.size() > 0) {
            this.fakeDrivers.clear();
            resetted = true;
        }
        Object classLoaderTmp = this.classLoader;
        while (classLoaderTmp != null) {
            if (classLoaderTmp instanceof ConsoleConfigClassLoader) {
                classLoaderTmp.close();
                resetted = true;
            }
            classLoaderTmp = classLoaderTmp.getParent();
        }
        if (this.classLoader != null) {
            this.classLoader = null;
            resetted = true;
        }
        return resetted;
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Settings getSettings(final Configuration cfg, final ServiceRegistry serviceRegisrty) {
        return (Settings)this.execute(new ExecutionContext.Command(){

            public Object execute() {
                return cfg.buildSettings(serviceRegisrty);
            }
        });
    }

    public boolean isSessionFactoryCreated() {
        return this.sessionFactory != null;
    }

    public String generateSQL(String query) {
        return QueryHelper.generateSQL(this.executionContext, this.sessionFactory, query);
    }

    public void buildMappings() {
        this.execute(new ExecutionContext.Command(){

            public Object execute() {
                HibernateExtension4_3.this.getConfiguration().buildMappings();
                return null;
            }
        });
    }

    public boolean hasExecutionContext() {
        return this.executionContext != null;
    }

    public String getConsoleConfigurationName() {
        return this.prefs.getName();
    }
}

