/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate4_3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.console.AbstractQueryPage;
import org.hibernate.console.ConsoleQueryParameter;
import org.hibernate.console.QueryInputModel;
import org.hibernate.console.ext.HibernateExtension;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.Type;

public class HQLQueryPage
extends AbstractQueryPage {
    private Query query;
    private String queryString;
    private BasicTypeRegistry defaultBasicTypeRegistry = new BasicTypeRegistry();

    public List<Object> getList() {
        if (this.query == null) {
            return Collections.emptyList();
        }
        if (this.list == null) {
            try {
                this.list = new ArrayList();
                this.setupParameters(this.query, this.model);
                long startTime = System.currentTimeMillis();
                Iterator iter = this.query.list().iterator();
                this.queryTime = System.currentTimeMillis() - startTime;
                while (iter.hasNext()) {
                    Object element = iter.next();
                    this.list.add(element);
                }
                this.pcs.firePropertyChange("list", null, this.list);
            }
            catch (HibernateException e) {
                this.list = Collections.emptyList();
                this.addException(e);
            }
            catch (IllegalArgumentException e) {
                this.list = Collections.emptyList();
                this.addException(e);
            }
        }
        return this.list;
    }

    private void setupParameters(Query query2, QueryInputModel model) {
        if (model.getMaxResults() != null) {
            query2.setMaxResults(model.getMaxResults().intValue());
        }
        ConsoleQueryParameter[] qp = model.getQueryParameters();
        int i = 0;
        while (i < qp.length) {
            ConsoleQueryParameter parameter = qp[i];
            try {
                int pos = Integer.parseInt(parameter.getName());
                query2.setParameter(pos, this.calcValue(parameter), (Type)this.defaultBasicTypeRegistry.getRegisteredType(parameter.getTypeName()));
            }
            catch (NumberFormatException numberFormatException) {
                Object value = parameter.getValue();
                if (value != null && value.getClass().isArray()) {
                    Object[] values = (Object[])value;
                    query2.setParameterList(parameter.getName(), Arrays.asList(values), (Type)this.defaultBasicTypeRegistry.getRegisteredType(parameter.getTypeName()));
                }
                query2.setParameter(parameter.getName(), this.calcValue(parameter), (Type)this.defaultBasicTypeRegistry.getRegisteredType(parameter.getTypeName()));
            }
            ++i;
        }
    }

    private Object calcValue(ConsoleQueryParameter parameter) {
        return parameter.getValueForQuery();
    }

    public HQLQueryPage(HibernateExtension extension, String string, QueryInputModel model) {
        super(extension, model);
        this.queryString = string;
        this.setTabName(this.getQueryString().replace('\n', ' ').replace('\r', ' ').replace('\t', ' '));
    }

    public void setSession(Object s) {
        super.setSession(s);
        try {
            this.query = ((Session)this.getSession()).createQuery(this.getQueryString());
        }
        catch (HibernateException e) {
            this.addException(e);
        }
        catch (Exception e) {
            this.addException(e);
        }
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
        this.list = null;
    }

    public List<String> getPathNames() {
        List<String> l;
        block12: {
            l = Collections.emptyList();
            try {
                if (this.query == null) {
                    return l;
                }
                String[] returnAliases = null;
                try {
                    returnAliases = this.query.getReturnAliases();
                }
                catch (NullPointerException nullPointerException) {}
                if (returnAliases == null) {
                    Type[] t;
                    try {
                        t = this.query.getReturnTypes();
                    }
                    catch (NullPointerException nullPointerException) {
                        t = new Type[1];
                    }
                    l = new ArrayList<String>(t.length);
                    int i = 0;
                    while (i < t.length) {
                        Type type = t[i];
                        if (type == null) {
                            l.add("<multiple types>");
                        } else {
                            l.add(type.getName());
                        }
                        ++i;
                    }
                    break block12;
                }
                String[] t = returnAliases;
                l = new ArrayList<String>(t.length);
                int i = 0;
                while (i < t.length) {
                    l.add(t[i]);
                    ++i;
                }
            }
            catch (HibernateException he) {
                this.addException(he);
            }
        }
        return l;
    }

    public void release() {
        if (((Session)this.getSession()).isOpen()) {
            try {
                ((Session)this.getSession()).close();
            }
            catch (HibernateException e) {
                this.exceptions.add(e);
            }
        }
    }
}

