/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate4_3;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.DOMWriter;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.osgi.util.NLS;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.util.StandardClassLoaderDelegateImpl;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.console.ConnectionProfileUtil;
import org.hibernate.console.ConsoleMessages;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.internal.util.ConfigHelper;
import org.hibernate.internal.util.xml.XMLHelper;
import org.hibernate.service.ServiceRegistry;
import org.jboss.tools.hibernate4_3.FakeDelegatingDriver;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ConfigurationFactory {
    public static final String FAKE_TM_LOOKUP = "org.jboss.tools.hibernate4_3.FakeTransactionManagerLookup";
    private ConsoleConfigurationPreferences prefs;
    private Map<String, FakeDelegatingDriver> fakeDrivers;

    public ConfigurationFactory(ConsoleConfigurationPreferences prefs, Map<String, FakeDelegatingDriver> fakeDrivers) {
        this.prefs = prefs;
        this.fakeDrivers = fakeDrivers;
    }

    public ConsoleConfigurationPreferences getPreferences() {
        return this.prefs;
    }

    public Configuration createConfiguration(Configuration localCfg, boolean includeMappings) {
        String str;
        Properties properties = this.prefs.getProperties();
        if (properties != null && (str = properties.getProperty("hibernate.transaction.factory_class")) != null && StringHelper.isEmpty((String)str)) {
            properties.setProperty("hibernate.transaction.factory_class", FAKE_TM_LOOKUP);
        }
        if (localCfg == null) {
            localCfg = this.buildConfiguration(properties, includeMappings);
        }
        this.registerFakeDriver(localCfg.getProperty("hibernate.connection.driver_class"));
        if (includeMappings) {
            File[] mappingFiles = this.prefs.getMappingFiles();
            int i = 0;
            while (i < mappingFiles.length) {
                File hbm = mappingFiles[i];
                localCfg = localCfg.addFile(hbm);
                ++i;
            }
        }
        localCfg.setProperty("hibernate.temp.use_jdbc_metadata_defaults", "false");
        localCfg.setProperty("hibernate.hbm2ddl.auto", "false");
        if (localCfg.getProperty("hibernate.search.autoregister_listeners") == null) {
            localCfg.setProperty("hibernate.search.autoregister_listeners", "false");
        }
        return localCfg;
    }

    private void autoConfigureDialect(Configuration localCfg, ServiceRegistry serviceRegistry) {
        String dialect;
        if (localCfg.getProperty("hibernate.dialect") == null && (dialect = ConnectionProfileUtil.autoDetectDialect((Properties)localCfg.getProperties())) != null) {
            localCfg.setProperty("hibernate.dialect", dialect);
        }
    }

    private Configuration buildConfiguration(Properties properties, boolean includeMappings) {
        Configuration localCfg = null;
        if (this.prefs.getConfigurationMode().equals(ConsoleConfigurationPreferences.ConfigurationMode.ANNOTATIONS)) {
            try {
                localCfg = this.buildAnnotationConfiguration();
                localCfg = this.configureStandardConfiguration(includeMappings, localCfg, properties);
            }
            catch (HibernateConsoleRuntimeException he) {
                throw he;
            }
            catch (Exception e) {
                throw new HibernateConsoleRuntimeException(ConsoleMessages.ConsoleConfiguration_could_not_load_annotationconfiguration, (Throwable)e);
            }
        } else if (this.prefs.getConfigurationMode().equals(ConsoleConfigurationPreferences.ConfigurationMode.JPA)) {
            try {
                localCfg = this.buildJPAConfiguration(this.getPreferences().getPersistenceUnitName(), properties, this.prefs.getEntityResolverName(), includeMappings);
            }
            catch (HibernateConsoleRuntimeException he) {
                throw he;
            }
            catch (Exception e) {
                throw new HibernateConsoleRuntimeException(ConsoleMessages.ConsoleConfiguration_could_not_load_jpa_configuration, (Throwable)e);
            }
        } else {
            localCfg = new Configuration();
            localCfg = this.configureStandardConfiguration(includeMappings, localCfg, properties);
        }
        return localCfg;
    }

    private Configuration buildAnnotationConfiguration() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class clazz = StandardClassLoaderDelegateImpl.INSTANCE.classForName("org.hibernate.cfg.AnnotationConfiguration");
        Configuration newInstance = (Configuration)clazz.newInstance();
        return newInstance;
    }

    private Configuration buildJPAConfiguration(String persistenceUnit, Properties properties, String entityResolver, boolean includeMappings) {
        if (StringHelper.isEmpty((String)persistenceUnit)) {
            persistenceUnit = null;
        }
        try {
            HashMap<Object, Object> overrides = new HashMap<Object, Object>();
            if (properties != null) {
                overrides.putAll(properties);
            }
            if (StringHelper.isNotEmpty((String)this.prefs.getNamingStrategy())) {
                overrides.put("hibernate.ejb.naming_strategy", this.prefs.getNamingStrategy());
            }
            if (StringHelper.isNotEmpty((String)this.prefs.getDialectName())) {
                overrides.put("hibernate.dialect", this.prefs.getDialectName());
            }
            if (!includeMappings) {
                overrides.put("hibernate.archive.autodetection", "none");
            }
            if (StringHelper.isEmpty((String)((String)overrides.get("javax.persistence.validation.mode")))) {
                overrides.put("javax.persistence.validation.mode", "none");
            }
            Class hibernatePersistanceProviderClass = StandardClassLoaderDelegateImpl.INSTANCE.classForName("org.hibernate.jpa.HibernatePersistenceProvider");
            Object hibernatePersistanceProvider = hibernatePersistanceProviderClass.newInstance();
            Method getEntityManagerFactoryBuilderOrNull = hibernatePersistanceProviderClass.getDeclaredMethod("getEntityManagerFactoryBuilderOrNull", String.class, Map.class);
            getEntityManagerFactoryBuilderOrNull.setAccessible(true);
            Object entityManagerFactoryBuilder = getEntityManagerFactoryBuilderOrNull.invoke(hibernatePersistanceProvider, persistenceUnit, overrides);
            if (entityManagerFactoryBuilder == null) {
                throw new HibernateConsoleRuntimeException("Persistence unit not found: '" + persistenceUnit + "'.");
            }
            Method buildServiceRegistry = entityManagerFactoryBuilder.getClass().getMethod("buildServiceRegistry", new Class[0]);
            Object serviceRegistry = buildServiceRegistry.invoke(entityManagerFactoryBuilder, null);
            Class serviceRegistryClass = StandardClassLoaderDelegateImpl.INSTANCE.classForName("org.hibernate.service.ServiceRegistry");
            Method buildHibernateConfiguration = entityManagerFactoryBuilder.getClass().getMethod("buildHibernateConfiguration", serviceRegistryClass);
            Configuration invoke = (Configuration)buildHibernateConfiguration.invoke(entityManagerFactoryBuilder, serviceRegistry);
            this.changeDatasourceProperties(invoke);
            invoke = this.configureConnectionProfile(invoke);
            return invoke;
        }
        catch (HibernateConsoleRuntimeException he) {
            throw he;
        }
        catch (Exception e) {
            throw new HibernateConsoleRuntimeException(ConsoleMessages.ConsoleConfiguration_could_not_create_jpa_based_configuration, (Throwable)e);
        }
    }

    private Configuration configureStandardConfiguration(boolean includeMappings, Configuration localCfg, Properties properties) {
        if (properties != null) {
            localCfg = localCfg.setProperties(properties);
        }
        EntityResolver entityResolver = XMLHelper.DEFAULT_DTD_RESOLVER;
        if (StringHelper.isNotEmpty((String)this.prefs.getEntityResolverName())) {
            try {
                entityResolver = (EntityResolver)StandardClassLoaderDelegateImpl.INSTANCE.classForName(this.prefs.getEntityResolverName()).newInstance();
            }
            catch (Exception c) {
                throw new HibernateConsoleRuntimeException(String.valueOf(ConsoleMessages.ConsoleConfiguration_could_not_configure_entity_resolver) + this.prefs.getEntityResolverName(), (Throwable)c);
            }
        }
        localCfg.setEntityResolver(entityResolver);
        if (StringHelper.isNotEmpty((String)this.prefs.getNamingStrategy())) {
            try {
                NamingStrategy ns = (NamingStrategy)StandardClassLoaderDelegateImpl.INSTANCE.classForName(this.prefs.getNamingStrategy()).newInstance();
                localCfg.setNamingStrategy(ns);
            }
            catch (Exception c) {
                throw new HibernateConsoleRuntimeException(String.valueOf(ConsoleMessages.ConsoleConfiguration_could_not_configure_naming_strategy) + this.prefs.getNamingStrategy(), (Throwable)c);
            }
        }
        localCfg = this.loadConfigurationXML(localCfg, includeMappings, entityResolver);
        this.changeDatasourceProperties(localCfg);
        localCfg = this.configureConnectionProfile(localCfg);
        if (StringHelper.isNotEmpty((String)this.prefs.getDialectName())) {
            localCfg.setProperty("hibernate.dialect", this.prefs.getDialectName());
        }
        if (StringHelper.isEmpty((String)localCfg.getProperty("javax.persistence.validation.mode"))) {
            localCfg.setProperty("javax.persistence.validation.mode", "none");
        }
        return localCfg;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Configuration loadConfigurationXML(Configuration localCfg, boolean includeMappings, EntityResolver entityResolver) {
        File configXMLFile = this.prefs.getConfigXMLFile();
        if (!includeMappings) {
            Configuration configuration;
            XMLHelper xmlHelper = new XMLHelper();
            InputStream stream = null;
            String resourceName = "<unknown>";
            if (configXMLFile != null) {
                resourceName = configXMLFile.toString();
                try {
                    stream = new FileInputStream(configXMLFile);
                }
                catch (FileNotFoundException e1) {
                    throw new HibernateConsoleRuntimeException(String.valueOf(ConsoleMessages.ConsoleConfiguration_could_not_access) + configXMLFile, (Throwable)e1);
                }
            } else {
                resourceName = "/hibernate.cfg.xml";
                if (!this.checkHibernateResoureExistence(resourceName)) return localCfg;
                stream = ConfigHelper.getResourceAsStream((String)resourceName);
            }
            try {
                final ArrayList errors = new ArrayList();
                ErrorHandler errorHandler = new ErrorHandler(){

                    @Override
                    public void warning(SAXParseException exception) throws SAXException {
                    }

                    @Override
                    public void fatalError(SAXParseException exception) throws SAXException {
                        this.error(exception);
                    }

                    @Override
                    public void error(SAXParseException exception) throws SAXException {
                        errors.add(exception);
                    }
                };
                Document doc = xmlHelper.createSAXReader(errorHandler, entityResolver).read(new InputSource(stream));
                if (errors.size() != 0) {
                    throw new MappingException(ConsoleMessages.ConsoleConfiguration_invalid_configuration, (Throwable)errors.get(0));
                }
                List list = doc.getRootElement().element("session-factory").elements("mapping");
                Iterator iterator = list.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        DOMWriter dw = new DOMWriter();
                        org.w3c.dom.Document document = dw.write(doc);
                        configuration = localCfg.configure(document);
                        break;
                    }
                    Node element = (Node)iterator.next();
                    element.getParent().remove(element);
                }
            }
            catch (DocumentException e) {
                try {
                    throw new HibernateException(String.valueOf(ConsoleMessages.ConsoleConfiguration_could_not_parse_configuration) + resourceName, (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        if (stream == null) throw throwable;
                        stream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                if (stream == null) return configuration;
                stream.close();
                return configuration;
            }
            catch (IOException iOException) {}
            return configuration;
        }
        if (configXMLFile != null) {
            return localCfg.configure(configXMLFile);
        }
        Configuration resultCfg = localCfg;
        if (!this.checkHibernateResoureExistence("/hibernate.cfg.xml")) return resultCfg;
        return localCfg.configure();
    }

    private boolean checkHibernateResoureExistence(String resource) {
        InputStream is;
        block14: {
            is = null;
            try {
                try {
                    is = ConfigHelper.getResourceAsStream((String)resource);
                }
                catch (HibernateException hibernateException) {
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return is != null;
    }

    private void changeDatasourceProperties(Configuration localCfg) {
        Properties invokeProperties = localCfg.getProperties();
        if (invokeProperties.containsKey("hibernate.connection.datasource")) {
            invokeProperties.setProperty("hibernate.transaction.factory_class", FAKE_TM_LOOKUP);
            invokeProperties.remove("hibernate.connection.datasource");
            localCfg.setProperties(invokeProperties);
        }
    }

    private Configuration configureConnectionProfile(Configuration localCfg) {
        String connProfileName = this.prefs.getConnectionProfileName();
        if (connProfileName == null) {
            return localCfg;
        }
        IConnectionProfile profile = ProfileManager.getInstance().getProfileByName(connProfileName);
        if (profile == null) {
            String out = NLS.bind((String)ConsoleMessages.ConsoleConfiguration_connection_profile_not_found, (Object)connProfileName);
            throw new HibernateConsoleRuntimeException(out);
        }
        localCfg.addProperties(ConnectionProfileUtil.getHibernateConnectionProperties((IConnectionProfile)profile));
        return localCfg;
    }

    private void registerFakeDriver(String driverClassName) {
        if (driverClassName != null) {
            try {
                Class driverClass = StandardClassLoaderDelegateImpl.INSTANCE.classForName(driverClassName);
                if (!this.fakeDrivers.containsKey(driverClassName)) {
                    FakeDelegatingDriver fakeDelegatingDriver = new FakeDelegatingDriver((Driver)driverClass.newInstance());
                    DriverManager.registerDriver(fakeDelegatingDriver);
                    this.fakeDrivers.put(driverClassName, fakeDelegatingDriver);
                }
            }
            catch (InstantiationException e) {
                String out = NLS.bind((String)ConsoleMessages.ConsoleConfiguration_problems_while_loading_database_driverclass, (Object)driverClassName);
                throw new HibernateConsoleRuntimeException(out, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                String out = NLS.bind((String)ConsoleMessages.ConsoleConfiguration_problems_while_loading_database_driverclass, (Object)driverClassName);
                throw new HibernateConsoleRuntimeException(out, (Throwable)e);
            }
            catch (SQLException e) {
                String out = NLS.bind((String)ConsoleMessages.ConsoleConfiguration_problems_while_loading_database_driverclass, (Object)driverClassName);
                throw new HibernateConsoleRuntimeException(out, (Throwable)e);
            }
        }
    }
}

