/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.bpmn2.component;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.switchyard.tools.models.switchyard1_0.bpm.ResourceType;
import org.switchyard.tools.ui.bpmn2.Messages;

public class ResourceDetailInputDialog
extends TitleAreaDialog {
    private Combo _inputTypeCombo;
    private Text _worksheetNameText;
    private Button _usingExternalTypesButton;
    private String _inputType = null;
    private String _worksheetName = null;
    private boolean _usingExternalTypes = false;
    private ResourceType _resourceType = null;

    public ResourceDetailInputDialog(Shell parent) {
        super(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.title_advanceResourceDetails);
        this.setMessage(Messages.description_advancedResourceDetails);
        this.getShell().setText(Messages.title_resourceDetails);
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        area.setLayout((Layout)gridLayout);
        area.setLayoutData((Object)new GridData(1808));
        this._inputTypeCombo = this.createLabelAndCombo(area, Messages.label_inputType, true);
        this._worksheetNameText = this.createLabelAndText(area, Messages.label_worksheetName);
        this._usingExternalTypesButton = new Button(area, 32);
        this._usingExternalTypesButton.setText(Messages.label_usesExternalTypes);
        this._usingExternalTypesButton.setLayoutData((Object)new GridData(4, 0, true, false, 1, 2));
        this.updateOptionsBasedOnInput();
        if (this._inputType != null && !this._inputType.trim().isEmpty()) {
            this._inputTypeCombo.setText(this._inputType);
        }
        this._inputTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                ResourceDetailInputDialog.this._inputType = ResourceDetailInputDialog.this._inputTypeCombo.getText().trim();
                ResourceDetailInputDialog.this.getButton(0).setEnabled(ResourceDetailInputDialog.this.validate());
            }

            public void widgetSelected(SelectionEvent arg0) {
                this.widgetDefaultSelected(arg0);
            }
        });
        this._inputType = this._inputTypeCombo.getText().trim();
        if (this._worksheetName != null && !this._worksheetName.trim().isEmpty()) {
            this._worksheetNameText.setText(this._worksheetName);
            if (this._worksheetName.isEmpty()) {
                this._worksheetName = null;
            }
        }
        this._worksheetNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourceDetailInputDialog.this._worksheetName = ResourceDetailInputDialog.this._worksheetNameText.getText().trim();
                ResourceDetailInputDialog.this.getButton(0).setEnabled(ResourceDetailInputDialog.this.validate());
            }
        });
        this._worksheetName = this._worksheetNameText.getText().trim();
        this._usingExternalTypesButton.setSelection(this._usingExternalTypes);
        this._usingExternalTypesButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                ResourceDetailInputDialog.this._usingExternalTypes = ResourceDetailInputDialog.this._usingExternalTypesButton.getSelection();
                ResourceDetailInputDialog.this.getButton(0).setEnabled(ResourceDetailInputDialog.this.validate());
            }

            public void widgetSelected(SelectionEvent arg0) {
                this.widgetDefaultSelected(arg0);
            }
        });
        this._usingExternalTypes = this._usingExternalTypesButton.getSelection();
        return area;
    }

    private void updateOptionsBasedOnInput() {
        if (this._resourceType != null && this._resourceType.getType().equalsIgnoreCase("DTABLE")) {
            this._inputTypeCombo.removeAll();
            this._inputTypeCombo.add("");
            this._inputTypeCombo.add("XLS");
            this._inputTypeCombo.add("CSV");
            this._usingExternalTypesButton.setVisible(false);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control rtnControl = super.createButtonBar(parent);
        this.getButton(0).setEnabled(this.validate());
        this.setErrorMessage(null);
        return rtnControl;
    }

    protected Combo createLabelAndCombo(Composite parent, String label, boolean readOnly) {
        if (label != null && !label.trim().isEmpty()) {
            Label labelControl = new Label(parent, 0);
            labelControl.setText(label);
            TabbedPropertySheetWidgetFactory factory = new TabbedPropertySheetWidgetFactory();
            factory.adapt((Control)labelControl, false, false);
        }
        int styles = 2052;
        if (readOnly) {
            styles = 2060;
        }
        Combo newCombo = new Combo(parent, styles);
        newCombo.setLayoutData((Object)new GridData(4, 1, true, false));
        return newCombo;
    }

    protected Text createLabelAndText(Composite parent, String label) {
        new Label(parent, 0).setText(label);
        Text newText = new Text(parent, 2048);
        newText.setLayoutData((Object)new GridData(4, 0, true, false));
        return newText;
    }

    protected boolean validate() {
        this.setErrorMessage(null);
        return this.getErrorMessage() == null;
    }

    public String getInputType() {
        return this._inputType;
    }

    public String getWorksheetName() {
        return this._worksheetName;
    }

    public void setInputType(String value) {
        this._inputType = value;
    }

    public void setWorksheetName(String value) {
        this._worksheetName = value;
    }

    public void setResourceType(ResourceType value) {
        this._resourceType = value;
    }

    public void setUsingExternalTypes(boolean value) {
        this._usingExternalTypes = value;
    }

    public boolean getUsingExternalTypes() {
        return this._usingExternalTypes;
    }
}

