/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.bpmn2.component;

import java.math.BigInteger;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.switchyard.tools.models.switchyard1_0.bpm.BPMFactory;
import org.switchyard.tools.models.switchyard1_0.bpm.LoggerType;
import org.switchyard.tools.models.switchyard1_0.bpm.LoggerType1;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.bpmn2.Messages;

public class NewBPMProcessDetailsWizardPage
extends WizardPage {
    private String _processName;
    private Text _processNameText;
    private String _packageName;
    private Text _packageNameText;
    private String _processId;
    private Text _processIdText;
    private boolean _persistent;
    private Button _persistentCheckbox;
    private boolean _agent;
    private Button _agentCheckbox;
    private String _messageInName;
    private Text _messageInNameText;
    private String _messageOutName;
    private Text _messageOutNameText;
    private boolean _auditingEnabled;
    private Button _auditingEnabledCheckbox;
    private LoggerType1 _auditSettings = BPMFactory.eINSTANCE.createLoggerType1();
    private Text _auditLogText;
    private Text _auditIntervalText;
    private ComboViewer _auditTypeList;
    private String _oldServiceName;
    private String _oldPackageName;

    public NewBPMProcessDetailsWizardPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.title_businessProcessDetails);
        this.setDescription(Messages.description_businessProcessDetails);
    }

    public void createControl(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout(2, false));
        this.createLabel(contents, Messages.label_processName);
        this._processNameText = new Text(contents, 2052);
        this._processNameText.setLayoutData((Object)new GridData(768));
        this._processNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewBPMProcessDetailsWizardPage.this._processName = NewBPMProcessDetailsWizardPage.this._processNameText.getText();
                NewBPMProcessDetailsWizardPage.this.validate();
            }
        });
        this.createLabel(contents, Messages.label_packageName);
        this._packageNameText = new Text(contents, 2052);
        this._packageNameText.setLayoutData((Object)new GridData(768));
        this._packageNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewBPMProcessDetailsWizardPage.this._packageName = NewBPMProcessDetailsWizardPage.this._packageNameText.getText();
                NewBPMProcessDetailsWizardPage.this.validate();
            }
        });
        this.createLabel(contents, Messages.label_processId);
        this._processIdText = new Text(contents, 2052);
        this._processIdText.setLayoutData((Object)new GridData(768));
        this._processIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewBPMProcessDetailsWizardPage.this._processId = NewBPMProcessDetailsWizardPage.this._processIdText.getText();
                NewBPMProcessDetailsWizardPage.this.validate();
            }
        });
        this._persistentCheckbox = new Button(contents, 32);
        this._persistentCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this._persistentCheckbox.setText(Messages.label_persistProcessStateInDatabase);
        this._persistentCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewBPMProcessDetailsWizardPage.this._persistent = NewBPMProcessDetailsWizardPage.this._persistentCheckbox.getSelection();
                NewBPMProcessDetailsWizardPage.this.validate();
            }
        });
        this.createProcessPropertiesGroup(contents);
        this.createAuditSettingsGroup(contents);
        this.initControls();
        this.validate();
        this.setErrorMessage(null);
        this.setControl((Control)contents);
    }

    private void createProcessPropertiesGroup(Composite contents) {
        Group processPropertiesGroup = new Group(contents, 0);
        processPropertiesGroup.setLayout((Layout)new GridLayout(2, false));
        processPropertiesGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        processPropertiesGroup.setText(Messages.label_processPropertyNames);
        this.createLabel((Composite)processPropertiesGroup, Messages.label_parameter);
        this._messageInNameText = new Text((Composite)processPropertiesGroup, 2052);
        this._messageInNameText.setToolTipText(Messages.tooltip_parameter);
        this._messageInNameText.setLayoutData((Object)new GridData(768));
        this._messageInNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewBPMProcessDetailsWizardPage.this._messageInName = NewBPMProcessDetailsWizardPage.this._messageInNameText.getText();
                NewBPMProcessDetailsWizardPage.this.validate();
            }
        });
        this.createLabel((Composite)processPropertiesGroup, Messages.label_result);
        this._messageOutNameText = new Text((Composite)processPropertiesGroup, 2052);
        this._messageOutNameText.setToolTipText(Messages.tooltip_result);
        this._messageOutNameText.setLayoutData((Object)new GridData(768));
        this._messageOutNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewBPMProcessDetailsWizardPage.this._messageOutName = NewBPMProcessDetailsWizardPage.this._messageOutNameText.getText();
                NewBPMProcessDetailsWizardPage.this.validate();
            }
        });
    }

    private void createAuditSettingsGroup(Composite contents) {
        Group auditSettingsGroup = new Group(contents, 0);
        auditSettingsGroup.setLayout((Layout)new GridLayout(2, false));
        auditSettingsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        auditSettingsGroup.setText(Messages.label_auditSettings);
        this._auditingEnabledCheckbox = new Button((Composite)auditSettingsGroup, 32);
        this._auditingEnabledCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this._auditingEnabledCheckbox.setText(Messages.label_enableAuditing);
        this._auditingEnabledCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewBPMProcessDetailsWizardPage.this._auditingEnabled = NewBPMProcessDetailsWizardPage.this._auditingEnabledCheckbox.getSelection();
                NewBPMProcessDetailsWizardPage.this.updateAuditControls();
                NewBPMProcessDetailsWizardPage.this.validate();
            }
        });
        this.createLabel((Composite)auditSettingsGroup, Messages.label_logName);
        this._auditLogText = new Text((Composite)auditSettingsGroup, 2052);
        this._auditLogText.setLayoutData((Object)new GridData(768));
        this._auditLogText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewBPMProcessDetailsWizardPage.this._auditSettings.setLog(NewBPMProcessDetailsWizardPage.this.nullForEmpty(NewBPMProcessDetailsWizardPage.this._auditLogText.getText()));
                NewBPMProcessDetailsWizardPage.this.validate();
            }
        });
        this.createLabel((Composite)auditSettingsGroup, Messages.label_interval);
        this._auditIntervalText = new Text((Composite)auditSettingsGroup, 2052);
        this._auditIntervalText.setLayoutData((Object)new GridData(768));
        this._auditIntervalText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                try {
                    NewBPMProcessDetailsWizardPage.this._auditSettings.setInterval((Object)BigInteger.valueOf(Integer.parseInt(NewBPMProcessDetailsWizardPage.this._auditIntervalText.getText())));
                }
                catch (NumberFormatException e) {
                    e.fillInStackTrace();
                }
                NewBPMProcessDetailsWizardPage.this.validate();
            }
        });
        this.createLabel((Composite)auditSettingsGroup, Messages.label_logType);
        this._auditTypeList = new ComboViewer((Composite)auditSettingsGroup, 4);
        this._auditTypeList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof LoggerType) {
                    return ((LoggerType)element).getLiteral();
                }
                return super.getText(element);
            }
        });
        this._auditTypeList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._auditTypeList.setInput((Object)LoggerType.values());
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    public String getProcessName() {
        return this.nullForEmpty(this._processName);
    }

    public void setProcessName(String processName) {
        if (this._processNameText == null) {
            this._processName = processName;
        } else {
            this._processNameText.setText(processName);
        }
    }

    public String getPackageName() {
        return this.emptyForNull(this._packageName);
    }

    public void setPackageName(String packageName) {
        if (this._packageNameText == null) {
            this._packageName = packageName;
        } else {
            this._packageNameText.setText(packageName);
        }
    }

    public String getProcessId() {
        return this.nullForEmpty(this._processId);
    }

    public void setProcessId(String processId) {
        if (this._processIdText == null) {
            this._processId = processId;
        } else {
            this._processIdText.setText(processId);
        }
    }

    public boolean isPersistent() {
        return this._persistent;
    }

    public void setPersistent(boolean persistent) {
        if (this._persistentCheckbox == null) {
            this._persistent = persistent;
        } else {
            this._persistentCheckbox.setSelection(persistent);
        }
    }

    public boolean isAgent() {
        return this._agent;
    }

    public void setAgent(boolean agent) {
        if (this._agentCheckbox == null) {
            this._agent = agent;
        } else {
            this._agentCheckbox.setSelection(agent);
        }
    }

    public String getMessageInName() {
        return this.nullForEmpty(this._messageInName);
    }

    public void setMessageInName(String messageInName) {
        if (this._messageInNameText == null) {
            this._messageInName = messageInName;
        } else {
            this._messageInNameText.setText(messageInName);
        }
    }

    public String getMessageOutName() {
        return this.nullForEmpty(this._messageOutName);
    }

    public void setMessageOutName(String messageOutName) {
        if (this._messageOutNameText == null) {
            this._messageOutName = messageOutName;
        } else {
            this._messageOutNameText.setText(messageOutName);
        }
    }

    public boolean isAuditingEnabled() {
        return this._auditingEnabled;
    }

    public void setAuditingEnabled(boolean auditingEnabled) {
        if (this._auditingEnabledCheckbox == null) {
            this._auditingEnabled = auditingEnabled;
        } else {
            this._auditingEnabledCheckbox.setSelection(auditingEnabled);
            this.updateAuditControls();
        }
    }

    public LoggerType1 getAuditSettings() {
        return this._auditSettings;
    }

    public void setAuditSettings(LoggerType1 auditSettings) {
        if (this._auditingEnabledCheckbox == null) {
            this._auditSettings = auditSettings;
        } else {
            this._auditLogText.setText(this.emptyForNull(auditSettings.getLog()));
            this._auditIntervalText.setText(auditSettings.getInterval() == null ? "" : auditSettings.getInterval().toString());
            this._auditTypeList.setSelection((ISelection)new StructuredSelection((Object)auditSettings.getType()), true);
        }
    }

    public void update(IJavaProject project, String bpmnFileName, ComponentService service) {
        IJavaElement element;
        String newServiceName = this.emptyForNull(service.getName());
        if (this.updateDefault(this._oldServiceName, newServiceName, this._processIdText.getText())) {
            this.setProcessId(newServiceName);
        }
        if (this.updateDefault(this._oldServiceName, newServiceName, this._processNameText.getText())) {
            this.setProcessName(newServiceName);
        }
        this._oldServiceName = newServiceName;
        String newPackageName = project == null ? "" : ((element = JavaUtil.getInitialPackageForProject((IJavaProject)project)).getElementType() == 4 ? ((IPackageFragment)element).getElementName() : "");
        if (this.updateDefault(this._oldPackageName, newPackageName, this._packageNameText.getText())) {
            this.setPackageName(newPackageName);
        }
        this._oldPackageName = newPackageName;
    }

    private boolean updateDefault(String oldValue, String newValue, String currentValue) {
        return !currentValue.equals(newValue) && (oldValue == null || oldValue.length() == 0 || currentValue.length() == 0 || oldValue.equals(currentValue));
    }

    private String emptyForNull(String string) {
        return string == null ? "" : string;
    }

    private String nullForEmpty(String string) {
        return string == null ? null : (string.length() == 0 ? null : string);
    }

    private void initControls() {
        this.setAuditSettings(this._auditSettings == null ? BPMFactory.eINSTANCE.createLoggerType1() : this._auditSettings);
        this.setAuditingEnabled(this._auditingEnabled);
        this.setMessageInName(this.emptyForNull(this._messageInName));
        this.setMessageOutName(this.emptyForNull(this._messageOutName));
        this.setPackageName(this.emptyForNull(this._packageName));
        this.setPersistent(this._persistent);
        this.setProcessId(this.emptyForNull(this._processId));
        this.setProcessName(this.emptyForNull(this._processName));
    }

    private void validate() {
        String intervalText;
        this.setErrorMessage(null);
        if (this.getProcessId() == null) {
            this.setErrorMessage(Messages.error_noProcessId);
        } else if (this.getProcessName() == null) {
            this.setErrorMessage(Messages.error_noProcessName);
        } else if (this.isAuditingEnabled() && (intervalText = this._auditIntervalText.getText()).length() != 0) {
            try {
                Integer.parseInt(intervalText);
            }
            catch (NumberFormatException e) {
                this.setErrorMessage(e.getLocalizedMessage());
            }
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private void updateAuditControls() {
        this._auditIntervalText.setEnabled(this._auditingEnabled);
        this._auditLogText.setEnabled(this._auditingEnabled);
        this._auditTypeList.getControl().setEnabled(this._auditingEnabled);
    }
}

