/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.common.web.WebUtils;
import org.jboss.tools.vpe.preview.core.util.SuitableFileExtensions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class EditorUtil {
    private EditorUtil() {
    }

    public static boolean isInCurrentEditor(IStructuredSelection selection, IEditorPart editor) {
        Node selectedNode = EditorUtil.getNodeFromSelection(selection);
        Document selectionDocument = null;
        if (selectedNode != null) {
            selectionDocument = selectedNode.getOwnerDocument();
        }
        Document editorDocument = EditorUtil.getEditorDomDocument(editor);
        return selectionDocument != null && selectionDocument == editorDocument;
    }

    public static Node getNodeFromSelection(IStructuredSelection selection) {
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof Node) {
            return (Node)firstElement;
        }
        return null;
    }

    public static boolean isImportant(IEditorPart editor) {
        String fileExtension = EditorUtil.getFileExtensionFromEditor(editor);
        return editor.getAdapter(StructuredTextEditor.class) != null || SuitableFileExtensions.isCssOrJs(fileExtension);
    }

    public static IFile getFileOpenedInEditor(IEditorPart editorPart) {
        IFile file = null;
        if (editorPart != null && editorPart.getEditorInput() instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorPart.getEditorInput();
            file = fileEditorInput.getFile();
        }
        return file;
    }

    public static String getFileExtensionFromEditor(IEditorPart editor) {
        String fileExtension = null;
        IFile file = EditorUtil.getFileOpenedInEditor(editor);
        if (file != null && file.exists()) {
            fileExtension = file.getFileExtension();
        }
        return fileExtension;
    }

    public static String formUrl(IFile file, int modelHolderId, String serverPort) throws UnsupportedEncodingException {
        String projectName = file.getProject().getName();
        String projectRelativePath = file.getProjectRelativePath().toString();
        IContainer webroot = WebUtils.getWebRootFolder((IResource)file);
        String webrootRelativePathString = projectRelativePath;
        String webrootString = null;
        if (webroot != null) {
            IPath webrootRelativePath = file.getFullPath().makeRelativeTo(webroot.getFullPath());
            webrootRelativePathString = webrootRelativePath.toString();
            webrootString = webroot.getFullPath().toString();
        } else {
            webrootString = "/" + projectName;
        }
        String parameters = "webroot=" + URLEncoder.encode(webrootString, "UTF-8") + "&" + "viewId" + "=" + modelHolderId;
        return "http://localhost:" + serverPort + "/" + webrootRelativePathString + "?" + parameters;
    }

    private static Document getEditorDomDocument(IEditorPart editor) {
        IDOMModel editorModel = null;
        if (editor != null) {
            editorModel = (IDOMModel)editor.getAdapter(IDOMModel.class);
        }
        IDOMDocument editorIdomDocument = null;
        if (editorModel != null) {
            editorIdomDocument = editorModel.getDocument();
        }
        Element editorDocumentElement = null;
        if (editorIdomDocument != null) {
            editorDocumentElement = editorIdomDocument.getDocumentElement();
        }
        Document editorDocument = null;
        if (editorDocumentElement != null) {
            editorDocument = editorDocumentElement.getOwnerDocument();
        }
        return editorDocument;
    }
}

