/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.core.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.jboss.tools.vpe.preview.core.Activator;
import org.jboss.tools.vpe.preview.core.util.Messages;

public class ActionBarUtil {
    private static final String GROUP_REFRESH = "org.jboss.tools.vpv.refresh";
    private IAction refreshAction;
    private IAction openInDefaultBrowserAction;
    private IAction enableAutomaticRefreshAction;
    private IAction enableRefreshOnSaveAction;
    private IExecutionListener saveListener;
    private boolean enableAutomaticRefresh = true;
    private Browser browser;
    private Command saveCommand;
    private Command saveAllCommand;

    public ActionBarUtil(Browser browser1) {
        this.browser = browser1;
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        this.saveCommand = commandService.getCommand("org.eclipse.ui.file.save");
        this.saveAllCommand = commandService.getCommand("org.eclipse.ui.file.saveAll");
        this.saveListener = new IExecutionListener(){

            public void postExecuteSuccess(String arg0, Object arg1) {
                ActionBarUtil.this.refresh(ActionBarUtil.this.browser);
            }

            public void notHandled(String arg0, NotHandledException arg1) {
            }

            public void postExecuteFailure(String arg0, ExecutionException arg1) {
            }

            public void preExecute(String arg0, ExecutionEvent arg1) {
            }
        };
    }

    public void fillLocalToolBar(IToolBarManager manager) {
        this.makeActions();
        manager.add(this.refreshAction);
        manager.add(this.openInDefaultBrowserAction);
        manager.add((IContributionItem)new Separator(GROUP_REFRESH));
        manager.appendToGroup(GROUP_REFRESH, this.enableAutomaticRefreshAction);
        manager.appendToGroup(GROUP_REFRESH, this.enableRefreshOnSaveAction);
    }

    private void makeActions() {
        this.makeRefreshAction();
        this.makeOpenInDefaultBrowserAction();
        this.makeEnableAutomaticRefreshAction();
        this.makeEnableRefreshOnSaveAction();
    }

    private void makeEnableAutomaticRefreshAction() {
        this.enableAutomaticRefreshAction = new Action(Messages.VpvView_ENABLE_AUTOMATIC_REFRESH, 2){

            public void run() {
                if (ActionBarUtil.this.enableAutomaticRefreshAction.isChecked()) {
                    ActionBarUtil.this.enableAutomaticRefresh = true;
                    ActionBarUtil.this.enableRefreshOnSaveAction.setChecked(false);
                    ActionBarUtil.this.saveCommand.removeExecutionListener(ActionBarUtil.this.saveListener);
                    ActionBarUtil.this.saveAllCommand.removeExecutionListener(ActionBarUtil.this.saveListener);
                } else {
                    ActionBarUtil.this.enableAutomaticRefresh = false;
                }
            }
        };
        this.enableAutomaticRefreshAction.setChecked(true);
        this.enableAutomaticRefreshAction.setImageDescriptor(Activator.getImageDescriptor("icons/refresh_on_change.png"));
    }

    private void makeEnableRefreshOnSaveAction() {
        this.enableRefreshOnSaveAction = new Action(Messages.VpvView_ENABLE_REFRESH_ON_SAVE, 2){

            public void run() {
                if (ActionBarUtil.this.enableRefreshOnSaveAction.isChecked()) {
                    ActionBarUtil.this.saveCommand.addExecutionListener(ActionBarUtil.this.saveListener);
                    ActionBarUtil.this.saveAllCommand.addExecutionListener(ActionBarUtil.this.saveListener);
                    ActionBarUtil.this.enableAutomaticRefreshAction.setChecked(false);
                    ActionBarUtil.this.enableAutomaticRefresh = false;
                } else {
                    ActionBarUtil.this.saveCommand.removeExecutionListener(ActionBarUtil.this.saveListener);
                    ActionBarUtil.this.saveAllCommand.removeExecutionListener(ActionBarUtil.this.saveListener);
                }
            }
        };
        this.enableRefreshOnSaveAction.setChecked(false);
        this.enableRefreshOnSaveAction.setImageDescriptor(Activator.getImageDescriptor("icons/refresh_on_save.png"));
    }

    private void makeOpenInDefaultBrowserAction() {
        this.openInDefaultBrowserAction = new Action(){

            public void run() {
                try {
                    URL url = new URL(ActionBarUtil.this.browser.getUrl());
                    Program.launch((String)url.toString());
                }
                catch (MalformedURLException e) {
                    Activator.logError(e);
                }
            }
        };
        this.openInDefaultBrowserAction.setText(Messages.VpvView_OPEN_IN_DEFAULT_BROWSER);
        this.openInDefaultBrowserAction.setToolTipText(Messages.VpvView_OPEN_IN_DEFAULT_BROWSER);
        this.openInDefaultBrowserAction.setImageDescriptor(Activator.getImageDescriptor("icons/open_in_default_browser.gif"));
    }

    private void makeRefreshAction() {
        this.refreshAction = new Action(){

            public void run() {
                ActionBarUtil.this.refresh(ActionBarUtil.this.browser);
            }
        };
        this.refreshAction.setText(Messages.VpvView_REFRESH);
        this.refreshAction.setToolTipText(Messages.VpvView_REFRESH);
        this.refreshAction.setImageDescriptor(Activator.getImageDescriptor("icons/refresh.gif"));
    }

    private void refresh(Browser browser) {
        browser.setUrl(browser.getUrl());
    }

    public boolean isAutomaticRefreshEnabled() {
        return this.enableAutomaticRefresh;
    }
}

