/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.core.transform;

import java.io.File;
import java.io.IOException;
import javax.activation.MimetypesFileTypeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.vpe.preview.core.Activator;
import org.jboss.tools.vpe.preview.core.transform.DomUtil;
import org.jboss.tools.vpe.preview.core.transform.ResourceAcceptor;
import org.jboss.tools.vpe.preview.core.transform.VpvDomBuilder;
import org.jboss.tools.vpe.preview.core.transform.VpvVisualModel;
import org.jboss.tools.vpe.preview.core.transform.VpvVisualModelHolder;
import org.jboss.tools.vpe.preview.core.transform.VpvVisualModelHolderRegistry;
import org.w3c.dom.Document;

public class VpvController {
    private VpvDomBuilder domBuilder;
    private VpvVisualModelHolderRegistry visualModelHolderRegistry;

    public VpvController(VpvDomBuilder domBuilder, VpvVisualModelHolderRegistry visualModelHolderRegistry) {
        this.domBuilder = domBuilder;
        this.visualModelHolderRegistry = visualModelHolderRegistry;
    }

    public void getResource(String path, Integer viewId, ResourceAcceptor resourceAcceptor) {
        VpvVisualModelHolder visualModelHolder;
        Path workspacePath = new Path(path);
        IFile requestedFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)workspacePath);
        VpvVisualModel visualModel = null;
        IStructuredModel sourceModel = null;
        try {
            sourceModel = StructuredModelManager.getModelManager().getExistingModelForRead(requestedFile);
            IDOMDocument sourceDocument = null;
            if (sourceModel instanceof IDOMModel) {
                IDOMModel sourceDomModel = (IDOMModel)sourceModel;
                sourceDocument = sourceDomModel.getDocument();
            }
            if (sourceDocument != null) {
                try {
                    visualModel = this.domBuilder.buildVisualModel((Document)sourceDocument);
                }
                catch (ParserConfigurationException e) {
                    Activator.logError(e);
                }
            }
        }
        finally {
            if (sourceModel != null) {
                sourceModel.releaseFromRead();
            }
        }
        if ((visualModelHolder = this.visualModelHolderRegistry.getHolderById(viewId)) != null) {
            visualModelHolder.setVisualModel(visualModel);
        }
        String htmlText = null;
        if (visualModel != null) {
            try {
                htmlText = DomUtil.nodeToString(visualModel.getVisualDocument());
            }
            catch (TransformerException e) {
                Activator.logError(e);
            }
        }
        if (htmlText != null) {
            resourceAcceptor.acceptText("<!DOCTYPE html>\n" + htmlText, "text/html");
        } else if (requestedFile.getLocation() != null && requestedFile.getLocation().toFile() != null && requestedFile.getLocation().toFile().exists()) {
            File file = requestedFile.getLocation().toFile();
            String mimeType = VpvController.getMimeType(file);
            resourceAcceptor.acceptFile(file, mimeType);
        } else {
            resourceAcceptor.acceptError();
        }
    }

    private static String getMimeType(File file) {
        try {
            MimetypesFileTypeMap mimeTypes = new MimetypesFileTypeMap(Activator.getFileUrl("lib/mime.types").openStream());
            return mimeTypes.getContentType(file);
        }
        catch (IOException e) {
            Activator.logError(e);
            return "application/octet-stream";
        }
    }
}

