/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.collections;

import org.mockito.internal.util.MockUtil;

public class HashCodeAndEqualsMockWrapper {
    private Object mockInstance;

    public HashCodeAndEqualsMockWrapper(Object mockInstance) {
        this.mockInstance = mockInstance;
    }

    public Object get() {
        return this.mockInstance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HashCodeAndEqualsMockWrapper)) {
            return false;
        }
        HashCodeAndEqualsMockWrapper that = (HashCodeAndEqualsMockWrapper)o;
        return this.mockInstance == that.mockInstance;
    }

    public int hashCode() {
        return System.identityHashCode(this.mockInstance);
    }

    public static HashCodeAndEqualsMockWrapper of(Object mock) {
        return new HashCodeAndEqualsMockWrapper(mock);
    }

    public String toString() {
        MockUtil mockUtil = new MockUtil();
        return "HashCodeAndEqualsMockWrapper{mockInstance=" + (mockUtil.isMock(this.mockInstance) ? mockUtil.getMockName(this.mockInstance) : this.typeInstanceString()) + '}';
    }

    private String typeInstanceString() {
        return String.valueOf(this.mockInstance.getClass().getSimpleName()) + "(" + System.identityHashCode(this.mockInstance) + ")";
    }
}

