/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util;

import java.util.Collection;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.creation.jmock.ClassImposterizer;

public class MockCreationValidator {
    public boolean isTypeMockable(Class<?> clz) {
        return ClassImposterizer.INSTANCE.canImposterise(clz);
    }

    public void validateType(Class classToMock) {
        if (!this.isTypeMockable(classToMock)) {
            new Reporter().cannotMockFinalClass(classToMock);
        }
    }

    public void validateExtraInterfaces(Class classToMock, Collection<Class> extraInterfaces) {
        if (extraInterfaces == null) {
            return;
        }
        for (Class i : extraInterfaces) {
            if (classToMock != i) continue;
            new Reporter().extraInterfacesCannotContainMockedType(classToMock);
        }
    }

    public void validateMockedType(Class classToMock, Object spiedInstance) {
        if (classToMock == null || spiedInstance == null) {
            return;
        }
        if (!classToMock.equals(spiedInstance.getClass())) {
            new Reporter().mockedTypeIsInconsistentWithSpiedInstanceType(classToMock, spiedInstance);
        }
    }

    public void validateDelegatedInstance(Class classToMock, Object delegatedInstance) {
        if (classToMock == null || delegatedInstance == null) {
            return;
        }
        if (delegatedInstance.getClass().isAssignableFrom(classToMock)) {
            new Reporter().mockedTypeIsInconsistentWithDelegatedInstanceType(classToMock, delegatedInstance);
        }
    }
}

