/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.answers;

import org.mockito.exceptions.Reporter;
import org.mockito.internal.stubbing.answers.CallsRealMethods;
import org.mockito.internal.stubbing.answers.DoesNothing;
import org.mockito.internal.stubbing.answers.MethodInfo;
import org.mockito.internal.stubbing.answers.Returns;
import org.mockito.internal.stubbing.answers.ReturnsArgumentAt;
import org.mockito.internal.stubbing.answers.ThrowsException;
import org.mockito.invocation.Invocation;
import org.mockito.stubbing.Answer;

public class AnswersValidator {
    private Reporter reporter = new Reporter();

    public void validate(Answer<?> answer, Invocation invocation) {
        MethodInfo methodInfo = new MethodInfo(invocation);
        if (answer instanceof ThrowsException) {
            this.validateException((ThrowsException)answer, methodInfo);
        }
        if (answer instanceof Returns) {
            this.validateReturnValue((Returns)answer, methodInfo);
        }
        if (answer instanceof DoesNothing) {
            this.validateDoNothing((DoesNothing)answer, methodInfo);
        }
        if (answer instanceof CallsRealMethods) {
            this.validateMockingConcreteClass((CallsRealMethods)answer, methodInfo);
        }
        if (answer instanceof ReturnsArgumentAt) {
            ReturnsArgumentAt returnsArgumentAt = (ReturnsArgumentAt)answer;
            this.validateReturnArgIdentity(returnsArgumentAt, invocation);
        }
    }

    private void validateReturnArgIdentity(ReturnsArgumentAt returnsArgumentAt, Invocation invocation) {
        returnsArgumentAt.validateIndexWithinInvocationRange(invocation);
        MethodInfo methodInfo = new MethodInfo(invocation);
        if (!methodInfo.isValidReturnType(returnsArgumentAt.returnedTypeOnSignature(invocation))) {
            new Reporter().wrongTypeOfArgumentToReturn(invocation, methodInfo.printMethodReturnType(), returnsArgumentAt.returnedTypeOnSignature(invocation), returnsArgumentAt.wantedArgumentPosition());
        }
    }

    private void validateMockingConcreteClass(CallsRealMethods answer, MethodInfo methodInfo) {
        if (methodInfo.isDeclaredOnInterface()) {
            this.reporter.cannotCallRealMethodOnInterface();
        }
    }

    private void validateDoNothing(DoesNothing answer, MethodInfo methodInfo) {
        if (!methodInfo.isVoid()) {
            this.reporter.onlyVoidMethodsCanBeSetToDoNothing();
        }
    }

    private void validateReturnValue(Returns answer, MethodInfo methodInfo) {
        if (methodInfo.isVoid()) {
            this.reporter.cannotStubVoidMethodWithAReturnValue(methodInfo.getMethodName());
        }
        if (answer.returnsNull() && methodInfo.returnsPrimitive()) {
            this.reporter.wrongTypeOfReturnValue(methodInfo.printMethodReturnType(), "null", methodInfo.getMethodName());
        }
        if (!answer.returnsNull() && !methodInfo.isValidReturnType(answer.getReturnType())) {
            this.reporter.wrongTypeOfReturnValue(methodInfo.printMethodReturnType(), answer.printReturnType(), methodInfo.getMethodName());
        }
    }

    private void validateException(ThrowsException answer, MethodInfo methodInfo) {
        Throwable throwable = answer.getThrowable();
        if (throwable == null) {
            this.reporter.cannotStubWithNullThrowable();
        }
        if (throwable instanceof RuntimeException || throwable instanceof Error) {
            return;
        }
        if (!methodInfo.isValidException(throwable)) {
            this.reporter.checkedExceptionInvalid(throwable);
        }
    }
}

