/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.handler;

import java.util.List;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.listeners.NotifiedMethodInvocationReport;
import org.mockito.internal.stubbing.InvocationContainer;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.MockHandler;
import org.mockito.listeners.InvocationListener;
import org.mockito.mock.MockCreationSettings;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.VoidMethodStubbable;

class InvocationNotifierHandler<T>
implements MockHandler,
InternalMockHandler<T> {
    private List<InvocationListener> invocationListeners;
    private InternalMockHandler<T> mockHandler;

    public InvocationNotifierHandler(InternalMockHandler<T> mockHandler, MockCreationSettings settings) {
        this.mockHandler = mockHandler;
        this.invocationListeners = settings.getInvocationListeners();
    }

    @Override
    public Object handle(Invocation invocation) throws Throwable {
        try {
            Object returnedValue = this.mockHandler.handle(invocation);
            this.notifyMethodCall(invocation, returnedValue);
            return returnedValue;
        }
        catch (Throwable t) {
            this.notifyMethodCallException(invocation, t);
            throw t;
        }
    }

    private void notifyMethodCall(Invocation invocation, Object returnValue) {
        for (InvocationListener listener : this.invocationListeners) {
            try {
                listener.reportInvocation(new NotifiedMethodInvocationReport(invocation, returnValue));
            }
            catch (Throwable listenerThrowable) {
                new Reporter().invocationListenerThrewException(listener, listenerThrowable);
            }
        }
    }

    private void notifyMethodCallException(Invocation invocation, Throwable exception) {
        for (InvocationListener listener : this.invocationListeners) {
            try {
                listener.reportInvocation(new NotifiedMethodInvocationReport(invocation, exception));
            }
            catch (Throwable listenerThrowable) {
                new Reporter().invocationListenerThrewException(listener, listenerThrowable);
            }
        }
    }

    @Override
    public MockCreationSettings getMockSettings() {
        return this.mockHandler.getMockSettings();
    }

    @Override
    public VoidMethodStubbable<T> voidMethodStubbable(T mock) {
        return this.mockHandler.voidMethodStubbable(mock);
    }

    @Override
    public void setAnswersForStubbing(List<Answer> answers) {
        this.mockHandler.setAnswersForStubbing(answers);
    }

    @Override
    public InvocationContainer getInvocationContainer() {
        return this.mockHandler.getInvocationContainer();
    }
}

