/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.jmock;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import org.mockito.cglib.core.CodeGenerationException;
import org.mockito.cglib.core.NamingPolicy;
import org.mockito.cglib.core.Predicate;
import org.mockito.cglib.proxy.Callback;
import org.mockito.cglib.proxy.CallbackFilter;
import org.mockito.cglib.proxy.Enhancer;
import org.mockito.cglib.proxy.Factory;
import org.mockito.cglib.proxy.MethodInterceptor;
import org.mockito.cglib.proxy.NoOp;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.GlobalConfiguration;
import org.mockito.internal.creation.cglib.MockitoNamingPolicy;
import org.mockito.internal.creation.jmock.SearchingClassLoader;
import org.mockito.internal.creation.jmock.SerializableNoOp;
import org.mockito.internal.util.StringJoiner;
import org.objenesis.ObjenesisStd;

public class ClassImposterizer {
    public static final ClassImposterizer INSTANCE = new ClassImposterizer();
    private ObjenesisStd objenesis = new ObjenesisStd(new GlobalConfiguration().enableClassCache());
    private static final NamingPolicy NAMING_POLICY_THAT_ALLOWS_IMPOSTERISATION_OF_CLASSES_IN_SIGNED_PACKAGES = new MockitoNamingPolicy(){

        @Override
        public String getClassName(String prefix, String source, Object key, Predicate names) {
            return "codegen." + super.getClassName(prefix, source, key, names);
        }
    };
    private static final CallbackFilter IGNORE_BRIDGE_METHODS = new CallbackFilter(){

        @Override
        public int accept(Method method) {
            return method.isBridge() ? 1 : 0;
        }
    };

    private ClassImposterizer() {
    }

    public boolean canImposterise(Class<?> type) {
        return !type.isPrimitive() && !Modifier.isFinal(type.getModifiers());
    }

    public <T> T imposterise(MethodInterceptor interceptor, Class<T> mockedType, Collection<Class> ancillaryTypes) {
        return this.imposterise(interceptor, mockedType, ancillaryTypes.toArray(new Class[ancillaryTypes.size()]));
    }

    public <T> T imposterise(MethodInterceptor interceptor, Class<T> mockedType, Class<?> ... ancillaryTypes) {
        try {
            this.setConstructorsAccessible(mockedType, true);
            Class<?> proxyClass = this.createProxyClass(mockedType, ancillaryTypes);
            T t = mockedType.cast(this.createProxy(proxyClass, interceptor));
            return t;
        }
        catch (ClassCastException cce) {
            throw new MockitoException(StringJoiner.join("ClassCastException occurred when creating the proxy.", "You might experience classloading issues, disabling the Objenesis cache *might* help (see MockitoConfiguration)"), cce);
        }
        finally {
            this.setConstructorsAccessible(mockedType, false);
        }
    }

    private void setConstructorsAccessible(Class<?> mockedType, boolean accessible) {
        Constructor<?>[] constructorArray = mockedType.getDeclaredConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            constructor.setAccessible(accessible);
            ++n2;
        }
    }

    private Class<?> createProxyClass(Class<?> mockedType, Class<?> ... interfaces) {
        if (mockedType == Object.class) {
            mockedType = ClassWithSuperclassToWorkAroundCglibBug.class;
        }
        Enhancer enhancer = new Enhancer(){

            @Override
            protected void filterConstructors(Class sc, List constructors) {
            }
        };
        enhancer.setClassLoader(SearchingClassLoader.combineLoadersOf(mockedType));
        enhancer.setUseFactory(true);
        if (mockedType.isInterface()) {
            enhancer.setSuperclass(Object.class);
            enhancer.setInterfaces(this.prepend(mockedType, interfaces));
        } else {
            enhancer.setSuperclass(mockedType);
            enhancer.setInterfaces(interfaces);
        }
        enhancer.setCallbackTypes(new Class[]{MethodInterceptor.class, NoOp.class});
        enhancer.setCallbackFilter(IGNORE_BRIDGE_METHODS);
        if (mockedType.getSigners() != null) {
            enhancer.setNamingPolicy(NAMING_POLICY_THAT_ALLOWS_IMPOSTERISATION_OF_CLASSES_IN_SIGNED_PACKAGES);
        } else {
            enhancer.setNamingPolicy(MockitoNamingPolicy.INSTANCE);
        }
        try {
            return enhancer.createClass();
        }
        catch (CodeGenerationException e) {
            if (Modifier.isPrivate(mockedType.getModifiers())) {
                throw new MockitoException("\nMockito cannot mock this class: " + mockedType + ".\n" + "Most likely it is a private class that is not visible by Mockito");
            }
            throw new MockitoException("\nMockito cannot mock this class: " + mockedType + "\n" + "Mockito can only mock visible & non-final classes." + "\n" + "If you're not sure why you're getting this error, please report to the mailing list.", e);
        }
    }

    private Object createProxy(Class<?> proxyClass, MethodInterceptor interceptor) {
        Factory proxy = (Factory)this.objenesis.newInstance(proxyClass);
        proxy.setCallbacks(new Callback[]{interceptor, SerializableNoOp.SERIALIZABLE_INSTANCE});
        return proxy;
    }

    private Class<?>[] prepend(Class<?> first, Class<?> ... rest) {
        Class[] all = new Class[rest.length + 1];
        all[0] = first;
        System.arraycopy(rest, 0, all, 1, rest.length);
        return all;
    }

    public static class ClassWithSuperclassToWorkAroundCglibBug {
    }
}

