/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration.injection;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.injection.MockInjectionStrategy;
import org.mockito.internal.configuration.injection.filter.FinalMockCandidateFilter;
import org.mockito.internal.configuration.injection.filter.MockCandidateFilter;
import org.mockito.internal.configuration.injection.filter.NameBasedCandidateFilter;
import org.mockito.internal.configuration.injection.filter.TypeBasedCandidateFilter;
import org.mockito.internal.util.collections.ListUtil;
import org.mockito.internal.util.collections.Sets;
import org.mockito.internal.util.reflection.FieldInitializationReport;
import org.mockito.internal.util.reflection.FieldInitializer;

public class PropertyAndSetterInjection
extends MockInjectionStrategy {
    private final MockCandidateFilter mockCandidateFilter = new TypeBasedCandidateFilter(new NameBasedCandidateFilter(new FinalMockCandidateFilter()));
    private Comparator<Field> superTypesLast = new FieldTypeAndNameComparator();
    private ListUtil.Filter<Field> notFinalOrStatic = new ListUtil.Filter<Field>(){

        @Override
        public boolean isOut(Field object) {
            return Modifier.isFinal(object.getModifiers()) || Modifier.isStatic(object.getModifiers());
        }
    };

    @Override
    public boolean processInjection(Field injectMocksField, Object injectMocksFieldOwner, Set<Object> mockCandidates) {
        FieldInitializationReport report = this.initializeInjectMocksField(injectMocksField, injectMocksFieldOwner);
        boolean injectionOccurred = false;
        Class<?> fieldClass = report.fieldClass();
        Object fieldInstanceNeedingInjection = report.fieldInstance();
        while (fieldClass != Object.class) {
            injectionOccurred |= this.injectMockCandidates(fieldClass, Sets.newMockSafeHashSet(mockCandidates), fieldInstanceNeedingInjection);
            fieldClass = fieldClass.getSuperclass();
        }
        return injectionOccurred;
    }

    private FieldInitializationReport initializeInjectMocksField(Field field, Object fieldOwner) {
        FieldInitializationReport report = null;
        try {
            report = new FieldInitializer(fieldOwner, field).initialize();
        }
        catch (MockitoException e) {
            if (e.getCause() instanceof InvocationTargetException) {
                Throwable realCause = e.getCause().getCause();
                new Reporter().fieldInitialisationThrewException(field, realCause);
            }
            new Reporter().cannotInitializeForInjectMocksAnnotation(field.getName(), e);
        }
        return report;
    }

    private boolean injectMockCandidates(Class<?> awaitingInjectionClazz, Set<Object> mocks, Object instance) {
        boolean injectionOccurred = false;
        List<Field> orderedInstanceFields = this.orderedInstanceFieldsFrom(awaitingInjectionClazz);
        injectionOccurred |= this.injectMockCandidatesOnFields(mocks, instance, injectionOccurred, orderedInstanceFields);
        injectionOccurred |= this.injectMockCandidatesOnFields(mocks, instance, injectionOccurred, orderedInstanceFields);
        return injectionOccurred;
    }

    private boolean injectMockCandidatesOnFields(Set<Object> mocks, Object instance, boolean injectionOccurred, List<Field> orderedInstanceFields) {
        Iterator<Field> it = orderedInstanceFields.iterator();
        while (it.hasNext()) {
            Field field = it.next();
            Object injected = this.mockCandidateFilter.filterCandidate(mocks, field, instance).thenInject();
            if (injected == null) continue;
            injectionOccurred |= true;
            mocks.remove(injected);
            it.remove();
        }
        return injectionOccurred;
    }

    private List<Field> orderedInstanceFieldsFrom(Class<?> awaitingInjectionClazz) {
        List<Field> declaredFields = Arrays.asList(awaitingInjectionClazz.getDeclaredFields());
        declaredFields = ListUtil.filter(declaredFields, this.notFinalOrStatic);
        Collections.sort(declaredFields, this.superTypesLast);
        return declaredFields;
    }

    static class FieldTypeAndNameComparator
    implements Comparator<Field> {
        FieldTypeAndNameComparator() {
        }

        @Override
        public int compare(Field field1, Field field2) {
            Class<?> field2Type;
            Class<?> field1Type = field1.getType();
            if (field1Type == (field2Type = field2.getType())) {
                return field1.getName().compareTo(field2.getName());
            }
            if (field1Type.isAssignableFrom(field2Type)) {
                return 1;
            }
            if (field2Type.isAssignableFrom(field1Type)) {
                return -1;
            }
            return 0;
        }
    }
}

