/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.cglib.proxy;

import org.mockito.asm.Type;
import org.mockito.cglib.proxy.Callback;
import org.mockito.cglib.proxy.CallbackGenerator;
import org.mockito.cglib.proxy.Dispatcher;
import org.mockito.cglib.proxy.DispatcherGenerator;
import org.mockito.cglib.proxy.FixedValue;
import org.mockito.cglib.proxy.FixedValueGenerator;
import org.mockito.cglib.proxy.InvocationHandler;
import org.mockito.cglib.proxy.InvocationHandlerGenerator;
import org.mockito.cglib.proxy.LazyLoader;
import org.mockito.cglib.proxy.LazyLoaderGenerator;
import org.mockito.cglib.proxy.MethodInterceptor;
import org.mockito.cglib.proxy.MethodInterceptorGenerator;
import org.mockito.cglib.proxy.NoOp;
import org.mockito.cglib.proxy.NoOpGenerator;
import org.mockito.cglib.proxy.ProxyRefDispatcher;

class CallbackInfo {
    private Class cls;
    private CallbackGenerator generator;
    private Type type;
    private static final CallbackInfo[] CALLBACKS = new CallbackInfo[]{new CallbackInfo(NoOp.class, NoOpGenerator.INSTANCE), new CallbackInfo(MethodInterceptor.class, MethodInterceptorGenerator.INSTANCE), new CallbackInfo(InvocationHandler.class, InvocationHandlerGenerator.INSTANCE), new CallbackInfo(LazyLoader.class, LazyLoaderGenerator.INSTANCE), new CallbackInfo(Dispatcher.class, DispatcherGenerator.INSTANCE), new CallbackInfo(FixedValue.class, FixedValueGenerator.INSTANCE), new CallbackInfo(ProxyRefDispatcher.class, DispatcherGenerator.PROXY_REF_INSTANCE)};

    public static Type[] determineTypes(Class[] callbackTypes) {
        Type[] types = new Type[callbackTypes.length];
        int i = 0;
        while (i < types.length) {
            types[i] = CallbackInfo.determineType(callbackTypes[i]);
            ++i;
        }
        return types;
    }

    public static Type[] determineTypes(Callback[] callbacks) {
        Type[] types = new Type[callbacks.length];
        int i = 0;
        while (i < types.length) {
            types[i] = CallbackInfo.determineType(callbacks[i]);
            ++i;
        }
        return types;
    }

    public static CallbackGenerator[] getGenerators(Type[] callbackTypes) {
        CallbackGenerator[] generators = new CallbackGenerator[callbackTypes.length];
        int i = 0;
        while (i < generators.length) {
            generators[i] = CallbackInfo.getGenerator(callbackTypes[i]);
            ++i;
        }
        return generators;
    }

    private CallbackInfo(Class cls, CallbackGenerator generator) {
        this.cls = cls;
        this.generator = generator;
        this.type = Type.getType(cls);
    }

    private static Type determineType(Callback callback) {
        if (callback == null) {
            throw new IllegalStateException("Callback is null");
        }
        return CallbackInfo.determineType(callback.getClass());
    }

    private static Type determineType(Class callbackType) {
        Class cur = null;
        int i = 0;
        while (i < CALLBACKS.length) {
            CallbackInfo info = CALLBACKS[i];
            if (info.cls.isAssignableFrom(callbackType)) {
                if (cur != null) {
                    throw new IllegalStateException("Callback implements both " + cur + " and " + info.cls);
                }
                cur = info.cls;
            }
            ++i;
        }
        if (cur == null) {
            throw new IllegalStateException("Unknown callback type " + callbackType);
        }
        return Type.getType(cur);
    }

    private static CallbackGenerator getGenerator(Type callbackType) {
        int i = 0;
        while (i < CALLBACKS.length) {
            CallbackInfo info = CALLBACKS[i];
            if (info.type.equals(callbackType)) {
                return info.generator;
            }
            ++i;
        }
        throw new IllegalStateException("Unknown callback type " + callbackType);
    }
}

