/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.wizard;

import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.jboss.tools.project.examples.model.IProjectExampleSite;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.ProjectExampleCategory;
import org.jboss.tools.project.examples.model.ProjectModelElement;

public class SiteFilter
extends ViewerFilter {
    private String site = ProjectExamplesActivator.ALL_SITES;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!(element instanceof ProjectModelElement)) {
            return false;
        }
        if (this.site.equals(ProjectExamplesActivator.ALL_SITES)) {
            return true;
        }
        if (element instanceof ProjectExampleCategory) {
            ProjectExampleCategory category = (ProjectExampleCategory)element;
            IProjectExampleSite categorySite = category.getSite();
            if (categorySite == null || !this.site.equals(categorySite.getName())) {
                return false;
            }
            List<ProjectExample> projects = category.getProjects();
            for (ProjectExample project : projects) {
                IProjectExampleSite projectSite = project.getSite();
                if (projectSite == null || !this.site.equals(projectSite.getName())) continue;
                return true;
            }
            return false;
        }
        ProjectModelElement model = (ProjectModelElement)element;
        return model.getSite() != null && this.site.equals(model.getSite().getName());
    }

    public void setSite(String site) {
        this.site = site;
    }
}

