/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.preferences;

import java.util.HashSet;
import java.util.Set;
import org.jboss.tools.project.examples.Messages;
import org.jboss.tools.project.examples.model.IProjectExampleSite;
import org.jboss.tools.project.examples.model.ProjectExampleSite;
import org.jboss.tools.project.examples.model.ProjectExampleUtil;
import org.jboss.tools.project.examples.model.SiteCategory;

public class Sites {
    private SiteCategory[] siteCategories;
    private SiteCategory userSite;
    private SiteCategory runtimeSite;
    private Set<IProjectExampleSite> sites;

    public SiteCategory[] getSiteCategories() {
        if (this.siteCategories == null) {
            this.siteCategories = new SiteCategory[3];
            this.userSite = new SiteCategory(Messages.Sites_User_sites);
            Set<IProjectExampleSite> userSites = ProjectExampleUtil.getUserSites();
            this.userSite.setSites(userSites);
            this.siteCategories[0] = this.userSite;
            SiteCategory pluginSite = new SiteCategory(Messages.Sites_Plugin_provided_sites);
            Set<IProjectExampleSite> pluginSites = ProjectExampleUtil.getPluginSites();
            pluginSite.setSites(pluginSites);
            this.siteCategories[1] = pluginSite;
            this.runtimeSite = new SiteCategory(Messages.Sites_Runtime_sites);
            Set<IProjectExampleSite> runtimeSites = ProjectExampleUtil.getRuntimeSites(true);
            this.runtimeSite.setSites(runtimeSites);
            this.siteCategories[2] = this.runtimeSite;
            this.sites = new HashSet<IProjectExampleSite>();
            this.sites.addAll(pluginSites);
            this.sites.addAll(userSites);
            this.sites.addAll(runtimeSites);
        }
        return this.siteCategories;
    }

    public void remove(IProjectExampleSite site) {
        this.userSite.getSites().remove(site);
        this.sites.remove(site);
    }

    public void add(ProjectExampleSite site) {
        this.userSite.getSites().add(site);
        this.sites.add(site);
    }

    public Set<IProjectExampleSite> getSites() {
        return this.sites;
    }

    public Set<IProjectExampleSite> getUserSites() {
        return this.userSite.getSites();
    }

    public Set<IProjectExampleSite> getRuntimeSites() {
        return this.runtimeSite.getSites();
    }
}

