/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.offline;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.project.examples.ProjectExamplesActivator;

public class OfflineUtil {
    private static final String CURRENT_VERSION;

    static {
        String version = (String)Platform.getBundle((String)"org.jboss.tools.project.examples").getHeaders().get("Bundle-Version");
        CURRENT_VERSION = version.replace('-', '_');
    }

    private OfflineUtil() {
    }

    public static File getGoOfflineScript() {
        File baseDir = ProjectExamplesActivator.getDefault().getStateLocation().toFile();
        File offlineScript = new File(baseDir, "offline/go_offline_" + CURRENT_VERSION + ".groovy");
        return offlineScript;
    }

    public static File getOfflineFile(URL url) {
        String offlineCachePath = ProjectExamplesActivator.getDefault().getPreferenceStore().getString("projectExamplesOfflineDirectory");
        File cachedFile = new File(offlineCachePath, url.getFile());
        return cachedFile.exists() ? cachedFile : null;
    }

    public static boolean isOfflineEnabled() {
        return ProjectExamplesActivator.getDefault().getPreferenceStore().getBoolean("projectExamplesOfflineEnabled");
    }
}

