/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.internal.discovery;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptor;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryFeedbackJob;
import org.eclipse.mylyn.internal.discovery.ui.InstalledItem;
import org.eclipse.mylyn.internal.discovery.ui.UninstallRequest;
import org.eclipse.mylyn.internal.discovery.ui.wizards.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.statushandlers.StatusManager;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.jboss.tools.project.examples.internal.discovery.PrepareInstallProfileJob;
import org.jboss.tools.project.examples.internal.discovery.PrepareUninstallProfileJob;
import org.jboss.tools.usage.event.UsageEventType;
import org.jboss.tools.usage.event.UsageReporter;

public class JBossDiscoveryUi {
    private static final String MPC_CORE_PLUGIN_ID = "org.eclipse.epp.mpc.core";

    public static boolean install(List<ConnectorDescriptor> descriptors, IRunnableContext context) {
        try {
            PrepareInstallProfileJob runner = JBossDiscoveryUi.createInstallJob(descriptors);
            context.run(true, true, (IRunnableWithProgress)runner);
            new DiscoveryFeedbackJob(descriptors).schedule();
            JBossDiscoveryUi.recordInstalled(descriptors);
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, "org.jboss.tools.project.examples", NLS.bind((String)Messages.ConnectorDiscoveryWizard_installProblems, (Object[])new Object[]{e.getCause().getMessage()}), e.getCause());
            StatusManager.getManager().handle((IStatus)status, 7);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public static boolean uninstall(final List<ConnectorDescriptor> descriptors, IRunnableContext context, boolean fork) {
        try {
            UninstallRequest request = new UninstallRequest(){

                public boolean select(InstalledItem item) {
                    for (ConnectorDescriptor desc : descriptors) {
                        for (String id : desc.getInstallableUnits()) {
                            if (!id.equals(desc.getId())) continue;
                            return true;
                        }
                    }
                    return false;
                }
            };
            PrepareUninstallProfileJob runner = new PrepareUninstallProfileJob(descriptors, request);
            context.run(fork, true, (IRunnableWithProgress)runner);
            DiscoveryFeedbackJob discoveryFeedbackJob = new DiscoveryFeedbackJob(descriptors);
            discoveryFeedbackJob.schedule();
            if (!fork) {
                discoveryFeedbackJob.join();
                return discoveryFeedbackJob.getResult().isOK();
            }
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, "org.jboss.tools.project.examples", NLS.bind((String)Messages.ConnectorDiscoveryWizard_installProblems, (Object[])new Object[]{e.getCause().getMessage()}), e.getCause());
            StatusManager.getManager().handle((IStatus)status, 7);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public static PrepareInstallProfileJob createInstallJob(List<ConnectorDescriptor> descriptors) {
        return new PrepareInstallProfileJob(descriptors);
    }

    private static void recordInstalled(List<ConnectorDescriptor> descriptors) {
        StringBuilder sb = new StringBuilder();
        for (ConnectorDescriptor descriptor : descriptors) {
            UsageEventType eventType = ProjectExamplesActivator.getDefault().getInstallEventType();
            UsageReporter.getInstance().trackEvent(eventType.event(descriptor.getId()));
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(descriptor.getId());
        }
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.mylyn.discovery.ui");
        store.putValue("lastInstalled", sb.toString());
        try {
            store.save();
        }
        catch (IOException iOException) {}
    }
}

