/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.internal.discovery;

import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.discovery.core.model.AbstractDiscoverySource;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDiscoveryExtensionReader;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryCategory;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryCertification;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.eclipse.mylyn.internal.discovery.core.model.ValidationException;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.project.examples.internal.discovery.ExpressionBasedDiscoveryConnector;

public abstract class ExpressionBasedDiscoveryExtensionProcessor {
    protected void processExtensions(IProgressMonitor monitor, IExtension[] extensions, List<DiscoveryConnector> connectors, List<DiscoveryCategory> categories, List<DiscoveryCertification> certifications) {
        monitor.beginTask("Processing extensions", extensions.length == 0 ? 1 : extensions.length);
        try {
            ConnectorDiscoveryExtensionReader extensionReader = new ConnectorDiscoveryExtensionReader();
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                AbstractDiscoverySource discoverySource = this.computeDiscoverySource(extension.getContributor());
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    block14: {
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        if (monitor.isCanceled()) {
                            return;
                        }
                        try {
                            if ("connectorDescriptor".equals(element.getName())) {
                                ExpressionBasedDiscoveryConnector descriptor = (ExpressionBasedDiscoveryConnector)extensionReader.readConnectorDescriptor(element, ExpressionBasedDiscoveryConnector.class);
                                descriptor.setSource(discoverySource);
                                connectors.add(descriptor);
                                break block14;
                            }
                            if ("connectorCategory".equals(element.getName())) {
                                DiscoveryCategory category = (DiscoveryCategory)extensionReader.readConnectorCategory(element, DiscoveryCategory.class);
                                category.setSource(discoverySource);
                                if (!discoverySource.getPolicy().isPermitCategories()) {
                                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.discovery.core", NLS.bind((String)"Cannot create category '{0}' with id '{1}' from {2}: disallowed", (Object[])new Object[]{category.getName(), category.getId(), element.getContributor().getName()}), null));
                                } else {
                                    categories.add(category);
                                }
                                break block14;
                            }
                            if ("certification".equals(element.getName())) {
                                DiscoveryCertification certification = (DiscoveryCertification)extensionReader.readCertification(element, DiscoveryCertification.class);
                                certification.setSource(discoverySource);
                                certifications.add(certification);
                                break block14;
                            }
                            throw new ValidationException(NLS.bind((String)"Unexpected element {0}", (Object)element.getName()));
                        }
                        catch (ValidationException e) {
                            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.discovery.core", NLS.bind((String)"{0}: {1}", (Object)element.getContributor().getName(), (Object)e.getMessage()), (Throwable)e));
                        }
                    }
                    ++n4;
                }
                monitor.worked(1);
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    public abstract AbstractDiscoverySource computeDiscoverySource(IContributor var1);
}

