/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.fixes;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.project.examples.Messages;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.jboss.tools.project.examples.fixes.ProjectExamplesFix;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.ProjectFix;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.osgi.service.prefs.BackingStoreException;

public class SeamRuntimeFix
implements ProjectExamplesFix {
    @Override
    public boolean canFix(ProjectExample project, ProjectFix fix) {
        if (!"seam".equals(fix.getType())) {
            return false;
        }
        return this.getBestRuntime(project, fix) != null;
    }

    private SeamRuntime getBestRuntime(ProjectExample project, ProjectFix fix) {
        String allowedVersions = fix.getProperties().get("allowed-versions");
        if (allowedVersions == null) {
            ProjectExamplesActivator.log(NLS.bind((String)Messages.SeamRuntimeFix_Invalid_seam_runtime_fix, (Object)project.getName()));
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(allowedVersions, ",");
        while (tokenizer.hasMoreTokens()) {
            String allowedVersion = tokenizer.nextToken().trim();
            if (allowedVersion.length() <= 0) continue;
            SeamRuntime[] seamRuntimes = SeamRuntimeManager.getInstance().getRuntimes();
            if (seamRuntimes == null) {
                return null;
            }
            if (seamRuntimes.length > 0 && "any".equals(allowedVersion)) {
                return seamRuntimes[0];
            }
            int i = 0;
            while (i < seamRuntimes.length) {
                SeamRuntime seamRuntime = seamRuntimes[i];
                if (seamRuntime.getVersion().toString().equals(allowedVersion.substring(0, 3))) {
                    return seamRuntime;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public boolean fix(ProjectExample project, ProjectFix fix, IProgressMonitor monitor) {
        if (!this.canFix(project, fix)) {
            return false;
        }
        IProject[] eclipseProjects = ProjectExamplesActivator.getEclipseProject(project, fix);
        if (eclipseProjects.length == 0) {
            return false;
        }
        boolean ret = true;
        int i = 0;
        while (i < eclipseProjects.length) {
            IProject eclipseProject = eclipseProjects[i];
            if (!this.fix(project, fix, eclipseProject)) {
                ret = false;
            }
            ++i;
        }
        return ret;
    }

    private boolean fix(ProjectExample project, ProjectFix fix, IProject eclipseProject) {
        SeamRuntime seamRuntime;
        IEclipsePreferences prefs = SeamCorePlugin.getSeamPreferences((IProject)eclipseProject);
        String seamRuntimeName = prefs.get("seam.runtime.name", null);
        SeamRuntime[] seamRuntimes = SeamRuntimeManager.getInstance().getRuntimes();
        if (seamRuntimeName != null) {
            int i1 = 0;
            while (i1 < seamRuntimes.length) {
                if (seamRuntimeName.equals(seamRuntimes[i1].getName())) {
                    return true;
                }
                ++i1;
            }
        }
        if ((seamRuntime = this.getBestRuntime(project, fix)) != null) {
            prefs.put("seam.runtime.name", seamRuntime.getName());
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                ProjectExamplesActivator.log(e);
                return false;
            }
            return true;
        }
        return false;
    }
}

