/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.configurators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.foundation.core.properties.IPropertiesProvider;
import org.jboss.tools.foundation.core.properties.PropertiesHelper;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.jboss.tools.project.examples.configurators.IJBossCentralConfigurator;

public class DefaultJBossCentralConfigurator
implements IJBossCentralConfigurator {
    private static final List<String> WIZARD_IDS;
    private static final String TWITTER_LINK = "http://twitter.com/jbosstools";
    private static final String BLOGS_URL = "http://planet.jboss.org/feeds/blogs";
    private static final String BUZZ_URL = "http://planet.jboss.org/feeds/buzz";
    private static final String NEWS_URL = "http://planet.jboss.org/feeds/news";
    private static final String DOCUMENTATION_URL = "http://www.jboss.org/tools/docs/reference";
    private Image headerImage;

    static {
        ArrayList<String> wizardIds = new ArrayList<String>();
        wizardIds.add("org.jboss.tools.central.wizards.NewHtml5ProjectWizard");
        wizardIds.add("org.jboss.ide.eclipse.as.openshift.express.ui.wizard.createNewApplicationWizard");
        wizardIds.add("org.jboss.tools.central.wizards.NewJavaeeWarProjectWizard");
        wizardIds.add("org.jboss.tools.central.wizards.NewRichfacesProjectWizard");
        wizardIds.add("org.jboss.tools.central.wizards.NewGwtProjectWizard");
        wizardIds.add("org.jboss.tools.central.wizards.NewSpringMvcProjectWizard");
        WIZARD_IDS = Collections.unmodifiableList(wizardIds);
    }

    @Override
    public String[] getMainToolbarCommandIds() {
        return new String[]{"org.jboss.tools.central.openJBossToolsHome", "org.jboss.tools.central.favoriteAtEclipseMarketplace"};
    }

    @Override
    public String getJBossDiscoveryDirectory() {
        String directory = System.getProperty("jboss.discovery.directory.url", null);
        if (directory == null) {
            IPropertiesProvider pp = PropertiesHelper.getPropertiesProvider();
            directory = pp.getValue("jboss.discovery.directory.url");
        }
        return directory;
    }

    @Override
    public String getTwitterLink() {
        return TWITTER_LINK;
    }

    @Override
    public String getBlogsUrl() {
        return BLOGS_URL;
    }

    @Override
    public String getNewsUrl() {
        return NEWS_URL;
    }

    @Override
    public String getBuzzUrl() {
        return PropertiesHelper.getPropertiesProvider().getValue("buzz.feed.url", BUZZ_URL);
    }

    @Override
    public List<String> getWizardIds() {
        return WIZARD_IDS;
    }

    @Override
    public String getDocumentationUrl() {
        return DOCUMENTATION_URL;
    }

    @Override
    public Image getHeaderImage() {
        if (this.headerImage == null) {
            this.headerImage = ProjectExamplesActivator.getDefault().getImage("/icons/jboss.png");
        }
        return this.headerImage;
    }
}

