/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.xml.ui.xpl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jboss.tools.common.text.xml.ui.xpl.ISelectionListenerWithSM;
import org.jboss.tools.common.text.xml.ui.xpl.UIMessages;

public class SelectionListenerWithSMManager {
    private static SelectionListenerWithSMManager fgDefault;
    private Map fListenerGroups = new HashMap();

    public static SelectionListenerWithSMManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new SelectionListenerWithSMManager();
        }
        return fgDefault;
    }

    private SelectionListenerWithSMManager() {
    }

    public void addListener(ITextEditor part, ISelectionListenerWithSM listener) {
        PartListenerGroup partListener = (PartListenerGroup)this.fListenerGroups.get(part);
        if (partListener == null) {
            partListener = new PartListenerGroup(part);
            this.fListenerGroups.put(part, partListener);
        }
        partListener.install(listener);
    }

    public void removeListener(ITextEditor part, ISelectionListenerWithSM listener) {
        PartListenerGroup partListener = (PartListenerGroup)this.fListenerGroups.get(part);
        if (partListener != null) {
            partListener.uninstall(listener);
            if (partListener.isEmpty()) {
                this.fListenerGroups.remove(part);
            }
        }
    }

    public void forceSelectionChange(ITextEditor part, ITextSelection selection) {
        PartListenerGroup partListener = (PartListenerGroup)this.fListenerGroups.get(part);
        if (partListener != null) {
            partListener.firePostSelectionChanged(selection);
        }
    }

    private static final class PartListenerGroup {
        private ITextEditor fPart;
        private ISelectionChangedListener fSelectionListener;
        private ISelectionChangedListener fPostSelectionListener;
        private Job fCurrentJob;
        private ListenerList fSMListeners;

        public PartListenerGroup(ITextEditor part) {
            this.fPart = part;
            this.fCurrentJob = null;
            this.fSMListeners = new ListenerList();
            this.fSelectionListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelection selection = event.getSelection();
                    if (selection instanceof ITextSelection) {
                        PartListenerGroup.this.fireSelectionChanged((ITextSelection)selection);
                    }
                }
            };
            this.fPostSelectionListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelection selection = event.getSelection();
                    if (selection instanceof ITextSelection) {
                        PartListenerGroup.this.firePostSelectionChanged((ITextSelection)selection);
                    }
                }
            };
        }

        public boolean isEmpty() {
            return this.fSMListeners.isEmpty();
        }

        public void install(ISelectionListenerWithSM listener) {
            ISelectionProvider selectionProvider;
            if (this.isEmpty() && (selectionProvider = this.fPart.getSelectionProvider()) instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).addPostSelectionChangedListener(this.fPostSelectionListener);
                selectionProvider.addSelectionChangedListener(this.fSelectionListener);
            }
            this.fSMListeners.add((Object)listener);
        }

        public void uninstall(ISelectionListenerWithSM listener) {
            ISelectionProvider selectionProvider;
            this.fSMListeners.remove((Object)listener);
            if (this.isEmpty() && (selectionProvider = this.fPart.getSelectionProvider()) instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).removePostSelectionChangedListener(this.fPostSelectionListener);
                selectionProvider.removeSelectionChangedListener(this.fSelectionListener);
            }
        }

        public void fireSelectionChanged(ITextSelection selection) {
            if (this.fCurrentJob != null) {
                this.fCurrentJob.cancel();
            }
        }

        public void firePostSelectionChanged(final ITextSelection selection) {
            IStructuredModel model;
            if (this.fCurrentJob != null) {
                this.fCurrentJob.cancel();
            }
            if ((model = this.getStructuredModel()) == null) {
                return;
            }
            this.fCurrentJob = new Job(UIMessages.SelectionListenerWithSMManager_job_title){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IStatus run(IProgressMonitor monitor) {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    PartListenerGroup partListenerGroup = PartListenerGroup.this;
                    synchronized (partListenerGroup) {
                        return PartListenerGroup.this.inform(model, selection, monitor);
                    }
                }
            };
            this.fCurrentJob.setPriority(50);
            this.fCurrentJob.setSystem(true);
            this.fCurrentJob.schedule();
        }

        private IStructuredModel getStructuredModel() {
            if (this.fPart instanceof StructuredTextEditor) {
                return ((StructuredTextEditor)this.fPart).getModel();
            }
            return null;
        }

        protected IStatus inform(IStructuredModel model, ITextSelection selection, IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            try {
                if (model != null && !monitor.isCanceled()) {
                    Object[] listeners = this.fSMListeners.getListeners();
                    int i = 0;
                    while (i < listeners.length) {
                        ((ISelectionListenerWithSM)listeners[i]).selectionChanged((IEditorPart)this.fPart, selection, model);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        ++i;
                    }
                    return Status.OK_STATUS;
                }
            }
            catch (OperationCanceledException operationCanceledException) {}
            return Status.CANCEL_STATUS;
        }
    }
}

