/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;

public class FileUtils {
    private static final char SUFFIX_DELIMITER = '.';
    private static final String NUMERIC_SUFFIX_FILENAME_PATTERN = "{0}({1}){2}";
    private static final Pattern NUMERIC_SUFFIX_FILENAME_REGEX = Pattern.compile("(.*)\\([0-9]+\\)");
    private static final byte[] buffer = new byte[1024];

    public static boolean canRead(String path) {
        if (path == null) {
            return false;
        }
        return FileUtils.canRead(new File(path));
    }

    public static boolean canRead(File file) {
        if (file == null) {
            return false;
        }
        return file.canRead();
    }

    public static boolean exists(File file) {
        return file != null && file.exists();
    }

    public static boolean isDirectory(File file) {
        return file != null && file.isDirectory();
    }

    public static File getSystemTmpFolder() {
        String tmpFolder = System.getProperty("java.io.tmpdir");
        return new File(tmpFolder);
    }

    public static File getRandomTmpFolder() {
        String randomName = String.valueOf(System.currentTimeMillis());
        return new File(FileUtils.getSystemTmpFolder(), randomName);
    }

    public static void copy(File source, File destination, boolean overwrite) throws IOException {
        if (!FileUtils.exists(source) || destination == null) {
            return;
        }
        if (source.isDirectory()) {
            FileUtils.copyDirectory(source, destination, overwrite);
        } else {
            FileUtils.copyFile(source, destination, overwrite);
        }
    }

    private static void copyDirectory(File source, File destination, boolean overwrite) throws IOException {
        Assert.isLegal((source != null ? 1 : 0) != 0);
        Assert.isLegal((boolean)source.isDirectory());
        Assert.isLegal((destination != null ? 1 : 0) != 0);
        destination = FileUtils.getDestinationDirectory(source, destination);
        if (!destination.exists()) {
            destination.mkdir();
            FileUtils.copyPermissions(source, destination);
        }
        File[] fileArray = source.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File content = fileArray[n2];
            if (content.isDirectory()) {
                FileUtils.copyDirectory(content, new File(destination, content.getName()), overwrite);
            } else {
                FileUtils.copyFile(content, new File(destination, content.getName()), overwrite);
            }
            ++n2;
        }
    }

    private static File getDestinationDirectory(File source, File destination) {
        if (!source.getName().equals(destination.getName())) {
            destination = new File(destination, source.getName());
        }
        return destination;
    }

    private static void copyFile(File source, File destination, boolean overwrite) throws IOException {
        Assert.isLegal((source != null ? 1 : 0) != 0);
        Assert.isLegal((boolean)source.isFile());
        Assert.isLegal((destination != null ? 1 : 0) != 0);
        destination = FileUtils.getDestinationFile(source, destination);
        if (FileUtils.exists(destination) && !overwrite) {
            return;
        }
        if (FileUtils.isDirectory(destination)) {
            if (!overwrite) {
                return;
            }
            destination.delete();
        }
        FileUtils.writeTo(source, destination);
    }

    private static File getDestinationFile(File source, File destination) {
        if (!source.getName().equals(destination.getName())) {
            destination = new File(destination, source.getName());
        }
        return destination;
    }

    private static final void writeTo(File source, File destination) throws IOException {
        Assert.isLegal((source != null ? 1 : 0) != 0);
        Assert.isLegal((destination != null ? 1 : 0) != 0);
        FileUtils.writeTo(new BufferedInputStream(new FileInputStream(source)), destination);
        FileUtils.copyPermissions(source, destination);
    }

    public static final void writeTo(String content, File destination) throws FileNotFoundException {
        PrintWriter writer = new PrintWriter(destination);
        writer.write(content);
        writer.flush();
        writer.close();
    }

    private static final void writeTo(InputStream in, File destination) throws IOException {
        Assert.isLegal((in != null ? 1 : 0) != 0);
        Assert.isLegal((destination != null ? 1 : 0) != 0);
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(destination));
            int read = -1;
            while ((read = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
            ((OutputStream)out).flush();
        }
        catch (Throwable throwable) {
            FileUtils.silentlyClose(in);
            FileUtils.silentlyClose(out);
            throw throwable;
        }
        FileUtils.silentlyClose(in);
        FileUtils.silentlyClose(out);
    }

    private static void copyPermissions(File source, File destination) {
        Assert.isLegal((source != null ? 1 : 0) != 0);
        Assert.isLegal((destination != null ? 1 : 0) != 0);
        destination.setReadable(source.canRead());
        destination.setWritable(source.canWrite());
        destination.setExecutable(source.canExecute());
    }

    private static void silentlyClose(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {}
    }

    private static void silentlyClose(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static String getParent(String filepath) {
        String parent = null;
        if (!StringUtils.isEmpty(filepath)) {
            parent = new File(filepath).getParent();
        }
        return parent;
    }

    public static String getAvailableFilepath(String filepath) {
        if (StringUtils.isEmpty(filepath)) {
            return filepath;
        }
        String suffix = FileUtils.getSuffix(filepath);
        String filenameNoSuffix = FileUtils.stripNumericSuffix(FileUtils.stripFilesuffix(filepath));
        String newFilename = filepath;
        int i = 1;
        while (new File(newFilename).exists()) {
            newFilename = MessageFormat.format(NUMERIC_SUFFIX_FILENAME_PATTERN, filenameNoSuffix, i++, suffix);
        }
        return newFilename;
    }

    private static String stripNumericSuffix(String filepath) {
        if (StringUtils.isEmpty(filepath)) {
            return filepath;
        }
        Matcher matcher = NUMERIC_SUFFIX_FILENAME_REGEX.matcher(filepath);
        if (!matcher.matches() || matcher.groupCount() < 1) {
            return filepath;
        }
        return matcher.group(1);
    }

    public static String getSuffix(String filename) {
        if (StringUtils.isEmpty(filename)) {
            return filename;
        }
        int suffixStart = filename.indexOf(46);
        if (suffixStart < 0) {
            return filename;
        }
        return filename.substring(suffixStart);
    }

    public static String stripFilesuffix(String filename) {
        if (StringUtils.isEmpty(filename)) {
            return filename;
        }
        int suffixStart = filename.indexOf(46);
        if (suffixStart < 0) {
            return filename;
        }
        return filename.substring(0, suffixStart);
    }
}

