/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.util;

import java.util.ArrayList;
import java.util.Collection;

public class DiffUtils {
    private DiffUtils() {
    }

    public static <T> Diff<T> getDiff(Collection<T> source, Collection<T> target) {
        return new Diff<T>(source, target);
    }

    public static <T> Collection<T> getAdditions(Collection<T> source, Collection<T> target) {
        ArrayList<T> addedElements = new ArrayList<T>();
        for (T element : target) {
            if (source.contains(element)) continue;
            addedElements.add(element);
        }
        return addedElements;
    }

    public static <T> Collection<T> getRemovals(Collection<T> source, Collection<T> target) {
        ArrayList<T> removedElement = new ArrayList<T>();
        for (T element : source) {
            if (target.contains(element)) continue;
            removedElement.add(element);
        }
        return removedElement;
    }

    public static class Diff<T> {
        private Collection<T> additions;
        private Collection<T> removals;

        public Diff(Collection<T> source, Collection<T> target) {
            this.additions = DiffUtils.getAdditions(source, target);
            this.removals = DiffUtils.getRemovals(source, target);
        }

        public Collection<T> getAdditions() {
            return this.additions;
        }

        public Collection<T> getRemovals() {
            return this.removals;
        }
    }
}

