/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.server;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.OpenShiftException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.jboss.ide.eclipse.as.core.util.RegExUtils;
import org.jboss.ide.eclipse.as.core.util.ServerUtil;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.express.internal.core.OpenShiftCoreActivator;
import org.jboss.tools.openshift.express.internal.core.connection.Connection;
import org.jboss.tools.openshift.express.internal.core.connection.ConnectionURL;
import org.jboss.tools.openshift.express.internal.core.connection.ConnectionsModelSingleton;
import org.jboss.tools.openshift.express.internal.core.util.DeployFolder;
import org.jboss.tools.openshift.express.internal.core.util.StringUtils;
import org.osgi.service.prefs.BackingStoreException;

public class OpenShiftServerUtils {
    public static final String QUALIFIER = "org.jboss.tools.openshift.express.ui";
    public static final String ATTRIBUTE_DEPLOY_PROJECT = "org.jboss.tools.openshift.binary.deployProject";
    public static final String ATTRIBUTE_OVERRIDE_PROJECT_SETTINGS = "org.jboss.tools.openshift.project.override";
    public static final String ATTRIBUTE_DEPLOY_PROJECT_LEGACY = "org.jboss.tools.openshift.express.internal.core.server.binary.deployProject";
    public static final String ATTRIBUTE_REMOTE_NAME = "org.jboss.tools.openshift.express.internal.core.server.RemoteName";
    public static final String ATTRIBUTE_APPLICATION_NAME = "org.jboss.tools.openshift.express.internal.core.server.ApplicationName";
    public static final String ATTRIBUTE_APPLICATION_ID = "org.jboss.tools.openshift.express.internal.core.server.ApplicationId";
    public static final String ATTRIBUTE_DOMAIN = "org.jboss.tools.openshift.express.internal.core.server.Domain";
    public static final String ATTRIBUTE_USERNAME = "org.jboss.tools.openshift.express.internal.core.server.Username";
    public static final String ATTRIBUTE_DEPLOY_FOLDER_NAME = "org.jboss.tools.openshift.express.internal.core.server.DEPLOY_FOLDER_LOC";
    public static final String SETTING_REMOTE_NAME = "org.jboss.tools.openshift.RemoteName";
    public static final String SETTING_APPLICATION_NAME = "org.jboss.tools.openshift.ApplicationName";
    public static final String SETTING_APPLICATION_ID = "org.jboss.tools.openshift.ApplicationId";
    public static final String SETTING_DOMAIN_ID = "org.jboss.tools.openshift.Domain";
    public static final String SETTING_USERNAME = "org.jboss.tools.openshift.Username";
    public static final String SETTING_CONNECTIONURL = "org.jboss.tools.openshift.Connection";
    public static final String SETTING_DEPLOY_FOLDER_NAME = "org.jboss.tools.openshift.DeployFolder";
    public static final String ATTRIBUTE_REMOTE_NAME_DEFAULT = "origin";
    private static final String ATTRIBUTE_DEPLOY_FOLDER_JBOSS_DEFAULT = "deployments";
    public static final String PREFERENCE_IGNORE_CONTEXT_ROOT = "org.jboss.tools.openshift.express.internal.core.server.IgnoreContextRoot";
    public static final String OPENSHIFT_SERVER_TYPE = "org.jboss.tools.openshift.express.openshift.server.type";
    public static int SETTING_FROM_PROJECT = 1;
    public static int SETTING_FROM_SERVER = 2;
    public static int SETTING_EFFECTIVE_VALUE = 3;

    public static String getProjectAttribute(IProject project, String attributeName, String defaultVal) {
        if (project == null) {
            return defaultVal;
        }
        String qualifier = QUALIFIER;
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode(qualifier);
        return node.get(attributeName, defaultVal);
    }

    public static IApplication getApplication(IServerAttributes server) {
        Connection connection;
        String appName;
        block5: {
            appName = OpenShiftServerUtils.getApplicationName(server);
            if (StringUtils.isEmpty(appName)) {
                return null;
            }
            ConnectionURL connectionUrl = OpenShiftServerUtils.getConnectionUrl(server);
            if (connectionUrl == null) {
                return null;
            }
            try {
                connection = ConnectionsModelSingleton.getInstance().getConnectionByUrl(connectionUrl);
                if (connection != null) break block5;
                OpenShiftCoreActivator.pluginLog().logError(NLS.bind((String)"Could not find connection {0}", (Object)connectionUrl.toString()));
                return null;
            }
            catch (OpenShiftException e) {
                OpenShiftCoreActivator.pluginLog().logError(NLS.bind((String)"Failed to retrieve application ''{0}'' at url ''{1}}'", (Object)appName, (Object)connectionUrl), (Throwable)e);
                return null;
            }
        }
        IDomain domain = connection.getDomain(OpenShiftServerUtils.getDomainName(server));
        return connection.getApplication(appName, domain);
    }

    public static String getApplicationName(IServerAttributes attributes) {
        return OpenShiftServerUtils.getProjectAttribute(OpenShiftServerUtils.getDeployProject(attributes), SETTING_APPLICATION_NAME, attributes.getAttribute(ATTRIBUTE_APPLICATION_NAME, null));
    }

    public static String getApplicationId(IServerAttributes attributes) {
        return OpenShiftServerUtils.getProjectAttribute(OpenShiftServerUtils.getDeployProject(attributes), SETTING_APPLICATION_ID, attributes.getAttribute(ATTRIBUTE_APPLICATION_ID, null));
    }

    public static String getDomainName(IServerAttributes attributes) {
        return OpenShiftServerUtils.getProjectAttribute(OpenShiftServerUtils.getDeployProject(attributes), SETTING_DOMAIN_ID, attributes.getAttribute(ATTRIBUTE_DOMAIN, null));
    }

    private static String getUsername(IServerAttributes attributes) {
        return OpenShiftServerUtils.getProjectAttribute(OpenShiftServerUtils.getDeployProject(attributes), SETTING_USERNAME, attributes.getAttribute(ATTRIBUTE_USERNAME, null));
    }

    public static ConnectionURL getConnectionUrl(IServerAttributes attributes) {
        try {
            String connectionUrlString = OpenShiftServerUtils.getProjectAttribute(OpenShiftServerUtils.getDeployProject(attributes), SETTING_CONNECTIONURL, null);
            if (!StringUtils.isEmpty(connectionUrlString)) {
                return ConnectionURL.forURL(connectionUrlString);
            }
            String username = OpenShiftServerUtils.getUsername(attributes);
            if (!StringUtils.isEmpty(username)) {
                return ConnectionURL.forUsername(username);
            }
        }
        catch (UnsupportedEncodingException e) {
            OpenShiftCoreActivator.pluginLog().logError(NLS.bind((String)"Could not get connection url for user {0}", (Object)attributes.getName()), (Throwable)e);
        }
        catch (MalformedURLException e) {
            OpenShiftCoreActivator.pluginLog().logError(NLS.bind((String)"Could not get connection url for user {0}", (Object)attributes.getName()), (Throwable)e);
        }
        return null;
    }

    public static String getDeployFolder(IServerAttributes attributes) {
        return OpenShiftServerUtils.getDeployFolder(attributes, OpenShiftServerUtils.getApplication(attributes));
    }

    public static String getDeployFolder(IServerAttributes attributes, IApplication application) {
        return OpenShiftServerUtils.getDeployFolder(attributes, OpenShiftServerUtils.getDefaultDeployFolder(application));
    }

    private static String getDeployFolder(IServerAttributes attributes, String defaultDeployFolder) {
        if (OpenShiftServerUtils.getOverridesProject(attributes)) {
            return attributes.getAttribute(ATTRIBUTE_DEPLOY_FOLDER_NAME, defaultDeployFolder);
        }
        return OpenShiftServerUtils.getProjectAttribute(OpenShiftServerUtils.getDeployProject(attributes), SETTING_DEPLOY_FOLDER_NAME, defaultDeployFolder);
    }

    public static String getDefaultDeployFolder(IServerAttributes server) {
        return OpenShiftServerUtils.getDefaultDeployFolder(OpenShiftServerUtils.getApplication(server));
    }

    public static String getDefaultDeployFolder(IApplication application) {
        Assert.isNotNull((Object)application);
        DeployFolder deployFolder = DeployFolder.getByCartridgeName(application.getCartridge().getName());
        if (deployFolder == null) {
            return null;
        }
        return deployFolder.getDeployFolder();
    }

    public static IContainer getDeployFolderResource(String deployFolder, IProject project) {
        if (!StringUtils.isEmpty(deployFolder)) {
            return (IContainer)project.findMember((IPath)new Path(deployFolder));
        }
        return project;
    }

    public static String getRemoteName(IServerAttributes attributes) {
        if (OpenShiftServerUtils.getOverridesProject(attributes)) {
            return attributes.getAttribute(ATTRIBUTE_REMOTE_NAME, ATTRIBUTE_REMOTE_NAME_DEFAULT);
        }
        return OpenShiftServerUtils.getProjectAttribute(OpenShiftServerUtils.getDeployProject(attributes), SETTING_REMOTE_NAME, ATTRIBUTE_REMOTE_NAME_DEFAULT);
    }

    public static String getDeployFolder(IServerAttributes attributes, int fromWhere) {
        String fromServer = attributes.getAttribute(ATTRIBUTE_DEPLOY_FOLDER_NAME, null);
        if (fromWhere == SETTING_FROM_SERVER) {
            return fromServer;
        }
        String fromProject = OpenShiftServerUtils.getProjectAttribute(OpenShiftServerUtils.getDeployProject(attributes), SETTING_DEPLOY_FOLDER_NAME, null);
        if (fromWhere == SETTING_FROM_PROJECT) {
            return fromProject;
        }
        if (OpenShiftServerUtils.getOverridesProject(attributes)) {
            return fromServer == null ? ATTRIBUTE_DEPLOY_FOLDER_JBOSS_DEFAULT : fromServer;
        }
        return fromProject == null ? ATTRIBUTE_DEPLOY_FOLDER_JBOSS_DEFAULT : fromProject;
    }

    public static String getRemoteName(IServerAttributes attributes, int fromWhere) {
        String fromServer = attributes.getAttribute(ATTRIBUTE_REMOTE_NAME, null);
        if (fromWhere == SETTING_FROM_SERVER) {
            return fromServer;
        }
        String fromProject = OpenShiftServerUtils.getProjectAttribute(OpenShiftServerUtils.getDeployProject(attributes), SETTING_REMOTE_NAME, null);
        if (fromWhere == SETTING_FROM_PROJECT) {
            return fromProject;
        }
        if (OpenShiftServerUtils.getOverridesProject(attributes)) {
            return fromServer == null ? ATTRIBUTE_REMOTE_NAME_DEFAULT : fromServer;
        }
        return fromProject == null ? ATTRIBUTE_REMOTE_NAME_DEFAULT : fromProject;
    }

    public static String getDeployProjectName(IServerAttributes attributes) {
        return attributes.getAttribute(ATTRIBUTE_DEPLOY_PROJECT, attributes.getAttribute(ATTRIBUTE_DEPLOY_PROJECT_LEGACY, null));
    }

    public static IProject getDeployProject(IServerAttributes attributes) {
        String name = OpenShiftServerUtils.getDeployProjectName(attributes);
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    public static boolean getIgnoresContextRoot(IServerAttributes server) {
        return server.getAttribute(PREFERENCE_IGNORE_CONTEXT_ROOT, true);
    }

    public static boolean getOverridesProject(IServerAttributes server) {
        return server.getAttribute(ATTRIBUTE_OVERRIDE_PROJECT_SETTINGS, false);
    }

    public static IServer setIgnoresContextRoot(IServerAttributes server, boolean val) throws CoreException {
        IServerWorkingCopy wc = server.createWorkingCopy();
        wc.setAttribute(ATTRIBUTE_REMOTE_NAME, val);
        return wc.save(false, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IServer fillServerWithOpenShiftDetails(IServer server, String deployProject, String remote, String serverName, IApplication application, IDomain domain) throws CoreException {
        ServerWorkingCopy wc = (ServerWorkingCopy)server.createWorkingCopy();
        String deployFolder = OpenShiftServerUtils.getDefaultDeployFolder(application);
        String host = OpenShiftServerUtils.getHost(application);
        String applicationName = OpenShiftServerUtils.getApplicationName(application);
        String domainId = OpenShiftServerUtils.getDomainId(domain);
        OpenShiftServerUtils.fillServerWithOpenShiftDetails((IServerWorkingCopy)wc, serverName, host, deployProject, deployFolder, remote, applicationName, domainId);
        IServer saved = wc.save(true, (IProgressMonitor)new NullProgressMonitor());
        return saved;
    }

    public static void fillServerWithOpenShiftDetails(IServerWorkingCopy wc, String serverName, IProject deployProject, String deployFolder, String remote, IApplication application, IDomain domain) {
        String host = OpenShiftServerUtils.getHost(application);
        String deployProjectName = OpenShiftServerUtils.getDeployProjectName(deployProject);
        String applicationName = OpenShiftServerUtils.getApplicationName(application);
        String domainId = OpenShiftServerUtils.getDomainId(domain);
        OpenShiftServerUtils.fillServerWithOpenShiftDetails(wc, serverName, host, deployProjectName, deployFolder, remote, applicationName, domainId);
    }

    private static String getDeployProjectName(IProject deployProject) {
        String deployProjectName = null;
        if (deployProject != null) {
            deployProjectName = deployProject.getName();
        }
        return deployProjectName;
    }

    private static String getHost(IApplication application) {
        String host = null;
        if (application != null) {
            host = application.getApplicationUrl();
        }
        return host;
    }

    private static String getApplicationName(IApplication application) {
        String name = null;
        if (application != null) {
            name = application.getName();
        }
        return name;
    }

    private static String getDomainId(IDomain domain) {
        String id = null;
        if (domain != null) {
            id = domain.getId();
        }
        return id;
    }

    public static void fillServerWithOpenShiftDetails(IServerWorkingCopy wc, String serverName, String host, String deployProject, String deployFolder, String remote, String applicationName, String domainName) {
        wc.setHost(OpenShiftServerUtils.trimHost(host));
        wc.setAttribute("org.jboss.ide.eclipse.as.core.server.serverMode", "openshift");
        wc.setAttribute(ATTRIBUTE_DEPLOY_PROJECT, deployProject);
        wc.setAttribute(ATTRIBUTE_DOMAIN, domainName);
        wc.setAttribute(ATTRIBUTE_APPLICATION_NAME, applicationName);
        wc.setAttribute(ATTRIBUTE_DEPLOY_FOLDER_NAME, deployFolder);
        wc.setAttribute(ATTRIBUTE_REMOTE_NAME, remote);
        ((ServerWorkingCopy)wc).setAutoPublishSetting(1);
        wc.setAttribute("org.jboss.ide.eclipse.as.core.server.IGNORE_LAUNCH_COMMANDS", String.valueOf(Boolean.TRUE));
        wc.setAttribute("org.jboss.ide.eclipse.as.core.server.webPort", 80);
        wc.setAttribute("org.jboss.ide.eclipse.as.core.server.webPortAutoDetect", "false");
        wc.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectoryType", "custom");
        wc.setAttribute("org.jboss.ide.eclipse.as.core.server.zipDeploymentsPreference", true);
        wc.setName(serverName);
    }

    public static String getDefaultServerName(IApplication application) {
        if (application == null) {
            return null;
        }
        return OpenShiftServerUtils.getDefaultServerName(application.getName());
    }

    public static String getDefaultServerName(String baseName) {
        return ServerUtil.getDefaultServerName((String)(String.valueOf(baseName) + " at OpenShift"));
    }

    public static boolean isDefaultName(String serverName) {
        if (StringUtils.isEmpty(serverName)) {
            return false;
        }
        return serverName.startsWith("ApplicationName");
    }

    protected static String trimHost(String url) {
        if (StringUtils.isEmpty(url)) {
            return url;
        }
        if (url.indexOf("://") != -1) {
            url = url.substring(url.indexOf("://") + 3);
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static IServer createServer(String serverID) throws CoreException {
        return OpenShiftServerUtils.createServer(ServerCore.findServerType((String)serverID), serverID);
    }

    public static IServer createServer(IServerType serverType, String serverName) throws CoreException {
        IServerWorkingCopy serverWC = serverType.createServer(null, null, (IProgressMonitor)new NullProgressMonitor());
        serverWC.setRuntime(null);
        serverWC.setName(serverName);
        serverWC.setServerConfiguration(null);
        serverWC.setAttribute("org.jboss.ide.eclipse.as.core.server.serverMode", "openshift");
        return serverWC.save(true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static boolean isOpenShiftRuntime(IServerAttributes server) {
        String serverTypeId = server.getServerType().getId();
        return OPENSHIFT_SERVER_TYPE.equals(serverTypeId);
    }

    public static boolean isInOpenshiftBehaviourMode(IServer server) {
        String mode = server.getAttribute("org.jboss.ide.eclipse.as.core.server.serverMode", null);
        return "openshift".equals(mode);
    }

    public static IApplication findApplicationForProject(IProject p, List<IApplication> applications) throws OpenShiftException, CoreException {
        List uris = EGitUtils.getDefaultRemoteURIs((IProject)p);
        for (IApplication a : applications) {
            String gitUri = a.getGitUrl();
            Iterator j = uris.iterator();
            while (j.hasNext()) {
                String projUri = ((URIish)j.next()).toPrivateString();
                if (!projUri.equals(gitUri)) continue;
                return a;
            }
        }
        return null;
    }

    public static IProject[] findProjectsForApplication(IApplication application) {
        if (application == null) {
            return null;
        }
        ArrayList<IProject> results = new ArrayList<IProject>();
        String gitUri = application.getGitUrl();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (OpenShiftServerUtils.hasGitUri(gitUri, projects[i])) {
                results.add(projects[i]);
            }
            ++i;
        }
        return results.toArray(new IProject[results.size()]);
    }

    private static boolean hasGitUri(String gitURI, IProject project) {
        try {
            Pattern gitURIPattern = Pattern.compile(RegExUtils.escapeRegex((String)gitURI));
            Repository repository = EGitUtils.getRepository((IProject)project);
            String remoteName = OpenShiftServerUtils.getProjectAttribute(project, SETTING_REMOTE_NAME, null);
            if (!StringUtils.isEmptyOrNull(remoteName)) {
                return EGitUtils.hasRemoteUrl((Pattern)gitURIPattern, (RemoteConfig)EGitUtils.getRemoteByName((String)remoteName, (Repository)repository));
            }
            return EGitUtils.hasRemoteUrl((Pattern)gitURIPattern, (Repository)repository);
        }
        catch (CoreException ce) {
            OpenShiftCoreActivator.pluginLog().logError(NLS.bind((String)"Could not look up remotes for project {0}", (Object)project), (Throwable)ce);
            return false;
        }
    }

    public static IProject[] findAllSuitableOpenshiftProjects() {
        ArrayList<IProject> results = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (EGitUtils.getRepository((IProject)projects[i]) != null && OpenShiftServerUtils.hasOpenShiftSettings(projects[i])) {
                results.add(projects[i]);
            }
            ++i;
        }
        return results.toArray(new IProject[results.size()]);
    }

    private static boolean hasOpenShiftSettings(IProject project) {
        String appName = OpenShiftServerUtils.getProjectAttribute(project, SETTING_APPLICATION_NAME, null);
        String appId = OpenShiftServerUtils.getProjectAttribute(project, SETTING_APPLICATION_ID, null);
        String domain = OpenShiftServerUtils.getProjectAttribute(project, SETTING_DOMAIN_ID, null);
        String connectionUrl = OpenShiftServerUtils.getProjectAttribute(project, SETTING_CONNECTIONURL, null);
        String username = OpenShiftServerUtils.getProjectAttribute(project, SETTING_USERNAME, null);
        return appName != null && appId != null && domain != null && (connectionUrl != null || username != null);
    }

    public static IProject findProjectForApplication(IApplication application) {
        IProject[] p = OpenShiftServerUtils.findProjectsForApplication(application);
        return p == null ? null : (p.length == 0 ? null : p[0]);
    }

    public static void updateOpenshiftProjectSettings(IProject project, IApplication app, IDomain domain, Connection connection, String remoteName, String deployFolder) {
        String qualifier = QUALIFIER;
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode(qualifier);
        node.put(SETTING_APPLICATION_ID, app.getUUID());
        node.put(SETTING_APPLICATION_NAME, app.getName());
        node.put(SETTING_DOMAIN_ID, app.getDomain().getId());
        OpenShiftServerUtils.setConnectionUrl(connection, node);
        node.put(SETTING_REMOTE_NAME, remoteName);
        if (!StringUtils.isEmpty(deployFolder)) {
            node.put(SETTING_DEPLOY_FOLDER_NAME, deployFolder);
        }
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            OpenShiftCoreActivator.pluginLog().logError((Throwable)e);
        }
    }

    private static void setConnectionUrl(Connection connection, IEclipsePreferences node) {
        try {
            ConnectionURL connectionUrl = ConnectionURL.forConnection(connection);
            node.put(SETTING_CONNECTIONURL, connectionUrl.toString());
            if (OpenShiftServerUtils.hasUsername(node)) {
                node.put(SETTING_USERNAME, connection.getUsername());
            }
        }
        catch (UnsupportedEncodingException e) {
            OpenShiftCoreActivator.pluginLog().logError(NLS.bind((String)"Could not get connection url for connection {0}/{1}", (Object)connection.getUsername(), (Object)connection.getHost()), (Throwable)e);
        }
        catch (MalformedURLException e) {
            OpenShiftCoreActivator.pluginLog().logError(NLS.bind((String)"Could not get connection url for connection {0}/{1}", (Object)connection.getUsername(), (Object)connection.getHost()), (Throwable)e);
        }
    }

    private static boolean hasUsername(IEclipsePreferences node) {
        return node.get(SETTING_USERNAME, null) != null;
    }

    public static IServer setDeployProject(IServer server, String val) throws CoreException {
        IServerWorkingCopy wc = server.createWorkingCopy();
        wc.setAttribute(ATTRIBUTE_DEPLOY_PROJECT, val);
        return wc.save(false, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IServer setRemoteName(IServer server, String val) throws CoreException {
        IServerWorkingCopy wc = server.createWorkingCopy();
        wc.setAttribute(ATTRIBUTE_REMOTE_NAME, val);
        return wc.save(false, (IProgressMonitor)new NullProgressMonitor());
    }

    @Deprecated
    public static IServer setExpressApplication(IServer server, String val) throws CoreException {
        IServerWorkingCopy wc = server.createWorkingCopy();
        wc.setAttribute(ATTRIBUTE_APPLICATION_NAME, val);
        return wc.save(false, (IProgressMonitor)new NullProgressMonitor());
    }

    @Deprecated
    public static IServer setExpressDomain(IServer server, String val) throws CoreException {
        IServerWorkingCopy wc = server.createWorkingCopy();
        wc.setAttribute(ATTRIBUTE_DOMAIN, val);
        return wc.save(false, (IProgressMonitor)new NullProgressMonitor());
    }

    @Deprecated
    public static IServer setExpressUsername(IServer server, String val) throws CoreException {
        IServerWorkingCopy wc = server.createWorkingCopy();
        wc.setAttribute(ATTRIBUTE_USERNAME, val);
        return wc.save(false, (IProgressMonitor)new NullProgressMonitor());
    }

    public static int countCommitableChanges(IProject project, IServer server, IProgressMonitor monitor) throws CoreException {
        Collection<String> commitableChanges = new GitIndexDiffBuilder(EGitUtils.checkedGetRepository((IProject)project)).conflicting(false).missing(false).build(monitor);
        return commitableChanges.size();
    }

    public static String[] toNames(IProject[] projects) {
        if (projects == null) {
            return new String[0];
        }
        String[] names = new String[projects.length];
        int i = 0;
        while (i < projects.length) {
            names[i] = projects[i].getName();
            ++i;
        }
        return names;
    }

    public static String[] toNames(List<IApplication> apps) {
        if (apps == null) {
            return new String[0];
        }
        String[] appNames = new String[apps.size()];
        int i = 0;
        while (i < apps.size()) {
            appNames[i] = apps.get(i).getName();
            ++i;
        }
        return appNames;
    }

    public static class GitIndexDiffBuilder {
        private Repository repository;
        private boolean added = true;
        private boolean changed = true;
        private boolean conflicting = true;
        private boolean missing = true;
        private boolean modified = true;
        private boolean removed = true;
        private boolean untracked = true;

        GitIndexDiffBuilder(Repository repository) {
            this.repository = repository;
        }

        public GitIndexDiffBuilder added(boolean filter) {
            this.added = filter;
            return this;
        }

        public GitIndexDiffBuilder changed(boolean filter) {
            this.changed = filter;
            return this;
        }

        public GitIndexDiffBuilder conflicting(boolean filter) {
            this.conflicting = filter;
            return this;
        }

        public GitIndexDiffBuilder missing(boolean filter) {
            this.missing = filter;
            return this;
        }

        public GitIndexDiffBuilder modified(boolean filter) {
            this.modified = filter;
            return this;
        }

        public GitIndexDiffBuilder removed(boolean filter) {
            this.removed = filter;
            return this;
        }

        public GitIndexDiffBuilder untracked(boolean filter) {
            this.untracked = filter;
            return this;
        }

        public Collection<String> build(IProgressMonitor monitor) throws CoreException {
            try {
                HashSet<String> resources = new HashSet<String>();
                IndexDiff diff = EGitUtils.getIndexChanges((Repository)this.repository, (IProgressMonitor)monitor);
                if (diff != null) {
                    if (this.added) {
                        resources.addAll(diff.getAdded());
                    }
                    if (this.changed) {
                        resources.addAll(diff.getChanged());
                    }
                    if (this.conflicting) {
                        resources.addAll(diff.getConflicting());
                    }
                    if (this.missing) {
                        resources.addAll(diff.getMissing());
                    }
                    if (this.modified) {
                        resources.addAll(diff.getModified());
                    }
                    if (this.removed) {
                        resources.addAll(diff.getRemoved());
                    }
                    if (this.untracked) {
                        resources.addAll(diff.getUntracked());
                    }
                }
                return resources;
            }
            catch (IOException ioe) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.tools.openshift.egit.core", "Unable to count commitable resources", (Throwable)ioe));
            }
        }
    }
}

